/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.io.vavr.jackson.datatype.serialize;

import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonGenerator;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.JavaType;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import io.mantisrx.shaded.io.vavr.jackson.datatype.serialize.HListSerializer;
import io.vavr.control.Option;
import java.io.IOException;

class OptionSerializer
extends HListSerializer<Option<?>> {
    private static final long serialVersionUID = 1L;
    private final boolean plainMode;

    OptionSerializer(JavaType contentType, boolean plainMode) {
        super(contentType);
        this.plainMode = plainMode;
    }

    @Override
    public void serialize(Option<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this.plainMode) {
            if (value.isDefined()) {
                this.write(value.get(), 0, gen, provider);
            } else {
                gen.writeNull();
            }
        } else {
            gen.writeStartArray();
            if (value.isDefined()) {
                gen.writeString("defined");
                this.write(value.get(), 0, gen, provider);
            } else {
                gen.writeString("undefined");
            }
            gen.writeEndArray();
        }
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Option<?> value) {
        return value.isEmpty();
    }
}

