/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.cli;

import io.mantisrx.shaded.org.apache.zookeeper.KeeperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliCommand;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliParseException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.CliWrapperException;
import io.mantisrx.shaded.org.apache.zookeeper.cli.MalformedPathException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class GetEphemeralsCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;

    public GetEphemeralsCommand() {
        super("getEphemerals", "path");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        CommandLine cl;
        PosixParser parser = new PosixParser();
        try {
            cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = cl.getArgs();
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        List<String> ephemerals;
        try {
            if (this.args.length < 2) {
                ephemerals = this.zk.getEphemerals();
            } else {
                String path = this.args[1];
                ephemerals = this.zk.getEphemerals(path);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (KeeperException | InterruptedException ex) {
            throw new CliWrapperException(ex);
        }
        this.out.println(ephemerals);
        return false;
    }
}

