/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.WatchedEvent;
import io.mantisrx.shaded.org.apache.zookeeper.data.Id;
import io.mantisrx.shaded.org.apache.zookeeper.data.Stat;
import io.mantisrx.shaded.org.apache.zookeeper.proto.ReplyHeader;
import io.mantisrx.shaded.org.apache.zookeeper.proto.WatcherEvent;
import io.mantisrx.shaded.org.apache.zookeeper.server.ClientCnxnLimitException;
import io.mantisrx.shaded.org.apache.zookeeper.server.NIOServerCnxnFactory;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxn;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerCnxnFactory;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerStats;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperSaslServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooTrace;
import io.mantisrx.shaded.org.apache.zookeeper.server.command.CommandExecutor;
import io.mantisrx.shaded.org.apache.zookeeper.server.command.FourLetterCommands;
import io.mantisrx.shaded.org.apache.zookeeper.server.command.NopCommand;
import io.mantisrx.shaded.org.apache.zookeeper.server.command.SetTraceMaskCommand;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NIOServerCnxn
extends ServerCnxn {
    private static final Logger LOG = LoggerFactory.getLogger(NIOServerCnxn.class);
    private final NIOServerCnxnFactory factory;
    private final SocketChannel sock;
    private final NIOServerCnxnFactory.SelectorThread selectorThread;
    private final SelectionKey sk;
    private boolean initialized;
    private final ByteBuffer lenBuffer;
    private ByteBuffer incomingBuffer;
    private final Queue<ByteBuffer> outgoingBuffers;
    private int sessionTimeout;
    private long sessionId;
    private final AtomicBoolean selectable;
    private final AtomicBoolean throttled;
    private static final ByteBuffer packetSentinel = ByteBuffer.allocate(0);

    public NIOServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, NIOServerCnxnFactory.SelectorThread selectorThread) throws IOException {
        super(zk);
        this.incomingBuffer = this.lenBuffer = ByteBuffer.allocate(4);
        this.outgoingBuffers = new LinkedBlockingQueue<ByteBuffer>();
        this.selectable = new AtomicBoolean(true);
        this.throttled = new AtomicBoolean(false);
        this.sock = sock;
        this.sk = sk;
        this.factory = factory;
        this.selectorThread = selectorThread;
        if (this.factory.login != null) {
            this.zooKeeperSaslServer = new ZooKeeperSaslServer(factory.login);
        }
        sock.socket().setTcpNoDelay(true);
        sock.socket().setSoLinger(false, -1);
        InetAddress addr = ((InetSocketAddress)sock.socket().getRemoteSocketAddress()).getAddress();
        this.addAuthInfo(new Id("ip", addr.getHostAddress()));
        this.sessionTimeout = factory.sessionlessCnxnTimeout;
    }

    @Override
    public void sendCloseSession() {
        this.sendBuffer(ServerCnxnFactory.closeConn);
    }

    void sendBufferSync(ByteBuffer bb) {
        try {
            if (bb != ServerCnxnFactory.closeConn) {
                if (this.sock.isOpen()) {
                    this.sock.configureBlocking(true);
                    this.sock.write(bb);
                }
                this.packetSent();
            }
        }
        catch (IOException ie) {
            LOG.error("Error sending data synchronously ", (Throwable)ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBuffer(ByteBuffer ... buffers) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Add a buffer to outgoingBuffers, sk {} is valid: {}", (Object)this.sk, (Object)this.sk.isValid());
        }
        Queue<ByteBuffer> queue = this.outgoingBuffers;
        synchronized (queue) {
            for (ByteBuffer buffer : buffers) {
                this.outgoingBuffers.add(buffer);
            }
            this.outgoingBuffers.add(packetSentinel);
        }
        this.requestInterestOpsUpdate();
    }

    private void handleFailedRead() throws ServerCnxn.EndOfStreamException {
        this.setStale();
        ServerMetrics.getMetrics().CONNECTION_DROP_COUNT.add(1L);
        throw new ServerCnxn.EndOfStreamException("Unable to read additional data from client, it probably closed the socket: address = " + this.sock.socket().getRemoteSocketAddress() + ", session = 0x" + Long.toHexString(this.sessionId), ServerCnxn.DisconnectReason.UNABLE_TO_READ_FROM_CLIENT);
    }

    private void readPayload() throws IOException, InterruptedException, ClientCnxnLimitException {
        int rc;
        if (this.incomingBuffer.remaining() != 0 && (rc = this.sock.read(this.incomingBuffer)) < 0) {
            this.handleFailedRead();
        }
        if (this.incomingBuffer.remaining() == 0) {
            this.incomingBuffer.flip();
            this.packetReceived(4 + this.incomingBuffer.remaining());
            if (!this.initialized) {
                this.readConnectRequest();
            } else {
                this.readRequest();
            }
            this.lenBuffer.clear();
            this.incomingBuffer = this.lenBuffer;
        }
    }

    public boolean isSelectable() {
        return this.sk.isValid() && this.selectable.get();
    }

    public void disableSelectable() {
        this.selectable.set(false);
    }

    public void enableSelectable() {
        this.selectable.set(true);
    }

    private void requestInterestOpsUpdate() {
        if (this.isSelectable()) {
            this.selectorThread.addInterestOpsUpdateRequest(this.sk);
        }
    }

    void handleWrite(SelectionKey k) throws IOException {
        if (this.outgoingBuffers.isEmpty()) {
            return;
        }
        ByteBuffer directBuffer = NIOServerCnxnFactory.getDirectBuffer();
        if (directBuffer == null) {
            ByteBuffer bb;
            ByteBuffer[] bufferList = new ByteBuffer[this.outgoingBuffers.size()];
            this.sock.write(this.outgoingBuffers.toArray(bufferList));
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested", ServerCnxn.DisconnectReason.CLIENT_CLOSED_CONNECTION);
                }
                if (bb == packetSentinel) {
                    this.packetSent();
                }
                if (bb.remaining() <= 0) {
                    this.outgoingBuffers.remove();
                    continue;
                }
                break;
            }
        } else {
            ByteBuffer bb;
            directBuffer.clear();
            for (ByteBuffer b : this.outgoingBuffers) {
                if (directBuffer.remaining() < b.remaining()) {
                    b = (ByteBuffer)b.slice().limit(directBuffer.remaining());
                }
                int p = b.position();
                directBuffer.put(b);
                b.position(p);
                if (directBuffer.remaining() != 0) continue;
                break;
            }
            directBuffer.flip();
            int sent = this.sock.write(directBuffer);
            while ((bb = this.outgoingBuffers.peek()) != null) {
                if (bb == ServerCnxnFactory.closeConn) {
                    throw new ServerCnxn.CloseRequestException("close requested", ServerCnxn.DisconnectReason.CLIENT_CLOSED_CONNECTION);
                }
                if (bb == packetSentinel) {
                    this.packetSent();
                }
                if (sent < bb.remaining()) {
                    bb.position(bb.position() + sent);
                    break;
                }
                sent -= bb.remaining();
                this.outgoingBuffers.remove();
            }
        }
    }

    protected boolean isSocketOpen() {
        return this.sock.isOpen();
    }

    void doIO(SelectionKey k) throws InterruptedException {
        try {
            if (!this.isSocketOpen()) {
                LOG.warn("trying to do i/o on a null socket for session: 0x{}", (Object)Long.toHexString(this.sessionId));
                return;
            }
            if (k.isReadable()) {
                int rc = this.sock.read(this.incomingBuffer);
                if (rc < 0) {
                    this.handleFailedRead();
                }
                if (this.incomingBuffer.remaining() == 0) {
                    boolean isPayload;
                    if (this.incomingBuffer == this.lenBuffer) {
                        this.incomingBuffer.flip();
                        isPayload = this.readLength(k);
                        this.incomingBuffer.clear();
                    } else {
                        isPayload = true;
                    }
                    if (isPayload) {
                        this.readPayload();
                    } else {
                        return;
                    }
                }
            }
            if (k.isWritable()) {
                this.handleWrite(k);
                if (!(this.initialized || this.getReadInterest() || this.getWriteInterest())) {
                    throw new ServerCnxn.CloseRequestException("responded to info probe", ServerCnxn.DisconnectReason.INFO_PROBE);
                }
            }
        }
        catch (CancelledKeyException e) {
            LOG.warn("CancelledKeyException causing close of session: 0x{}", (Object)Long.toHexString(this.sessionId));
            LOG.debug("CancelledKeyException stack trace", (Throwable)e);
            this.close(ServerCnxn.DisconnectReason.CANCELLED_KEY_EXCEPTION);
        }
        catch (ServerCnxn.CloseRequestException e) {
            this.close();
        }
        catch (ServerCnxn.EndOfStreamException e) {
            LOG.warn("Unexpected exception", (Throwable)e);
            this.close(e.getReason());
        }
        catch (ClientCnxnLimitException e) {
            ServerMetrics.getMetrics().CONNECTION_REJECTED.add(1L);
            LOG.warn("Closing session 0x{}", (Object)Long.toHexString(this.sessionId), (Object)e);
            this.close(ServerCnxn.DisconnectReason.CLIENT_CNX_LIMIT);
        }
        catch (IOException e) {
            LOG.warn("Close of session 0x{}", (Object)Long.toHexString(this.sessionId), (Object)e);
            this.close(ServerCnxn.DisconnectReason.IO_EXCEPTION);
        }
    }

    private void readRequest() throws IOException {
        this.zkServer.processPacket(this, this.incomingBuffer);
    }

    private boolean getWriteInterest() {
        return !this.outgoingBuffers.isEmpty();
    }

    private boolean getReadInterest() {
        return !this.throttled.get();
    }

    @Override
    public void disableRecv(boolean waitDisableRecv) {
        if (this.throttled.compareAndSet(false, true)) {
            this.requestInterestOpsUpdate();
        }
    }

    @Override
    public void enableRecv() {
        if (this.throttled.compareAndSet(true, false)) {
            this.requestInterestOpsUpdate();
        }
    }

    private void readConnectRequest() throws IOException, InterruptedException, ClientCnxnLimitException {
        if (!this.isZKServerRunning()) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.zkServer.processConnectRequest(this, this.incomingBuffer);
        this.initialized = true;
    }

    private boolean checkFourLetterWord(SelectionKey k, int len) throws IOException {
        if (!FourLetterCommands.isKnown(len)) {
            return false;
        }
        String cmd = FourLetterCommands.getCommandString(len);
        this.packetReceived(4L);
        if (k != null) {
            try {
                k.cancel();
            }
            catch (Exception e) {
                LOG.error("Error cancelling command selection key", (Throwable)e);
            }
        }
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (!FourLetterCommands.isEnabled(cmd)) {
            LOG.debug("Command {} is not executed because it is not in the whitelist.", (Object)cmd);
            NopCommand nopCmd = new NopCommand(pwriter, this, cmd + " is not executed because it is not in the whitelist.");
            nopCmd.start();
            return true;
        }
        LOG.info("Processing {} command from {}", (Object)cmd, (Object)this.sock.socket().getRemoteSocketAddress());
        if (len == FourLetterCommands.setTraceMaskCmd) {
            this.incomingBuffer = ByteBuffer.allocate(8);
            int rc = this.sock.read(this.incomingBuffer);
            if (rc < 0) {
                throw new IOException("Read error");
            }
            this.incomingBuffer.flip();
            long traceMask = this.incomingBuffer.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, this, traceMask);
            setMask.start();
            return true;
        }
        CommandExecutor commandExecutor = new CommandExecutor();
        return commandExecutor.execute(this, pwriter, len, this.zkServer, this.factory);
    }

    private boolean readLength(SelectionKey k) throws IOException {
        int len = this.lenBuffer.getInt();
        if (!this.initialized && this.checkFourLetterWord(this.sk, len)) {
            return false;
        }
        if (len < 0 || len > BinaryInputArchive.maxBuffer) {
            throw new IOException("Len error " + len);
        }
        if (!this.isZKServerRunning()) {
            throw new IOException("ZooKeeperServer not running");
        }
        this.zkServer.checkRequestSizeWhenReceivingMessage(len);
        this.incomingBuffer = ByteBuffer.allocate(len);
        return true;
    }

    boolean isZKServerRunning() {
        return this.zkServer != null && this.zkServer.isRunning();
    }

    @Override
    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    @Override
    public String toString() {
        return "ip: " + this.sock.socket().getRemoteSocketAddress() + " sessionId: 0x" + Long.toHexString(this.sessionId);
    }

    @Override
    public void close(ServerCnxn.DisconnectReason reason) {
        this.disconnectReason = reason;
        this.close();
    }

    private void close() {
        this.setStale();
        if (!this.factory.removeCnxn(this)) {
            return;
        }
        if (this.zkServer != null) {
            this.zkServer.removeCnxn(this);
        }
        if (this.sk != null) {
            try {
                this.sk.cancel();
            }
            catch (Exception e) {
                LOG.debug("ignoring exception during selectionkey cancel", (Throwable)e);
            }
        }
        this.closeSock();
    }

    private void closeSock() {
        if (!this.sock.isOpen()) {
            return;
        }
        String logMsg = String.format("Closed socket connection for client %s %s", this.sock.socket().getRemoteSocketAddress(), this.sessionId != 0L ? "which had sessionid 0x" + Long.toHexString(this.sessionId) : "(no session established for client)");
        LOG.debug(logMsg);
        NIOServerCnxn.closeSock(this.sock);
    }

    public static void closeSock(SocketChannel sock) {
        if (!sock.isOpen()) {
            return;
        }
        try {
            sock.socket().shutdownOutput();
        }
        catch (IOException e) {
            LOG.debug("ignoring exception during output shutdown", (Throwable)e);
        }
        try {
            sock.socket().shutdownInput();
        }
        catch (IOException e) {
            LOG.debug("ignoring exception during input shutdown", (Throwable)e);
        }
        try {
            sock.socket().close();
        }
        catch (IOException e) {
            LOG.debug("ignoring exception during socket close", (Throwable)e);
        }
        try {
            sock.close();
        }
        catch (IOException e) {
            LOG.debug("ignoring exception during socketchannel close", (Throwable)e);
        }
    }

    @Override
    public void sendResponse(ReplyHeader h, Record r, String tag, String cacheKey, Stat stat, int opCode) {
        try {
            this.sendBuffer(this.serialize(h, r, tag, cacheKey, stat, opCode));
            this.decrOutstandingAndCheckThrottle(h);
        }
        catch (Exception e) {
            LOG.warn("Unexpected exception. Destruction averted.", (Throwable)e);
        }
    }

    @Override
    public void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        this.sendResponse(h, e, "notification", null, null, -1);
    }

    @Override
    public long getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
        this.factory.addSession(sessionId, this);
    }

    @Override
    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
        this.factory.touchCnxn(this);
    }

    @Override
    public int getInterestOps() {
        if (!this.isSelectable()) {
            return 0;
        }
        int interestOps = 0;
        if (this.getReadInterest()) {
            interestOps |= 1;
        }
        if (this.getWriteInterest()) {
            interestOps |= 4;
        }
        return interestOps;
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return (InetSocketAddress)this.sock.socket().getRemoteSocketAddress();
    }

    public InetAddress getSocketAddress() {
        if (!this.sock.isOpen()) {
            return null;
        }
        return this.sock.socket().getInetAddress();
    }

    @Override
    protected ServerStats serverStats() {
        if (this.zkServer == null) {
            return null;
        }
        return this.zkServer.serverStats();
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public Certificate[] getClientCertificateChain() {
        throw new UnsupportedOperationException("SSL is unsupported in NIOServerCnxn");
    }

    @Override
    public void setClientCertificateChain(Certificate[] chain) {
        throw new UnsupportedOperationException("SSL is unsupported in NIOServerCnxn");
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NIOServerCnxn.this.sendBufferSync(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        @Override
        public void flush() throws IOException {
            this.checkFlush(true);
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }
}

