/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server;

import io.mantisrx.shaded.org.apache.zookeeper.common.Time;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperCriticalThread;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperServer;
import io.mantisrx.shaded.org.apache.zookeeper.server.ZooKeeperThread;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncRequestProcessor
extends ZooKeeperCriticalThread
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SyncRequestProcessor.class);
    private static final Request REQUEST_OF_DEATH = Request.requestOfDeath;
    private static int snapCount = ZooKeeperServer.getSnapCount();
    private static long snapSizeInBytes = ZooKeeperServer.getSnapSizeInBytes();
    private int randRoll;
    private long randSize;
    private final BlockingQueue<Request> queuedRequests = new LinkedBlockingQueue<Request>();
    private final Semaphore snapThreadMutex = new Semaphore(1);
    private final ZooKeeperServer zks;
    private final RequestProcessor nextProcessor;
    private final Queue<Request> toFlush;
    private long lastFlushTime;

    public SyncRequestProcessor(ZooKeeperServer zks, RequestProcessor nextProcessor) {
        super("SyncThread:" + zks.getServerId(), zks.getZooKeeperServerListener());
        this.zks = zks;
        this.nextProcessor = nextProcessor;
        this.toFlush = new ArrayDeque<Request>(zks.getMaxBatchSize());
    }

    public static void setSnapCount(int count) {
        snapCount = count;
    }

    public static int getSnapCount() {
        return snapCount;
    }

    private long getRemainingDelay() {
        long flushDelay = this.zks.getFlushDelay();
        long duration = Time.currentElapsedTime() - this.lastFlushTime;
        if (duration < flushDelay) {
            return flushDelay - duration;
        }
        return 0L;
    }

    private boolean shouldFlush() {
        long flushDelay = this.zks.getFlushDelay();
        long maxBatchSize = this.zks.getMaxBatchSize();
        if (flushDelay > 0L && this.getRemainingDelay() == 0L) {
            return true;
        }
        return maxBatchSize > 0L && (long)this.toFlush.size() >= maxBatchSize;
    }

    public static void setSnapSizeInBytes(long size) {
        snapSizeInBytes = size;
    }

    private boolean shouldSnapshot() {
        int logCount = this.zks.getZKDatabase().getTxnCount();
        long logSize = this.zks.getZKDatabase().getTxnSize();
        return logCount > snapCount / 2 + this.randRoll || snapSizeInBytes > 0L && logSize > snapSizeInBytes / 2L + this.randSize;
    }

    private void resetSnapshotStats() {
        this.randRoll = ThreadLocalRandom.current().nextInt(snapCount / 2);
        this.randSize = Math.abs(ThreadLocalRandom.current().nextLong() % (snapSizeInBytes / 2L));
    }

    @Override
    public void run() {
        try {
            this.resetSnapshotStats();
            this.lastFlushTime = Time.currentElapsedTime();
            while (true) {
                ServerMetrics.getMetrics().SYNC_PROCESSOR_QUEUE_SIZE.add(this.queuedRequests.size());
                long pollTime = Math.min(this.zks.getMaxWriteQueuePollTime(), this.getRemainingDelay());
                Request si = this.queuedRequests.poll(pollTime, TimeUnit.MILLISECONDS);
                if (si == null) {
                    this.flush();
                    si = this.queuedRequests.take();
                }
                if (si != REQUEST_OF_DEATH) {
                    long startProcessTime = Time.currentElapsedTime();
                    ServerMetrics.getMetrics().SYNC_PROCESSOR_QUEUE_TIME.add(startProcessTime - si.syncQueueStartTime);
                    if (this.zks.getZKDatabase().append(si)) {
                        if (this.shouldSnapshot()) {
                            this.resetSnapshotStats();
                            this.zks.getZKDatabase().rollLog();
                            if (!this.snapThreadMutex.tryAcquire()) {
                                LOG.warn("Too busy to snap, skipping");
                            } else {
                                new ZooKeeperThread("Snapshot Thread"){

                                    @Override
                                    public void run() {
                                        try {
                                            SyncRequestProcessor.this.zks.takeSnapshot();
                                        }
                                        catch (Exception e) {
                                            LOG.warn("Unexpected exception", (Throwable)e);
                                        }
                                        finally {
                                            SyncRequestProcessor.this.snapThreadMutex.release();
                                        }
                                    }
                                }.start();
                            }
                        }
                    } else if (this.toFlush.isEmpty()) {
                        if (this.nextProcessor == null) continue;
                        this.nextProcessor.processRequest(si);
                        if (!(this.nextProcessor instanceof Flushable)) continue;
                        ((Flushable)((Object)this.nextProcessor)).flush();
                        continue;
                    }
                    this.toFlush.add(si);
                    if (this.shouldFlush()) {
                        this.flush();
                    }
                    ServerMetrics.getMetrics().SYNC_PROCESS_TIME.add(Time.currentElapsedTime() - startProcessTime);
                    continue;
                }
                break;
            }
        }
        catch (Throwable t) {
            this.handleException(this.getName(), t);
        }
        LOG.info("SyncRequestProcessor exited!");
    }

    private void flush() throws IOException, RequestProcessor.RequestProcessorException {
        if (this.toFlush.isEmpty()) {
            return;
        }
        ServerMetrics.getMetrics().BATCH_SIZE.add(this.toFlush.size());
        long flushStartTime = Time.currentElapsedTime();
        this.zks.getZKDatabase().commit();
        ServerMetrics.getMetrics().SYNC_PROCESSOR_FLUSH_TIME.add(Time.currentElapsedTime() - flushStartTime);
        if (this.nextProcessor == null) {
            this.toFlush.clear();
        } else {
            while (!this.toFlush.isEmpty()) {
                Request i = this.toFlush.remove();
                long latency = Time.currentElapsedTime() - i.syncQueueStartTime;
                ServerMetrics.getMetrics().SYNC_PROCESSOR_QUEUE_AND_FLUSH_TIME.add(latency);
                this.nextProcessor.processRequest(i);
            }
            if (this.nextProcessor instanceof Flushable) {
                ((Flushable)((Object)this.nextProcessor)).flush();
            }
            this.lastFlushTime = Time.currentElapsedTime();
        }
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down");
        this.queuedRequests.add(REQUEST_OF_DEATH);
        try {
            this.join();
            this.flush();
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while wating for {} to finish", (Object)this);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            LOG.warn("Got IO exception during shutdown");
        }
        catch (RequestProcessor.RequestProcessorException e) {
            LOG.warn("Got request processor exception during shutdown");
        }
        if (this.nextProcessor != null) {
            this.nextProcessor.shutdown();
        }
    }

    @Override
    public void processRequest(Request request) {
        Objects.requireNonNull(request, "Request cannot be null");
        request.syncQueueStartTime = Time.currentElapsedTime();
        this.queuedRequests.add(request);
        ServerMetrics.getMetrics().SYNC_PROCESSOR_QUEUED.add(1L);
    }
}

