/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.persistence;

import io.mantisrx.shaded.org.apache.jute.BinaryInputArchive;
import io.mantisrx.shaded.org.apache.jute.BinaryOutputArchive;
import io.mantisrx.shaded.org.apache.jute.Record;
import io.mantisrx.shaded.org.apache.zookeeper.server.ExitCode;
import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.TxnLogEntry;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileHeader;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FilePadding;
import io.mantisrx.shaded.org.apache.zookeeper.server.persistence.FileTxnLog;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.LogChopper;
import io.mantisrx.shaded.org.apache.zookeeper.server.util.SerializeUtils;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateContainerTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTTLTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.CreateTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.MultiTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.SetDataTxn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.Txn;
import io.mantisrx.shaded.org.apache.zookeeper.txn.TxnHeader;
import io.mantisrx.shaded.org.apache.zookeeper.util.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import java.util.zip.Adler32;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class TxnLogToolkit
implements Closeable {
    private File txnLogFile;
    private boolean recoveryMode = false;
    private boolean verbose = false;
    private FileInputStream txnFis;
    private BinaryInputArchive logStream;
    private int crcFixed = 0;
    private FileOutputStream recoveryFos;
    private BinaryOutputArchive recoveryOa;
    private File recoveryLogFile;
    private FilePadding filePadding = new FilePadding();
    private boolean force = false;
    private long zxid = -1L;

    public static void main(String[] args) throws Exception {
        try (TxnLogToolkit lt = TxnLogToolkit.parseCommandLine(args);){
            if (lt.isDumpMode()) {
                lt.dump(new Scanner(System.in));
                lt.printStat();
            } else {
                lt.chop();
            }
        }
        catch (TxnLogToolkitParseException e) {
            System.err.println(e.getMessage() + "\n");
            TxnLogToolkit.printHelpAndExit(e.getExitCode(), e.getOptions());
        }
        catch (TxnLogToolkitException e) {
            System.err.println(e.getMessage());
            ServiceUtils.requestSystemExit(e.getExitCode());
        }
    }

    public TxnLogToolkit(boolean recoveryMode, boolean verbose, String txnLogFileName, boolean force) throws FileNotFoundException, TxnLogToolkitException {
        this.recoveryMode = recoveryMode;
        this.verbose = verbose;
        this.force = force;
        this.txnLogFile = this.loadTxnFile(txnLogFileName);
        if (recoveryMode) {
            this.recoveryLogFile = new File(this.txnLogFile.toString() + ".fixed");
            if (this.recoveryLogFile.exists()) {
                throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "Recovery file %s already exists or not writable", this.recoveryLogFile);
            }
        }
        this.openTxnLogFile();
        if (recoveryMode) {
            this.openRecoveryFile();
        }
    }

    public TxnLogToolkit(String txnLogFileName, String zxidName) throws TxnLogToolkitException {
        this.txnLogFile = this.loadTxnFile(txnLogFileName);
        this.zxid = Long.decode(zxidName);
    }

    private File loadTxnFile(String txnLogFileName) throws TxnLogToolkitException {
        File logFile = new File(txnLogFileName);
        if (!logFile.exists() || !logFile.canRead()) {
            throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "File doesn't exist or not readable: %s", logFile);
        }
        return logFile;
    }

    public void dump(Scanner scanner) throws Exception {
        this.crcFixed = 0;
        FileHeader fhdr = new FileHeader();
        fhdr.deserialize(this.logStream, "fileheader");
        if (fhdr.getMagic() != FileTxnLog.TXNLOG_MAGIC) {
            throw new TxnLogToolkitException(ExitCode.INVALID_INVOCATION.getValue(), "Invalid magic number for %s", this.txnLogFile.getName());
        }
        System.out.println("ZooKeeper Transactional Log File with dbid " + fhdr.getDbid() + " txnlog format version " + fhdr.getVersion());
        if (this.recoveryMode) {
            fhdr.serialize(this.recoveryOa, "fileheader");
            this.recoveryFos.flush();
            this.filePadding.setCurrentSize(this.recoveryFos.getChannel().position());
        }
        int count = 0;
        while (true) {
            byte[] bytes;
            long crcValue;
            try {
                crcValue = this.logStream.readLong("crcvalue");
                bytes = this.logStream.readBuffer("txnEntry");
            }
            catch (EOFException e) {
                System.out.println("EOF reached after " + count + " txns.");
                return;
            }
            if (bytes.length == 0) {
                System.out.println("EOF reached after " + count + " txns.");
                return;
            }
            Adler32 crc = new Adler32();
            crc.update(bytes, 0, bytes.length);
            if (crcValue != crc.getValue()) {
                if (this.recoveryMode) {
                    if (!this.force) {
                        this.printTxn(bytes, "CRC ERROR");
                        if (this.askForFix(scanner)) {
                            crcValue = crc.getValue();
                            ++this.crcFixed;
                        }
                    } else {
                        crcValue = crc.getValue();
                        this.printTxn(bytes, "CRC FIXED");
                        ++this.crcFixed;
                    }
                } else {
                    this.printTxn(bytes, "CRC ERROR");
                }
            }
            if (!this.recoveryMode || this.verbose) {
                this.printTxn(bytes);
            }
            if (this.logStream.readByte("EOR") != 66) {
                throw new TxnLogToolkitException(ExitCode.UNEXPECTED_ERROR.getValue(), "Last transaction was partial.", new Object[0]);
            }
            if (this.recoveryMode) {
                this.filePadding.padFile(this.recoveryFos.getChannel());
                this.recoveryOa.writeLong(crcValue, "crcvalue");
                this.recoveryOa.writeBuffer(bytes, "txnEntry");
                this.recoveryOa.writeByte((byte)66, "EOR");
            }
            ++count;
        }
    }

    public void chop() {
        File targetFile = new File(this.txnLogFile.getParentFile(), this.txnLogFile.getName() + ".chopped" + this.zxid);
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.txnLogFile));
             BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(targetFile));){
            if (!LogChopper.chop(is, os, this.zxid)) {
                throw new TxnLogToolkitException(ExitCode.INVALID_INVOCATION.getValue(), "Failed to chop %s", this.txnLogFile.getName());
            }
        }
        catch (Exception e) {
            System.out.println("Got exception: " + e.getMessage());
        }
    }

    public boolean isDumpMode() {
        return this.zxid < 0L;
    }

    private boolean askForFix(Scanner scanner) throws TxnLogToolkitException {
        while (true) {
            System.out.print("Would you like to fix it (Yes/No/Abort) ? ");
            char answer = Character.toUpperCase(scanner.next().charAt(0));
            switch (answer) {
                case 'Y': {
                    return true;
                }
                case 'N': {
                    return false;
                }
                case 'A': {
                    throw new TxnLogToolkitException(ExitCode.EXECUTION_FINISHED.getValue(), "Recovery aborted.", new Object[0]);
                }
            }
        }
    }

    private void printTxn(byte[] bytes) throws IOException {
        this.printTxn(bytes, "");
    }

    private void printTxn(byte[] bytes, String prefix) throws IOException {
        TxnLogEntry logEntry = SerializeUtils.deserializeTxn(bytes);
        TxnHeader hdr = logEntry.getHeader();
        Record txn = logEntry.getTxn();
        String txnStr = TxnLogToolkit.getFormattedTxnStr(txn);
        String txns = String.format("%s session 0x%s cxid 0x%s zxid 0x%s %s %s", DateFormat.getDateTimeInstance(3, 1).format(new Date(hdr.getTime())), Long.toHexString(hdr.getClientId()), Long.toHexString(hdr.getCxid()), Long.toHexString(hdr.getZxid()), Request.op2String(hdr.getType()), txnStr);
        if (prefix != null && !"".equals(prefix.trim())) {
            System.out.print(prefix + " - ");
        }
        if (txns.endsWith("\n")) {
            System.out.print(txns);
        } else {
            System.out.println(txns);
        }
    }

    private static String getFormattedTxnStr(Record txn) throws IOException {
        StringBuilder txnData = new StringBuilder();
        if (txn == null) {
            return txnData.toString();
        }
        if (txn instanceof CreateTxn) {
            CreateTxn createTxn = (CreateTxn)txn;
            txnData.append(createTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createTxn.getData())).append("," + createTxn.getAcl() + "," + createTxn.getEphemeral()).append("," + createTxn.getParentCVersion());
        } else if (txn instanceof SetDataTxn) {
            SetDataTxn setDataTxn = (SetDataTxn)txn;
            txnData.append(setDataTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(setDataTxn.getData())).append("," + setDataTxn.getVersion());
        } else if (txn instanceof CreateContainerTxn) {
            CreateContainerTxn createContainerTxn = (CreateContainerTxn)txn;
            txnData.append(createContainerTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createContainerTxn.getData())).append("," + createContainerTxn.getAcl() + "," + createContainerTxn.getParentCVersion());
        } else if (txn instanceof CreateTTLTxn) {
            CreateTTLTxn createTTLTxn = (CreateTTLTxn)txn;
            txnData.append(createTTLTxn.getPath() + "," + TxnLogToolkit.checkNullToEmpty(createTTLTxn.getData())).append("," + createTTLTxn.getAcl() + "," + createTTLTxn.getParentCVersion()).append("," + createTTLTxn.getTtl());
        } else if (txn instanceof MultiTxn) {
            MultiTxn multiTxn = (MultiTxn)txn;
            List<Txn> txnList = multiTxn.getTxns();
            for (int i = 0; i < txnList.size(); ++i) {
                Txn t = txnList.get(i);
                if (i == 0) {
                    txnData.append(Request.op2String(t.getType()) + ":" + TxnLogToolkit.checkNullToEmpty(t.getData()));
                    continue;
                }
                txnData.append(";" + Request.op2String(t.getType()) + ":" + TxnLogToolkit.checkNullToEmpty(t.getData()));
            }
        } else {
            txnData.append(txn.toString());
        }
        return txnData.toString();
    }

    private static String checkNullToEmpty(byte[] data) throws IOException {
        if (data == null || data.length == 0) {
            return "";
        }
        return new String(data, StandardCharsets.UTF_8);
    }

    private void openTxnLogFile() throws FileNotFoundException {
        this.txnFis = new FileInputStream(this.txnLogFile);
        this.logStream = BinaryInputArchive.getArchive(this.txnFis);
    }

    private void closeTxnLogFile() throws IOException {
        if (this.txnFis != null) {
            this.txnFis.close();
        }
    }

    private void openRecoveryFile() throws FileNotFoundException {
        this.recoveryFos = new FileOutputStream(this.recoveryLogFile);
        this.recoveryOa = BinaryOutputArchive.getArchive(this.recoveryFos);
    }

    private void closeRecoveryFile() throws IOException {
        if (this.recoveryFos != null) {
            this.recoveryFos.close();
        }
    }

    private static TxnLogToolkit parseCommandLine(String[] args) throws TxnLogToolkitException, FileNotFoundException {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        Option helpOpt = new Option("h", "help", false, "Print help message");
        options.addOption(helpOpt);
        Option recoverOpt = new Option("r", "recover", false, "Recovery mode. Re-calculate CRC for broken entries.");
        options.addOption(recoverOpt);
        Option quietOpt = new Option("v", "verbose", false, "Be verbose in recovery mode: print all entries, not just fixed ones.");
        options.addOption(quietOpt);
        Option dumpOpt = new Option("d", "dump", false, "Dump mode. Dump all entries of the log file with printing the content of a nodepath (default)");
        options.addOption(dumpOpt);
        Option forceOpt = new Option("y", "yes", false, "Non-interactive mode: repair all CRC errors without asking");
        options.addOption(forceOpt);
        Option chopOpt = new Option("c", "chop", false, "Chop mode. Chop txn file to a zxid.");
        Option zxidOpt = new Option("z", "zxid", true, "Used with chop. Zxid to which to chop.");
        options.addOption(chopOpt);
        options.addOption(zxidOpt);
        try {
            CommandLine cli = parser.parse(options, args);
            if (cli.hasOption("help")) {
                TxnLogToolkit.printHelpAndExit(0, options);
            }
            if (cli.getArgs().length < 1) {
                TxnLogToolkit.printHelpAndExit(1, options);
            }
            if (cli.hasOption("chop") && cli.hasOption("zxid")) {
                return new TxnLogToolkit(cli.getArgs()[0], cli.getOptionValue("zxid"));
            }
            return new TxnLogToolkit(cli.hasOption("recover"), cli.hasOption("verbose"), cli.getArgs()[0], cli.hasOption("yes"));
        }
        catch (ParseException e) {
            throw new TxnLogToolkitParseException(options, ExitCode.UNEXPECTED_ERROR.getValue(), e.getMessage(), new Object[0]);
        }
    }

    private static void printHelpAndExit(int exitCode, Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(120, "TxnLogToolkit [-dhrvc] <txn_log_file_name> (-z <zxid>)", "", options, "");
        ServiceUtils.requestSystemExit(exitCode);
    }

    private void printStat() {
        if (this.recoveryMode) {
            System.out.printf("Recovery file %s has been written with %d fixed CRC error(s)%n", this.recoveryLogFile, this.crcFixed);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.recoveryMode) {
            this.closeRecoveryFile();
        }
        this.closeTxnLogFile();
    }

    static class TxnLogToolkitParseException
    extends TxnLogToolkitException {
        private static final long serialVersionUID = 1L;
        private Options options;

        TxnLogToolkitParseException(Options options, int exitCode, String message, Object ... params) {
            super(exitCode, message, params);
            this.options = options;
        }

        Options getOptions() {
            return this.options;
        }
    }

    static class TxnLogToolkitException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private int exitCode;

        TxnLogToolkitException(int exitCode, String message, Object ... params) {
            super(String.format(message, params));
            this.exitCode = exitCode;
        }

        int getExitCode() {
            return this.exitCode;
        }
    }
}

