/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.apache.zookeeper.server.quorum;

import io.mantisrx.shaded.org.apache.zookeeper.server.Request;
import io.mantisrx.shaded.org.apache.zookeeper.server.RequestProcessor;
import io.mantisrx.shaded.org.apache.zookeeper.server.ServerMetrics;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.Leader;
import io.mantisrx.shaded.org.apache.zookeeper.server.quorum.QuorumPeer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AckRequestProcessor
implements RequestProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(AckRequestProcessor.class);
    Leader leader;

    AckRequestProcessor(Leader leader) {
        this.leader = leader;
    }

    @Override
    public void processRequest(Request request) {
        QuorumPeer self = this.leader.self;
        if (self != null) {
            request.logLatency(ServerMetrics.getMetrics().PROPOSAL_ACK_CREATION_LATENCY);
            this.leader.processAck(self.getId(), request.zxid, null);
        } else {
            LOG.error("Null QuorumPeer");
        }
    }

    @Override
    public void shutdown() {
    }
}

