/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.channel.socket.nio;

import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFuture;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelFutureListener;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelPipeline;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelState;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.Channels;
import io.mantisrx.shaded.org.jboss.netty.channel.MessageEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.AbstractNioChannelSink;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.BossPool;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioClientBoss;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioClientSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.channel.socket.nio.NioSocketChannel;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLogger;
import io.mantisrx.shaded.org.jboss.netty.logging.InternalLoggerFactory;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NioClientSocketPipelineSink
extends AbstractNioChannelSink {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioClientSocketPipelineSink.class);
    private final BossPool<NioClientBoss> bossPool;

    NioClientSocketPipelineSink(BossPool<NioClientBoss> bossPool) {
        this.bossPool = bossPool;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            NioClientSocketChannel channel = (NioClientSocketChannel)event.getChannel();
            ChannelFuture future = event.getFuture();
            ChannelState state = event.getState();
            Object value = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    channel.worker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        NioClientSocketPipelineSink.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    channel.worker.close(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    channel.worker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            NioSocketChannel channel = (NioSocketChannel)event.getChannel();
            boolean offered = channel.writeBufferQueue.offer(event);
            assert (offered);
            channel.worker.writeFromUserCode(channel);
        }
    }

    private static void bind(NioClientSocketChannel channel, ChannelFuture future, SocketAddress localAddress) {
        try {
            ((SocketChannel)channel.channel).socket().bind(localAddress);
            channel.boundManually = true;
            channel.setBound();
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private void connect(NioClientSocketChannel channel, final ChannelFuture cf, SocketAddress remoteAddress) {
        channel.requestedRemoteAddress = remoteAddress;
        try {
            if (((SocketChannel)channel.channel).connect(remoteAddress)) {
                channel.worker.register(channel, cf);
            } else {
                channel.getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (!cf.isDone()) {
                            cf.setFailure(new ClosedChannelException());
                        }
                    }
                });
                cf.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.connectFuture = cf;
                this.nextBoss().register(channel, cf);
            }
        }
        catch (Throwable t2) {
            ConnectException t2;
            if (t2 instanceof ConnectException) {
                ConnectException newT = new ConnectException(t2.getMessage() + ": " + remoteAddress);
                newT.setStackTrace(t2.getStackTrace());
                t2 = newT;
            }
            cf.setFailure(t2);
            Channels.fireExceptionCaught(channel, (Throwable)t2);
            channel.worker.close(channel, Channels.succeededFuture(channel));
        }
    }

    private NioClientBoss nextBoss() {
        return this.bossPool.nextBoss();
    }
}

