/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.shaded.org.jboss.netty.handler.codec.http;

import io.mantisrx.shaded.org.jboss.netty.buffer.ChannelBuffer;
import io.mantisrx.shaded.org.jboss.netty.channel.Channel;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelDownstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelStateEvent;
import io.mantisrx.shaded.org.jboss.netty.channel.ChannelUpstreamHandler;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.PrematureChannelClosureException;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpChunk;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMessage;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMessageDecoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpMethod;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequest;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpRequestEncoder;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponse;
import io.mantisrx.shaded.org.jboss.netty.handler.codec.http.HttpResponseDecoder;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class HttpClientCodec
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    final Queue<HttpMethod> queue = new ConcurrentLinkedQueue<HttpMethod>();
    volatile boolean done;
    private final HttpRequestEncoder encoder = new Encoder();
    private final HttpResponseDecoder decoder;
    private final AtomicLong requestResponseCounter = new AtomicLong(0L);
    private final boolean failOnMissingResponse;

    public HttpClientCodec() {
        this(4096, 8192, 8192, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this(maxInitialLineLength, maxHeaderSize, maxChunkSize, false);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize, boolean failOnMissingResponse) {
        this.decoder = new Decoder(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        this.failOnMissingResponse = failOnMissingResponse;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.decoder.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.encoder.handleDownstream(ctx, e);
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, HttpMessageDecoder.State state) throws Exception {
            if (HttpClientCodec.this.done) {
                int readable = this.actualReadableBytes();
                if (readable == 0) {
                    return null;
                }
                return buffer.readBytes(readable);
            }
            Object msg = super.decode(ctx, channel, buffer, state);
            if (HttpClientCodec.this.failOnMissingResponse) {
                this.decrement(msg);
            }
            return msg;
        }

        private void decrement(Object msg) {
            if (msg == null) {
                return;
            }
            if (msg instanceof HttpMessage && !((HttpMessage)msg).isChunked()) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            } else if (msg instanceof HttpChunk && ((HttpChunk)msg).isLast()) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            } else if (msg instanceof Object[]) {
                HttpClientCodec.this.requestResponseCounter.decrementAndGet();
            }
        }

        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            int statusCode = ((HttpResponse)msg).getStatus().getCode();
            if (statusCode == 100) {
                return true;
            }
            HttpMethod method = HttpClientCodec.this.queue.poll();
            char firstChar = method.getName().charAt(0);
            switch (firstChar) {
                case 'H': {
                    if (!HttpMethod.HEAD.equals(method)) break;
                    return true;
                }
                case 'C': {
                    if (statusCode != 200 || !HttpMethod.CONNECT.equals(method)) break;
                    HttpClientCodec.this.done = true;
                    HttpClientCodec.this.queue.clear();
                    return true;
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }

        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            long missingResponses;
            super.channelClosed(ctx, e);
            if (HttpClientCodec.this.failOnMissingResponse && (missingResponses = HttpClientCodec.this.requestResponseCounter.get()) > 0L) {
                throw new PrematureChannelClosureException("Channel closed but still missing " + missingResponses + " response(s)");
            }
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        Encoder() {
        }

        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
            if (msg instanceof HttpRequest && !HttpClientCodec.this.done) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).getMethod());
            }
            Object obj = super.encode(ctx, channel, msg);
            if (HttpClientCodec.this.failOnMissingResponse) {
                if (msg instanceof HttpRequest && !((HttpRequest)msg).isChunked()) {
                    HttpClientCodec.this.requestResponseCounter.incrementAndGet();
                } else if (msg instanceof HttpChunk && ((HttpChunk)msg).isLast()) {
                    HttpClientCodec.this.requestResponseCounter.incrementAndGet();
                }
            }
            return obj;
        }
    }
}

