/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.AssetManager;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import org.maphero.android.ModuleProvider;
import org.maphero.android.ModuleProviderImpl;
import org.maphero.android.constants.MapHeroConstants;
import org.maphero.android.exceptions.MapHeroConfigurationException;
import org.maphero.android.net.ConnectivityReceiver;
import org.maphero.android.storage.FileSource;
import org.maphero.android.util.DefaultStyle;
import org.maphero.android.util.TileServerOptions;
import org.maphero.android.utils.ThreadUtils;
import timber.log.Timber;

@UiThread
@SuppressLint(value={"StaticFieldLeak"})
@Keep
public final class MapHero {
    private static final String TAG = "MapHero";
    private static ModuleProvider moduleProvider;
    private static MapHero INSTANCE;
    private Context context;
    @Nullable
    private String apiKey;
    @Nullable
    private TileServerOptions tileServerOptions;

    @UiThread
    @NonNull
    public static synchronized MapHero getInstance(@NonNull Context context) {
        TileServerOptions tileServerOptions;
        ThreadUtils.init(context);
        ThreadUtils.checkThread(TAG);
        if (INSTANCE == null) {
            Context appContext = context.getApplicationContext();
            FileSource.initializeFileDirsPaths(appContext);
            INSTANCE = new MapHero(appContext, null);
            ConnectivityReceiver.instance(appContext);
        }
        MapHero.INSTANCE.tileServerOptions = tileServerOptions = TileServerOptions.get();
        MapHero.INSTANCE.apiKey = null;
        FileSource fileSource = FileSource.getInstance(context);
        fileSource.setTileServerOptions(tileServerOptions);
        fileSource.setApiKey(null);
        return INSTANCE;
    }

    @UiThread
    @NonNull
    public static synchronized MapHero getInstance(@NonNull Context context, @Nullable String apiKey) {
        TileServerOptions tileServerOptions;
        ThreadUtils.init(context);
        ThreadUtils.checkThread(TAG);
        if (INSTANCE == null) {
            Timber.plant((Timber.Tree[])new Timber.Tree[0]);
            Context appContext = context.getApplicationContext();
            FileSource.initializeFileDirsPaths(appContext);
            INSTANCE = new MapHero(appContext, apiKey);
            ConnectivityReceiver.instance(appContext);
        } else {
            MapHero.INSTANCE.apiKey = apiKey;
        }
        MapHero.INSTANCE.tileServerOptions = tileServerOptions = TileServerOptions.get();
        FileSource fileSource = FileSource.getInstance(context);
        fileSource.setTileServerOptions(tileServerOptions);
        fileSource.setApiKey(apiKey);
        return INSTANCE;
    }

    MapHero(@NonNull Context context, @Nullable String apiKey) {
        this.context = context;
        this.apiKey = apiKey;
    }

    MapHero(@NonNull Context context, @Nullable String apiKey, @NonNull TileServerOptions options) {
        this.context = context;
        this.apiKey = apiKey;
        this.tileServerOptions = options;
    }

    @Nullable
    public static String getApiKey() {
        MapHero.validateMapHero();
        return MapHero.INSTANCE.apiKey;
    }

    public static void setApiKey(String apiKey) {
        MapHero.validateMapHero();
        MapHero.throwIfApiKeyInvalid(apiKey);
        MapHero.INSTANCE.apiKey = apiKey;
        FileSource.getInstance(MapHero.getApplicationContext()).setApiKey(apiKey);
    }

    @Nullable
    public static TileServerOptions getTileServerOptions() {
        MapHero.validateMapHero();
        return MapHero.INSTANCE.tileServerOptions;
    }

    @Nullable
    public static DefaultStyle[] getPredefinedStyles() {
        MapHero.validateMapHero();
        if (MapHero.INSTANCE.tileServerOptions != null) {
            return MapHero.INSTANCE.tileServerOptions.getDefaultStyles();
        }
        return null;
    }

    @Nullable
    public static DefaultStyle getPredefinedStyle(String name) {
        MapHero.validateMapHero();
        if (MapHero.INSTANCE.tileServerOptions != null) {
            DefaultStyle[] styles;
            for (DefaultStyle style : styles = MapHero.INSTANCE.tileServerOptions.getDefaultStyles()) {
                if (!style.getName().equalsIgnoreCase(name)) continue;
                return style;
            }
        }
        return null;
    }

    @NonNull
    public static Context getApplicationContext() {
        MapHero.validateMapHero();
        return MapHero.INSTANCE.context;
    }

    public static synchronized void setConnected(Boolean connected) {
        MapHero.validateMapHero();
        ConnectivityReceiver.instance(MapHero.INSTANCE.context).setConnected(connected);
    }

    public static synchronized Boolean isConnected() {
        MapHero.validateMapHero();
        return ConnectivityReceiver.instance(MapHero.INSTANCE.context).isConnected();
    }

    @NonNull
    public static ModuleProvider getModuleProvider() {
        if (moduleProvider == null) {
            moduleProvider = new ModuleProviderImpl();
        }
        return moduleProvider;
    }

    public static void setModuleProvider(ModuleProvider provider) {
        moduleProvider = provider;
    }

    private static void validateMapHero() {
        if (INSTANCE == null) {
            throw new MapHeroConfigurationException();
        }
    }

    static boolean isApiKeyValid(@Nullable String apiKey) {
        if (apiKey == null) {
            return false;
        }
        return !(apiKey = apiKey.trim().toLowerCase(MapHeroConstants.MAPHERO_LOCALE)).isEmpty();
    }

    public static void throwIfApiKeyInvalid(@Nullable String apiKey) {
        if (!MapHero.isApiKeyValid(apiKey)) {
            throw new MapHeroConfigurationException("A valid API key is required, currently provided key is: " + apiKey);
        }
    }

    public static boolean hasInstance() {
        return INSTANCE != null;
    }

    private static AssetManager getAssetManager() {
        return MapHero.getApplicationContext().getResources().getAssets();
    }
}

