/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.annotations;

import android.view.View;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.maphero.android.R;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.annotations.BaseMarkerOptions;
import org.maphero.android.annotations.Icon;
import org.maphero.android.annotations.InfoWindow;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.MapView;

public class Marker
extends Annotation {
    @Keep
    private LatLng position;
    private String snippet;
    @Nullable
    private Icon icon;
    @Nullable
    @Keep
    private String iconId;
    private String title;
    @Nullable
    private InfoWindow infoWindow;
    private boolean infoWindowShown;
    private int topOffsetPixels;
    private int rightOffsetPixels;

    Marker() {
    }

    public Marker(BaseMarkerOptions baseMarkerOptions) {
        this(baseMarkerOptions.position, baseMarkerOptions.icon, baseMarkerOptions.title, baseMarkerOptions.snippet);
    }

    Marker(LatLng position, Icon icon, String title, String snippet) {
        this.position = position;
        this.title = title;
        this.snippet = snippet;
        this.setIcon(icon);
    }

    public LatLng getPosition() {
        return this.position;
    }

    public String getSnippet() {
        return this.snippet;
    }

    public String getTitle() {
        return this.title;
    }

    public void hideInfoWindow() {
        if (this.infoWindow != null) {
            this.infoWindow.close();
        }
        this.infoWindowShown = false;
    }

    public boolean isInfoWindowShown() {
        return this.infoWindowShown;
    }

    public void setPosition(LatLng position) {
        this.position = position;
        MapHeroMap map = this.getMapHeroMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    public void setSnippet(String snippet) {
        this.snippet = snippet;
        this.refreshInfoWindowContent();
    }

    public void setIcon(@Nullable Icon icon) {
        this.icon = icon;
        this.iconId = icon != null ? icon.getId() : null;
        MapHeroMap map = this.getMapHeroMap();
        if (map != null) {
            map.updateMarker(this);
        }
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public void setTitle(String title) {
        this.title = title;
        this.refreshInfoWindowContent();
    }

    @Nullable
    public InfoWindow getInfoWindow() {
        return this.infoWindow;
    }

    private void refreshInfoWindowContent() {
        if (this.isInfoWindowShown() && this.mapView != null && this.mapHeroMap != null && this.mapHeroMap.getInfoWindowAdapter() == null) {
            MapHeroMap map;
            InfoWindow infoWindow = this.getInfoWindow(this.mapView);
            if (this.mapView.getContext() != null) {
                infoWindow.adaptDefaultMarker(this, this.mapHeroMap, this.mapView);
            }
            if ((map = this.getMapHeroMap()) != null) {
                map.updateMarker(this);
            }
            infoWindow.onContentUpdate();
        }
    }

    @Nullable
    public InfoWindow showInfoWindow(@NonNull MapHeroMap mapHeroMap, @NonNull MapView mapView) {
        View content;
        this.setMapHeroMap(mapHeroMap);
        this.setMapView(mapView);
        MapHeroMap.InfoWindowAdapter infoWindowAdapter = this.getMapHeroMap().getInfoWindowAdapter();
        if (infoWindowAdapter != null && (content = infoWindowAdapter.getInfoWindow(this)) != null) {
            this.infoWindow = new InfoWindow(content, mapHeroMap);
            this.showInfoWindow(this.infoWindow, mapView);
            return this.infoWindow;
        }
        InfoWindow infoWindow = this.getInfoWindow(mapView);
        if (mapView.getContext() != null) {
            infoWindow.adaptDefaultMarker(this, mapHeroMap, mapView);
        }
        return this.showInfoWindow(infoWindow, mapView);
    }

    @NonNull
    private InfoWindow showInfoWindow(InfoWindow iw, MapView mapView) {
        iw.open(mapView, this, this.getPosition(), this.rightOffsetPixels, this.topOffsetPixels);
        this.infoWindowShown = true;
        return iw;
    }

    @Nullable
    private InfoWindow getInfoWindow(@NonNull MapView mapView) {
        if (this.infoWindow == null && mapView.getContext() != null) {
            this.infoWindow = new InfoWindow(mapView, R.layout.maphero_infowindow_content, this.getMapHeroMap());
        }
        return this.infoWindow;
    }

    public void setTopOffsetPixels(int topOffsetPixels) {
        this.topOffsetPixels = topOffsetPixels;
    }

    public void setRightOffsetPixels(int rightOffsetPixels) {
        this.rightOffsetPixels = rightOffsetPixels;
    }

    public String toString() {
        return "Marker [position[" + this.getPosition() + "]]";
    }
}

