/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.annotations;

import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.BasePointCollection;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.maps.MapHeroMap;

public final class Polygon
extends BasePointCollection {
    @Keep
    private int fillColor = -16777216;
    @Keep
    private int strokeColor = -16777216;
    @Keep
    private List<List<LatLng>> holes = new ArrayList<List<LatLng>>();

    Polygon() {
    }

    public int getFillColor() {
        return this.fillColor;
    }

    public int getStrokeColor() {
        return this.strokeColor;
    }

    @NonNull
    public List<List<LatLng>> getHoles() {
        return new ArrayList<List<LatLng>>(this.holes);
    }

    public void setFillColor(int color2) {
        this.fillColor = color2;
        this.update();
    }

    public void setStrokeColor(int color2) {
        this.strokeColor = color2;
        this.update();
    }

    public void setHoles(@NonNull List<? extends List<LatLng>> holes) {
        this.holes = new ArrayList<List<LatLng>>(holes);
        this.update();
    }

    void addHole(List<LatLng> hole) {
        this.holes.add(hole);
        this.update();
    }

    @Override
    void update() {
        MapHeroMap mapHeroMap = this.getMapHeroMap();
        if (mapHeroMap != null) {
            mapHeroMap.updatePolygon(this);
        }
    }
}

