/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.annotations;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.Polygon;
import org.maphero.android.geometry.LatLng;

public final class PolygonOptions
implements Parcelable {
    public static final Parcelable.Creator<PolygonOptions> CREATOR = new Parcelable.Creator<PolygonOptions>(){

        public PolygonOptions createFromParcel(@NonNull Parcel in) {
            return new PolygonOptions(in);
        }

        public PolygonOptions[] newArray(int size) {
            return new PolygonOptions[size];
        }
    };
    private Polygon polygon = new Polygon();

    private PolygonOptions(Parcel in) {
        ArrayList<LatLng> pointsList = new ArrayList<LatLng>();
        in.readList(pointsList, LatLng.class.getClassLoader());
        this.addAll(pointsList);
        ArrayList<List<LatLng>> holes = new ArrayList<List<LatLng>>();
        in.readList(holes, LatLng.class.getClassLoader());
        this.addAllHoles(holes);
        this.alpha(in.readFloat());
        this.fillColor(in.readInt());
        this.strokeColor(in.readInt());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeList(this.getPoints());
        out.writeList(this.getHoles());
        out.writeFloat(this.getAlpha());
        out.writeInt(this.getFillColor());
        out.writeInt(this.getStrokeColor());
    }

    public PolygonOptions() {
    }

    @NonNull
    public PolygonOptions add(LatLng point) {
        this.polygon.addPoint(point);
        return this;
    }

    @NonNull
    public PolygonOptions add(LatLng ... points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addAll(Iterable<LatLng> points) {
        for (LatLng point : points) {
            this.add(point);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addHole(List<LatLng> hole) {
        this.polygon.addHole(hole);
        return this;
    }

    @NonNull
    public PolygonOptions addHole(List<LatLng> ... holes) {
        for (List<LatLng> hole : holes) {
            this.addHole(hole);
        }
        return this;
    }

    @NonNull
    public PolygonOptions addAllHoles(Iterable<List<LatLng>> holes) {
        for (List<LatLng> hole : holes) {
            this.addHole(hole);
        }
        return this;
    }

    @NonNull
    public PolygonOptions alpha(float alpha) {
        this.polygon.setAlpha(alpha);
        return this;
    }

    public float getAlpha() {
        return this.polygon.getAlpha();
    }

    @NonNull
    public PolygonOptions fillColor(int color2) {
        this.polygon.setFillColor(color2);
        return this;
    }

    public int getFillColor() {
        return this.polygon.getFillColor();
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    @NonNull
    public PolygonOptions strokeColor(int color2) {
        this.polygon.setStrokeColor(color2);
        return this;
    }

    public int getStrokeColor() {
        return this.polygon.getStrokeColor();
    }

    @NonNull
    public List<LatLng> getPoints() {
        return this.polygon.getPoints();
    }

    @NonNull
    public List<List<LatLng>> getHoles() {
        return this.polygon.getHoles();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolygonOptions polygon = (PolygonOptions)o;
        if (Float.compare(polygon.getAlpha(), this.getAlpha()) != 0) {
            return false;
        }
        if (this.getFillColor() != polygon.getFillColor()) {
            return false;
        }
        if (this.getStrokeColor() != polygon.getStrokeColor()) {
            return false;
        }
        if (!this.getPoints().equals(polygon.getPoints())) {
            return false;
        }
        return this.getHoles().equals(polygon.getHoles());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getAlpha() != 0.0f ? Float.floatToIntBits(this.getAlpha()) : 0);
        result = 31 * result + this.getFillColor();
        result = 31 * result + this.getStrokeColor();
        result = 31 * result + this.getPoints().hashCode();
        result = 31 * result + this.getHoles().hashCode();
        return result;
    }
}

