/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.camera;

import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import androidx.annotation.Keep;
import androidx.annotation.Size;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.R;
import org.maphero.android.camera.CameraUpdateFactory;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.utils.MathUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB5\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB+\b\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u000eH\u0016R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/maphero/android/camera/CameraPosition;", "Landroid/os/Parcelable;", "target", "Lorg/maphero/android/geometry/LatLng;", "zoom", "", "tilt", "bearing", "padding", "", "<init>", "(Lorg/maphero/android/geometry/LatLng;DDD[D)V", "(Lorg/maphero/android/geometry/LatLng;DDD)V", "describeContents", "", "writeToParcel", "", "out", "Landroid/os/Parcel;", "flags", "toString", "", "equals", "", "other", "", "hashCode", "Builder", "Companion", "MapHeroAndroid_legacyRelease"})
public final class CameraPosition
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    @JvmField
    @Nullable
    public final LatLng target;
    @Keep
    @JvmField
    public final double zoom;
    @Keep
    @JvmField
    public final double tilt;
    @Keep
    @JvmField
    public final double bearing;
    @Keep
    @JvmField
    @Nullable
    public final double[] padding;
    @JvmField
    @NotNull
    public static final CameraPosition DEFAULT;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<CameraPosition> CREATOR;

    @Keep
    public CameraPosition(@Nullable LatLng target, double zoom, double tilt, double bearing, @Nullable double[] padding) {
        this.target = target;
        this.zoom = zoom;
        this.tilt = tilt;
        this.bearing = bearing;
        this.padding = padding;
    }

    @Deprecated(message="use {@link CameraPosition#CameraPosition(LatLng, double, double, double, double[])} instead.")
    public CameraPosition(@Nullable LatLng target, double zoom, double tilt, double bearing) {
        this(target, zoom, tilt, bearing, null);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeDouble(this.bearing);
        out.writeParcelable((Parcelable)this.target, flags);
        out.writeDouble(this.tilt);
        out.writeDouble(this.zoom);
        if (this.padding != null) {
            int length = this.padding.length;
            out.writeInt(length);
            for (double v : this.padding) {
                out.writeDouble(v);
            }
        } else {
            out.writeInt(-1);
        }
    }

    @NotNull
    public String toString() {
        return "Target: " + this.target + ", Zoom:" + this.zoom + ", Bearing:" + this.bearing + ", Tilt:" + this.tilt + ", Padding:" + Arrays.toString(this.padding);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        CameraPosition cameraPosition = (CameraPosition)other;
        if (this.target != null && !Intrinsics.areEqual((Object)this.target, (Object)cameraPosition.target)) {
            return false;
        }
        if (!(this.zoom == cameraPosition.zoom)) {
            return false;
        }
        if (!(this.tilt == cameraPosition.tilt)) {
            return false;
        }
        if (!(this.bearing == cameraPosition.bearing)) {
            return false;
        }
        return Arrays.equals(this.padding, cameraPosition.padding);
    }

    public int hashCode() {
        int result = 0;
        long temp = 0L;
        temp = Double.doubleToLongBits(this.bearing);
        result = (int)(temp ^ temp >>> 32);
        LatLng latLng = this.target;
        result = 31 * result + (latLng != null ? latLng.hashCode() : 0);
        temp = Double.doubleToLongBits(this.tilt);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.zoom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + Arrays.hashCode(this.padding);
        return result;
    }

    static {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        DEFAULT = new CameraPosition(new LatLng(), 0.0, 0.0, 0.0, dArray);
        CREATOR = (Parcelable.Creator)new Parcelable.Creator<CameraPosition>(){

            public CameraPosition createFromParcel(Parcel parcel) {
                Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                double bearing = parcel.readDouble();
                LatLng target = Build.VERSION.SDK_INT >= 33 ? (LatLng)parcel.readParcelable(LatLng.class.getClassLoader(), LatLng.class) : (LatLng)parcel.readParcelable(LatLng.class.getClassLoader());
                double tilt = parcel.readDouble();
                double zoom = parcel.readDouble();
                double[] padding = null;
                int paddingSize = parcel.readInt();
                if (paddingSize > 0) {
                    padding = new double[paddingSize];
                    for (int i = 0; i < paddingSize; ++i) {
                        padding[i] = parcel.readDouble();
                    }
                }
                return new CameraPosition(target, zoom, tilt, bearing, padding);
            }

            public CameraPosition[] newArray(int size) {
                return new CameraPosition[size];
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0002\u0010\tB\u0013\b\u0016\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0002\u0010\fB\u0013\b\u0016\u0012\b\u0010\n\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012J\u0010\u0010\u0013\u001a\u00020\u00002\b\b\u0001\u0010\u0013\u001a\u00020\u0010J\u0010\u0010\u0014\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\u0010J\u0012\u0010\u0015\u001a\u00020\u00002\n\b\u0001\u0010\u0015\u001a\u0004\u0018\u00010\u0016J&\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010J\u0006\u0010\u001c\u001a\u00020\u0005R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/maphero/android/camera/CameraPosition$Builder;", "", "<init>", "()V", "previous", "Lorg/maphero/android/camera/CameraPosition;", "(Lorg/maphero/android/camera/CameraPosition;)V", "typedArray", "Landroid/content/res/TypedArray;", "(Landroid/content/res/TypedArray;)V", "update", "Lorg/maphero/android/camera/CameraUpdateFactory$CameraPositionUpdate;", "(Lorg/maphero/android/camera/CameraUpdateFactory$CameraPositionUpdate;)V", "Lorg/maphero/android/camera/CameraUpdateFactory$ZoomUpdate;", "(Lorg/maphero/android/camera/CameraUpdateFactory$ZoomUpdate;)V", "bearing", "", "target", "Lorg/maphero/android/geometry/LatLng;", "tilt", "zoom", "padding", "", "location", "left", "top", "right", "bottom", "build", "MapHeroAndroid_legacyRelease"})
    public static final class Builder {
        private double bearing = -1.0;
        @Nullable
        private LatLng target;
        private double tilt = -1.0;
        private double zoom = -1.0;
        @Nullable
        private double[] padding;

        public Builder() {
        }

        public Builder(@Nullable CameraPosition previous) {
            if (previous != null) {
                this.bearing = previous.bearing;
                this.target = previous.target;
                this.tilt = previous.tilt;
                this.zoom = previous.zoom;
                this.padding = previous.padding;
            }
        }

        public Builder(@Nullable TypedArray typedArray) {
            if (typedArray != null) {
                this.bearing = typedArray.getFloat(R.styleable.maphero_MapView_maphero_cameraBearing, 0.0f);
                double lat = typedArray.getFloat(R.styleable.maphero_MapView_maphero_cameraTargetLat, 0.0f);
                double lng = typedArray.getFloat(R.styleable.maphero_MapView_maphero_cameraTargetLng, 0.0f);
                this.target = new LatLng(lat, lng);
                this.tilt = typedArray.getFloat(R.styleable.maphero_MapView_maphero_cameraTilt, 0.0f);
                this.zoom = typedArray.getFloat(R.styleable.maphero_MapView_maphero_cameraZoom, 0.0f);
            }
        }

        public Builder(@Nullable CameraUpdateFactory.CameraPositionUpdate update) {
            if (update != null) {
                this.bearing = update.getBearing();
                this.target = update.getTarget();
                this.tilt = update.getTilt();
                this.zoom = update.getZoom();
                this.padding = update.getPadding();
            }
        }

        public Builder(@Nullable CameraUpdateFactory.ZoomUpdate update) {
            if (update != null) {
                this.zoom = update.getZoom();
            }
        }

        @NotNull
        public final Builder bearing(double bearing) {
            double direction;
            for (direction = bearing; direction >= 360.0; direction -= 360.0) {
            }
            while (direction < 0.0) {
                direction += 360.0;
            }
            this.bearing = direction;
            return this;
        }

        @NotNull
        public final Builder target(@Nullable LatLng location) {
            this.target = location;
            return this;
        }

        @NotNull
        public final Builder tilt(@FloatRange(from=0.0, to=60.0) double tilt) {
            this.tilt = MathUtils.clamp(tilt, 0.0, 60.0);
            return this;
        }

        @NotNull
        public final Builder zoom(@FloatRange(from=0.0, to=25.5) double zoom) {
            this.zoom = zoom;
            return this;
        }

        @NotNull
        public final Builder padding(@Size(value=4L) @Nullable double[] padding) {
            this.padding = padding;
            return this;
        }

        @NotNull
        public final Builder padding(double left, double top, double right, double bottom) {
            double[] dArray = new double[]{left, top, right, bottom};
            this.padding = dArray;
            return this;
        }

        @NotNull
        public final CameraPosition build() {
            return new CameraPosition(this.target, this.zoom, this.tilt, this.bearing, this.padding);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/maphero/android/camera/CameraPosition$Companion;", "", "<init>", "()V", "DEFAULT", "Lorg/maphero/android/camera/CameraPosition;", "CREATOR", "Landroid/os/Parcelable$Creator;", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

