/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.camera;

import android.graphics.Point;
import android.graphics.PointF;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.camera.CameraUpdate;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.geometry.LatLngBounds;
import org.maphero.android.maps.MapHeroMap;
import timber.log.Timber;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003)*+B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J0\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J@\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0007J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0011H\u0007J0\u0010\u0019\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0007J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0011H\u0007J\b\u0010\"\u001a\u00020\u0005H\u0007J\b\u0010#\u001a\u00020\u0005H\u0007J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0011H\u0007J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010&\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0011H\u0007J\u0012\u0010'\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010(H\u0007J(\u0010'\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0007\u00a8\u0006,"}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory;", "", "<init>", "()V", "newCameraPosition", "Lorg/maphero/android/camera/CameraUpdate;", "cameraPosition", "Lorg/maphero/android/camera/CameraPosition;", "newLatLng", "latLng", "Lorg/maphero/android/geometry/LatLng;", "newLatLngBounds", "bounds", "Lorg/maphero/android/geometry/LatLngBounds;", "padding", "", "bearing", "", "tilt", "paddingLeft", "paddingTop", "paddingRight", "paddingBottom", "newLatLngZoom", "zoom", "newLatLngPadding", "left", "top", "right", "bottom", "zoomBy", "amount", "focus", "Landroid/graphics/Point;", "zoomIn", "zoomOut", "zoomTo", "bearingTo", "tiltTo", "paddingTo", "", "CameraPositionUpdate", "CameraBoundsUpdate", "ZoomUpdate", "MapHeroAndroid_legacyRelease"})
public final class CameraUpdateFactory {
    @NotNull
    public static final CameraUpdateFactory INSTANCE = new CameraUpdateFactory();

    private CameraUpdateFactory() {
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newCameraPosition(@NotNull CameraPosition cameraPosition) {
        Intrinsics.checkNotNullParameter((Object)cameraPosition, (String)"cameraPosition");
        return new CameraPositionUpdate(cameraPosition.bearing, cameraPosition.target, cameraPosition.tilt, cameraPosition.zoom, cameraPosition.padding);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLng(@NotNull LatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0, null);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngBounds(@NotNull LatLngBounds bounds, int padding) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return CameraUpdateFactory.newLatLngBounds(bounds, padding, padding, padding, padding);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngBounds(@NotNull LatLngBounds bounds, double bearing, double tilt, int padding) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return CameraUpdateFactory.newLatLngBounds(bounds, bearing, tilt, padding, padding, padding, padding);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngBounds(@NotNull LatLngBounds bounds, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new CameraBoundsUpdate(bounds, null, null, paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngBounds(@NotNull LatLngBounds bounds, double bearing, double tilt, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return new CameraBoundsUpdate(bounds, bearing, tilt, paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngZoom(@NotNull LatLng latLng, double zoom) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        return new CameraPositionUpdate(-1.0, latLng, -1.0, zoom, null);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate newLatLngPadding(@NotNull LatLng latLng, double left, double top, double right, double bottom) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        double[] dArray = new double[]{left, top, right, bottom};
        return new CameraPositionUpdate(-1.0, latLng, -1.0, -1.0, dArray);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate zoomBy(double amount, @NotNull Point focus) {
        Intrinsics.checkNotNullParameter((Object)focus, (String)"focus");
        return new ZoomUpdate(amount, focus.x, focus.y);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate zoomBy(double amount) {
        return new ZoomUpdate(2, amount);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate zoomIn() {
        return new ZoomUpdate(0);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate zoomOut() {
        return new ZoomUpdate(1);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate zoomTo(double zoom) {
        return new ZoomUpdate(3, zoom);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate bearingTo(double bearing) {
        return new CameraPositionUpdate(bearing, null, -1.0, -1.0, null);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate tiltTo(double tilt) {
        return new CameraPositionUpdate(-1.0, null, tilt, -1.0, null);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate paddingTo(@Nullable double[] padding) {
        return new CameraPositionUpdate(-1.0, null, -1.0, -1.0, padding);
    }

    @JvmStatic
    @NotNull
    public static final CameraUpdate paddingTo(double left, double top, double right, double bottom) {
        double[] dArray = new double[]{left, top, right, bottom};
        return CameraUpdateFactory.paddingTo(dArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nBE\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\u0010J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory$CameraBoundsUpdate;", "Lorg/maphero/android/camera/CameraUpdate;", "bounds", "Lorg/maphero/android/geometry/LatLngBounds;", "bearing", "", "tilt", "padding", "", "<init>", "(Lorg/maphero/android/geometry/LatLngBounds;Ljava/lang/Double;Ljava/lang/Double;[I)V", "paddingLeft", "", "paddingTop", "paddingRight", "paddingBottom", "(Lorg/maphero/android/geometry/LatLngBounds;Ljava/lang/Double;Ljava/lang/Double;IIII)V", "getBounds", "()Lorg/maphero/android/geometry/LatLngBounds;", "Ljava/lang/Double;", "getPadding", "()[I", "getCameraPosition", "Lorg/maphero/android/camera/CameraPosition;", "mapHeroMap", "Lorg/maphero/android/maps/MapHeroMap;", "equals", "", "other", "", "hashCode", "toString", "", "MapHeroAndroid_legacyRelease"})
    public static final class CameraBoundsUpdate
    implements CameraUpdate {
        @NotNull
        private final LatLngBounds bounds;
        @Nullable
        private final Double bearing;
        @Nullable
        private final Double tilt;
        @NotNull
        private final int[] padding;

        public CameraBoundsUpdate(@NotNull LatLngBounds bounds, @Nullable Double bearing, @Nullable Double tilt, @NotNull int[] padding) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            Intrinsics.checkNotNullParameter((Object)padding, (String)"padding");
            this.bounds = bounds;
            this.bearing = bearing;
            this.tilt = tilt;
            this.padding = padding;
        }

        @NotNull
        public final LatLngBounds getBounds() {
            return this.bounds;
        }

        @NotNull
        public final int[] getPadding() {
            return this.padding;
        }

        public CameraBoundsUpdate(@NotNull LatLngBounds bounds, @Nullable Double bearing, @Nullable Double tilt, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            int[] nArray = new int[]{paddingLeft, paddingTop, paddingRight, paddingBottom};
            this(bounds, bearing, tilt, nArray);
        }

        @Override
        @Nullable
        public CameraPosition getCameraPosition(@NotNull MapHeroMap mapHeroMap) {
            CameraPosition cameraPosition;
            Intrinsics.checkNotNullParameter((Object)mapHeroMap, (String)"mapHeroMap");
            if (this.bearing == null && this.tilt == null) {
                cameraPosition = mapHeroMap.getCameraForLatLngBounds(this.bounds, this.padding);
            } else {
                boolean bl;
                boolean bl2 = bl = this.bearing != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                boolean bl3 = bl = this.tilt != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Double d = this.bearing;
                Intrinsics.checkNotNull((Object)d);
                double d2 = d;
                Double d3 = this.tilt;
                Intrinsics.checkNotNull((Object)d3);
                cameraPosition = mapHeroMap.getCameraForLatLngBounds(this.bounds, this.padding, d2, d3);
            }
            return cameraPosition;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            CameraBoundsUpdate that = (CameraBoundsUpdate)other;
            return !Intrinsics.areEqual((Object)this.bounds, (Object)that.bounds) ? false : Arrays.equals(this.padding, that.padding);
        }

        public int hashCode() {
            int result = this.bounds.hashCode();
            result = 31 * result + Arrays.hashCode(this.padding);
            return result;
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString(this.padding);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return "CameraBoundsUpdate{bounds=" + this.bounds + ", padding=" + string + "}";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory$CameraPositionUpdate;", "Lorg/maphero/android/camera/CameraUpdate;", "bearing", "", "target", "Lorg/maphero/android/geometry/LatLng;", "tilt", "zoom", "padding", "", "<init>", "(DLorg/maphero/android/geometry/LatLng;DD[D)V", "getBearing", "()D", "getTarget", "()Lorg/maphero/android/geometry/LatLng;", "getTilt", "getZoom", "getPadding", "()[D", "getCameraPosition", "Lorg/maphero/android/camera/CameraPosition;", "mapHeroMap", "Lorg/maphero/android/maps/MapHeroMap;", "equals", "", "other", "", "hashCode", "", "toString", "", "MapHeroAndroid_legacyRelease"})
    public static final class CameraPositionUpdate
    implements CameraUpdate {
        private final double bearing;
        @Nullable
        private final LatLng target;
        private final double tilt;
        private final double zoom;
        @Nullable
        private final double[] padding;

        public CameraPositionUpdate(double bearing, @Nullable LatLng target, double tilt, double zoom, @Nullable double[] padding) {
            this.bearing = bearing;
            this.target = target;
            this.tilt = tilt;
            this.zoom = zoom;
            this.padding = padding;
        }

        public final double getBearing() {
            return this.bearing;
        }

        @Nullable
        public final LatLng getTarget() {
            return this.target;
        }

        public final double getTilt() {
            return this.tilt;
        }

        public final double getZoom() {
            return this.zoom;
        }

        @Nullable
        public final double[] getPadding() {
            return this.padding;
        }

        @Override
        @NotNull
        public CameraPosition getCameraPosition(@NotNull MapHeroMap mapHeroMap) {
            Intrinsics.checkNotNullParameter((Object)mapHeroMap, (String)"mapHeroMap");
            if (this.target == null) {
                CameraPosition cameraPosition = mapHeroMap.getCameraPosition();
                Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
                CameraPosition previousPosition = cameraPosition;
                return new CameraPosition.Builder(this).target(previousPosition.target).build();
            }
            return new CameraPosition.Builder(this).build();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            CameraPositionUpdate that = (CameraPositionUpdate)other;
            if (Double.compare(that.bearing, this.bearing) != 0) {
                return false;
            }
            if (Double.compare(that.tilt, this.tilt) != 0) {
                return false;
            }
            if (Double.compare(that.zoom, this.zoom) != 0) {
                return false;
            }
            return (this.target != null ? !Intrinsics.areEqual((Object)this.target, (Object)that.target) : that.target != null) ? false : Arrays.equals(this.padding, that.padding);
        }

        public int hashCode() {
            int result = 0;
            long temp = 0L;
            temp = Double.doubleToLongBits(this.bearing);
            result = (int)(temp ^ temp >>> 32);
            LatLng latLng = this.target;
            result = 31 * result + (latLng != null ? latLng.hashCode() : 0);
            temp = Double.doubleToLongBits(this.tilt);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.zoom);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + Arrays.hashCode(this.padding);
            return result;
        }

        @NotNull
        public String toString() {
            return "CameraPositionUpdate{bearing=" + this.bearing + ", target=" + this.target + ", tilt=" + this.tilt + ", zoom=" + this.zoom + ", padding=" + Arrays.toString(this.padding) + "}";
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002$%B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bB!\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0004\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\b\u0010!\u001a\u00020\u0003H\u0016J\b\u0010\"\u001a\u00020#H\u0016R\u0017\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015\u00a8\u0006&"}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory$ZoomUpdate;", "Lorg/maphero/android/camera/CameraUpdate;", "type", "", "<init>", "(I)V", "zoom", "", "(ID)V", "x", "", "y", "(DFF)V", "getType$annotations", "()V", "getType", "()I", "getZoom", "()D", "value", "getX", "()F", "getY", "transformZoom", "currentZoomArg", "getCameraPosition", "Lorg/maphero/android/camera/CameraPosition;", "mapHeroMap", "Lorg/maphero/android/maps/MapHeroMap;", "equals", "", "other", "", "hashCode", "toString", "", "Type", "Companion", "MapHeroAndroid_legacyRelease"})
    public static final class ZoomUpdate
    implements CameraUpdate {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int type;
        private final double zoom;
        private float x;
        private float y;
        public static final int ZOOM_IN = 0;
        public static final int ZOOM_OUT = 1;
        public static final int ZOOM_BY = 2;
        public static final int ZOOM_TO = 3;
        public static final int ZOOM_TO_POINT = 4;

        public final int getType() {
            return this.type;
        }

        public static /* synthetic */ void getType$annotations() {
        }

        public final double getZoom() {
            return this.zoom;
        }

        public final float getX() {
            return this.x;
        }

        public final float getY() {
            return this.y;
        }

        public ZoomUpdate(int type) {
            this.type = type;
            this.zoom = 0.0;
        }

        public ZoomUpdate(int type, double zoom) {
            this.type = type;
            this.zoom = zoom;
        }

        public ZoomUpdate(double zoom, float x, float y) {
            this.type = 4;
            this.zoom = zoom;
            this.x = x;
            this.y = y;
        }

        private final double transformZoom(double currentZoomArg) {
            double d;
            switch (this.type) {
                case 0: {
                    d = currentZoomArg + 1.0;
                    break;
                }
                case 1: {
                    d = Double.max(currentZoomArg - 1.0, 0.0);
                    break;
                }
                case 3: {
                    d = this.zoom;
                    break;
                }
                case 2: 
                case 4: {
                    d = currentZoomArg + this.zoom;
                    break;
                }
                default: {
                    Timber.Forest.e("Unprocessed when branch", new Object[0]);
                    d = 4.0;
                }
            }
            return d;
        }

        @Override
        @NotNull
        public CameraPosition getCameraPosition(@NotNull MapHeroMap mapHeroMap) {
            Intrinsics.checkNotNullParameter((Object)mapHeroMap, (String)"mapHeroMap");
            CameraPosition cameraPosition = mapHeroMap.getCameraPosition();
            Intrinsics.checkNotNullExpressionValue((Object)cameraPosition, (String)"getCameraPosition(...)");
            CameraPosition cameraPosition2 = cameraPosition;
            return this.type != 4 ? new CameraPosition.Builder(cameraPosition2).zoom(this.transformZoom(cameraPosition2.zoom)).build() : new CameraPosition.Builder(cameraPosition2).zoom(this.transformZoom(cameraPosition2.zoom)).target(mapHeroMap.getProjection().fromScreenLocation(new PointF(this.x, this.y))).build();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            ZoomUpdate that = (ZoomUpdate)other;
            if (this.type != that.type) {
                return false;
            }
            if (Double.compare(that.zoom, this.zoom) != 0) {
                return false;
            }
            return Float.compare(that.x, this.x) != 0 ? false : Float.compare(that.y, this.y) == 0;
        }

        public int hashCode() {
            int result = 0;
            long temp = 0L;
            result = this.type;
            temp = Double.doubleToLongBits(this.zoom);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            result = 31 * result + (!(this.x == 0.0f) ? Float.floatToIntBits(this.x) : 0);
            result = 31 * result + (!(this.y == 0.0f) ? Float.floatToIntBits(this.y) : 0);
            return result;
        }

        @NotNull
        public String toString() {
            return "ZoomUpdate{type=" + this.type + ", zoom=" + this.zoom + ", x=" + this.x + ", y=" + this.y + "}";
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory$ZoomUpdate$Companion;", "", "<init>", "()V", "ZOOM_IN", "", "ZOOM_OUT", "ZOOM_BY", "ZOOM_TO", "ZOOM_TO_POINT", "MapHeroAndroid_legacyRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Retention(value=AnnotationRetention.SOURCE)
        @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0081\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/maphero/android/camera/CameraUpdateFactory$ZoomUpdate$Type;", "", "MapHeroAndroid_legacyRelease"})
        public static @interface Type {
        }
    }
}

