/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.geometry;

import android.location.Location;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import androidx.annotation.Keep;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maplibre.geojson.Point;
import org.maplibre.turf.TurfMeasurement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0001)B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0002\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0002\u0010\u0011J\u0006\u0010\u001a\u001a\u00020\u0000J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020 H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020 H\u0016J\u000e\u0010(\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0000R(\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R(\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00058\u0006@FX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0013\"\u0004\b\u0017\u0010\u0015R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0013\"\u0004\b\u0019\u0010\u0015\u00a8\u0006*"}, d2={"Lorg/maphero/android/geometry/LatLng;", "Landroid/os/Parcelable;", "<init>", "()V", "latitude", "", "longitude", "(DD)V", "altitude", "(DDD)V", "location", "Landroid/location/Location;", "(Landroid/location/Location;)V", "latLng", "(Lorg/maphero/android/geometry/LatLng;)V", "in", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getLatitude", "()D", "setLatitude", "(D)V", "getLongitude", "setLongitude", "getAltitude", "setAltitude", "wrap", "equals", "", "other", "", "hashCode", "", "toString", "", "describeContents", "writeToParcel", "", "out", "flags", "distanceTo", "Companion", "MapHeroAndroid_legacyRelease"})
@SourceDebugExtension(value={"SMAP\nLatLng.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatLng.kt\norg/maphero/android/geometry/LatLng\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n1#2:279\n*E\n"})
public final class LatLng
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    private double latitude;
    @Keep
    private double longitude;
    private double altitude;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<LatLng> CREATOR = (Parcelable.Creator)new Parcelable.Creator<LatLng>(){

        public LatLng createFromParcel(Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new LatLng(parcel);
        }

        public LatLng[] newArray(int size) {
            return new LatLng[size];
        }
    };

    public final double getLatitude() {
        return this.latitude;
    }

    public final void setLatitude(@FloatRange(from=-90.0, to=90.0) double latitude) {
        if (!(!Double.isNaN(latitude))) {
            boolean $i$a$-require-LatLng$latitude$32 = false;
            String $i$a$-require-LatLng$latitude$32 = "latitude must not be NaN";
            throw new IllegalArgumentException($i$a$-require-LatLng$latitude$32.toString());
        }
        if (!(Math.abs(latitude) <= 90.0)) {
            boolean bl = false;
            String string = "latitude must be between -90 and 90";
            throw new IllegalArgumentException(string.toString());
        }
        this.latitude = latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final void setLongitude(@FloatRange(from=-1.7976931348623157E308, to=1.7976931348623157E308) double longitude) {
        if (!(!Double.isNaN(longitude))) {
            boolean $i$a$-require-LatLng$longitude$32 = false;
            String $i$a$-require-LatLng$longitude$32 = "longitude must not be NaN";
            throw new IllegalArgumentException($i$a$-require-LatLng$longitude$32.toString());
        }
        if (!(!Double.isInfinite(longitude))) {
            boolean bl = false;
            String string = "longitude must not be infinite";
            throw new IllegalArgumentException(string.toString());
        }
        this.longitude = longitude;
    }

    public final double getAltitude() {
        return this.altitude;
    }

    public final void setAltitude(double d) {
        this.altitude = d;
    }

    public LatLng() {
        this.setLatitude(0.0);
        this.setLongitude(0.0);
    }

    @Keep
    public LatLng(double latitude, double longitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
    }

    public LatLng(double latitude, double longitude, double altitude) {
        this.setLatitude(latitude);
        this.setLongitude(longitude);
        this.altitude = altitude;
    }

    public LatLng(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this(location.getLatitude(), location.getLongitude(), location.getAltitude());
    }

    public LatLng(@NotNull LatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        this.setLatitude(latLng.latitude);
        this.setLongitude(latLng.longitude);
        this.altitude = latLng.altitude;
    }

    public LatLng(@NotNull Parcel in) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.setLatitude(in.readDouble());
        this.setLongitude(in.readDouble());
        this.altitude = in.readDouble();
    }

    @NotNull
    public final LatLng wrap() {
        return new LatLng(this.latitude, Companion.wrap(this.longitude, -180.0, 180.0));
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        LatLng latLng = (LatLng)other;
        return Double.compare(latLng.altitude, this.altitude) == 0 && Double.compare(latLng.latitude, this.latitude) == 0 && Double.compare(latLng.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        int result = 0;
        long temp = 0L;
        temp = Double.doubleToLongBits(this.latitude);
        result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.altitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @NotNull
    public String toString() {
        return "LatLng [latitude=" + this.latitude + ", longitude=" + this.longitude + ", altitude=" + this.altitude + "]";
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeDouble(this.latitude);
        out.writeDouble(this.longitude);
        out.writeDouble(this.altitude);
    }

    public final double distanceTo(@NotNull LatLng other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return TurfMeasurement.distance((Point)Point.fromLngLat((double)this.longitude, (double)this.latitude), (Point)Point.fromLngLat((double)other.longitude, (double)other.latitude), (String)"metres");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/maphero/android/geometry/LatLng$Companion;", "", "<init>", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lorg/maphero/android/geometry/LatLng;", "wrap", "", "value", "min", "max", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public final double wrap(double value, double min, double max) {
            double delta = max - min;
            double firstMod = (value - min) % delta;
            double secondMod = (firstMod + delta) % delta;
            return value >= max && secondMod == 0.0 ? max : secondMod + min;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

