/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.geometry;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.FloatRange;
import androidx.annotation.Keep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.exceptions.InvalidLatLngBoundsException;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.geometry.LatLngSpan;
import org.maphero.android.utils.ExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 G2\u00020\u0001:\u0002FGB)\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003J\b\u0010%\u001a\u00020&H\u0016J\u0011\u0010'\u001a\b\u0012\u0004\u0012\u00020\n0(\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\nJ\u0013\u0010,\u001a\u00020#2\b\u0010-\u001a\u0004\u0018\u00010.H\u0096\u0002J\u0010\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020\u0003H\u0002J\u0010\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020\u0003H\u0002J\u0011\u00103\u001a\u00020#2\u0006\u0010+\u001a\u00020\nH\u0086\u0002J\u0011\u00103\u001a\u00020#2\u0006\u0010-\u001a\u00020\u0000H\u0086\u0002J\u000e\u00104\u001a\u00020\u00002\u0006\u00105\u001a\u00020\u0000J&\u00104\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J(\u0010:\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0002J\u0010\u0010;\u001a\u0004\u0018\u00010\u00002\u0006\u0010<\u001a\u00020\u0000J&\u0010;\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003J*\u0010=\u001a\u0004\u0018\u00010\u00002\u0006\u00106\u001a\u00020\u00032\u0006\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u00032\u0006\u00109\u001a\u00020\u0003H\u0002J\b\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020?H\u0016J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020?H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0011\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\fR\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0011\u0010\"\u001a\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$\u00a8\u0006H"}, d2={"Lorg/maphero/android/geometry/LatLngBounds;", "Landroid/os/Parcelable;", "latitudeNorth", "", "longitudeEast", "latitudeSouth", "longitudeWest", "<init>", "(DDDD)V", "center", "Lorg/maphero/android/geometry/LatLng;", "getCenter", "()Lorg/maphero/android/geometry/LatLng;", "getLatNorth", "getLatSouth", "getLonEast", "getLonWest", "southWest", "getSouthWest", "northEast", "getNorthEast", "southEast", "getSouthEast", "northWest", "getNorthWest", "span", "Lorg/maphero/android/geometry/LatLngSpan;", "getSpan", "()Lorg/maphero/android/geometry/LatLngSpan;", "latitudeSpan", "getLatitudeSpan", "()D", "longitudeSpan", "getLongitudeSpan", "isEmptySpan", "", "()Z", "toString", "", "toLatLngs", "", "()[Lorg/maphero/android/geometry/LatLng;", "include", "latLng", "equals", "other", "", "containsLatitude", "latitude", "containsLongitude", "longitude", "contains", "union", "bounds", "northLat", "eastLon", "southLat", "westLon", "unionNoParamCheck", "intersect", "box", "intersectNoParamCheck", "hashCode", "", "describeContents", "writeToParcel", "", "out", "Landroid/os/Parcel;", "flags", "Builder", "Companion", "MapHeroAndroid_legacyRelease"})
@Keep
public final class LatLngBounds
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    @JvmField
    public final double latitudeNorth;
    @Keep
    @JvmField
    public final double longitudeEast;
    @Keep
    @JvmField
    public final double latitudeSouth;
    @Keep
    @JvmField
    public final double longitudeWest;
    @JvmField
    @NotNull
    public static final Parcelable.Creator<LatLngBounds> CREATOR = (Parcelable.Creator)new Parcelable.Creator<LatLngBounds>(){

        public LatLngBounds createFromParcel(Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return org.maphero.android.geometry.LatLngBounds$Companion.access$readFromParcel(LatLngBounds.Companion, parcel);
        }

        public LatLngBounds[] newArray(int size) {
            return new LatLngBounds[size];
        }
    };

    @Keep
    public LatLngBounds(double latitudeNorth, double longitudeEast, double latitudeSouth, double longitudeWest) {
        this.latitudeNorth = latitudeNorth;
        this.longitudeEast = longitudeEast;
        this.latitudeSouth = latitudeSouth;
        this.longitudeWest = longitudeWest;
    }

    @NotNull
    public final LatLng getCenter() {
        double latCenter = (this.latitudeNorth + this.latitudeSouth) / 2.0;
        double longCenter = (this.longitudeEast + this.longitudeWest) / 2.0;
        return new LatLng(latCenter, longCenter);
    }

    public final double getLatNorth() {
        return this.latitudeNorth;
    }

    public final double getLatSouth() {
        return this.latitudeSouth;
    }

    public final double getLonEast() {
        return this.longitudeEast;
    }

    public final double getLonWest() {
        return this.longitudeWest;
    }

    @NotNull
    public final LatLng getSouthWest() {
        return new LatLng(this.latitudeSouth, this.longitudeWest);
    }

    @NotNull
    public final LatLng getNorthEast() {
        return new LatLng(this.latitudeNorth, this.longitudeEast);
    }

    @NotNull
    public final LatLng getSouthEast() {
        return new LatLng(this.latitudeSouth, this.longitudeEast);
    }

    @NotNull
    public final LatLng getNorthWest() {
        return new LatLng(this.latitudeNorth, this.longitudeWest);
    }

    @NotNull
    public final LatLngSpan getSpan() {
        return new LatLngSpan(this.getLatitudeSpan(), this.getLongitudeSpan());
    }

    public final double getLatitudeSpan() {
        return Math.abs(this.latitudeNorth - this.latitudeSouth);
    }

    public final double getLongitudeSpan() {
        return Math.abs(this.longitudeEast - this.longitudeWest);
    }

    public final boolean isEmptySpan() {
        return this.getLongitudeSpan() == 0.0 || this.getLatitudeSpan() == 0.0;
    }

    @NotNull
    public String toString() {
        return "N:" + this.latitudeNorth + "; E:" + this.longitudeEast + "; S:" + this.latitudeSouth + "; W:" + this.longitudeWest;
    }

    @NotNull
    public final LatLng[] toLatLngs() {
        LatLng[] latLngArray = new LatLng[]{this.getNorthEast(), this.getSouthWest()};
        return latLngArray;
    }

    @NotNull
    public final LatLngBounds include(@NotNull LatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        return new Builder().include(this.getNorthEast()).include(this.getSouthWest()).include(latLng).build();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LatLngBounds) {
            return this.latitudeNorth == ((LatLngBounds)other).latitudeNorth && this.latitudeSouth == ((LatLngBounds)other).latitudeSouth && this.longitudeEast == ((LatLngBounds)other).longitudeEast && this.longitudeWest == ((LatLngBounds)other).longitudeWest;
        }
        return false;
    }

    private final boolean containsLatitude(double latitude) {
        return latitude <= this.latitudeNorth && latitude >= this.latitudeSouth;
    }

    private final boolean containsLongitude(double longitude) {
        return longitude <= this.longitudeEast && longitude >= this.longitudeWest;
    }

    public final boolean contains(@NotNull LatLng latLng) {
        Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
        return this.containsLatitude(latLng.getLatitude()) && this.containsLongitude(latLng.getLongitude());
    }

    public final boolean contains(@NotNull LatLngBounds other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.contains(other.getNorthEast()) && this.contains(other.getSouthWest());
    }

    @NotNull
    public final LatLngBounds union(@NotNull LatLngBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return this.unionNoParamCheck(bounds.latitudeNorth, bounds.longitudeEast, bounds.latitudeSouth, bounds.longitudeWest);
    }

    @NotNull
    public final LatLngBounds union(double northLat, double eastLon, double southLat, double westLon) {
        LatLngBounds.Companion.checkParams(northLat, eastLon, southLat, westLon);
        return this.unionNoParamCheck(northLat, eastLon, southLat, westLon);
    }

    private final LatLngBounds unionNoParamCheck(double northLat, double eastLon, double southLat, double westLon) {
        return new LatLngBounds(this.latitudeNorth < northLat ? northLat : this.latitudeNorth, this.longitudeEast < eastLon ? eastLon : this.longitudeEast, this.latitudeSouth > southLat ? southLat : this.latitudeSouth, this.longitudeWest > westLon ? westLon : this.longitudeWest);
    }

    @Nullable
    public final LatLngBounds intersect(@NotNull LatLngBounds box) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        return this.intersectNoParamCheck(box.latitudeNorth, box.longitudeEast, box.latitudeSouth, box.longitudeWest);
    }

    @NotNull
    public final LatLngBounds intersect(double northLat, double eastLon, double southLat, double westLon) {
        LatLngBounds.Companion.checkParams(northLat, eastLon, southLat, westLon);
        LatLngBounds latLngBounds = this.intersectNoParamCheck(northLat, eastLon, southLat, westLon);
        Intrinsics.checkNotNull((Object)latLngBounds);
        return latLngBounds;
    }

    private final LatLngBounds intersectNoParamCheck(double northLat, double eastLon, double southLat, double westLon) {
        double minLonWest = Math.max(this.longitudeWest, westLon);
        double maxLonEast = Math.min(this.longitudeEast, eastLon);
        if (maxLonEast >= minLonWest) {
            double minLatSouth = Math.max(this.latitudeSouth, southLat);
            double maxLatNorth = Math.min(this.latitudeNorth, northLat);
            if (maxLatNorth >= minLatSouth) {
                return new LatLngBounds(maxLatNorth, maxLonEast, minLatSouth, minLonWest);
            }
        }
        return null;
    }

    public int hashCode() {
        return (int)(this.latitudeNorth + (double)90 + (this.latitudeSouth + (double)90) * (double)1000 + (this.longitudeEast + (double)180) * (double)1000000 + (this.longitudeWest + (double)180) * (double)1000000000);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NotNull Parcel out, int flags) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeDouble(this.latitudeNorth);
        out.writeDouble(this.longitudeEast);
        out.writeDouble(this.latitudeSouth);
        out.writeDouble(this.longitudeWest);
    }

    @JvmStatic
    @NotNull
    public static final LatLngBounds world() {
        return Companion.world();
    }

    @JvmStatic
    @NotNull
    public static final LatLngBounds from(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
        return Companion.from(latNorth, lonEast, latSouth, lonWest);
    }

    @JvmStatic
    @NotNull
    public static final LatLngBounds from(int z, int x, int y) {
        return Companion.from(z, x, y);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/maphero/android/geometry/LatLngBounds$Builder;", "", "<init>", "()V", "latLngList", "", "Lorg/maphero/android/geometry/LatLng;", "build", "Lorg/maphero/android/geometry/LatLngBounds;", "includes", "latLngs", "", "include", "latLng", "MapHeroAndroid_legacyRelease"})
    public static final class Builder {
        @NotNull
        private final List<LatLng> latLngList = new ArrayList();

        @NotNull
        public final LatLngBounds build() {
            if (this.latLngList.size() < 2) {
                throw new InvalidLatLngBoundsException(this.latLngList.size());
            }
            return Companion.fromLatLngs(this.latLngList);
        }

        @NotNull
        public final Builder includes(@NotNull List<LatLng> latLngs) {
            Intrinsics.checkNotNullParameter(latLngs, (String)"latLngs");
            this.latLngList.addAll((Collection<LatLng>)latLngs);
            return this;
        }

        @NotNull
        public final Builder include(@NotNull LatLng latLng) {
            Intrinsics.checkNotNullParameter((Object)latLng, (String)"latLng");
            this.latLngList.add(latLng);
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u0014\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ,\u0010\n\u001a\u00020\u00052\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0007J,\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0018\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014H\u0002J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0018\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00198\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/maphero/android/geometry/LatLngBounds$Companion;", "", "<init>", "()V", "world", "Lorg/maphero/android/geometry/LatLngBounds;", "fromLatLngs", "latLngs", "", "Lorg/maphero/android/geometry/LatLng;", "from", "latNorth", "", "lonEast", "latSouth", "lonWest", "checkParams", "", "lat_", "z", "", "y", "lon_", "x", "CREATOR", "Landroid/os/Parcelable$Creator;", "readFromParcel", "parcel", "Landroid/os/Parcel;", "MapHeroAndroid_legacyRelease"})
    @SourceDebugExtension(value={"SMAP\nLatLngBounds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatLngBounds.kt\norg/maphero/android/geometry/LatLngBounds$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,555:1\n1#2:556\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LatLngBounds world() {
            return this.from(90.0, 180.0, -90.0, -180.0);
        }

        @NotNull
        public final LatLngBounds fromLatLngs(@NotNull List<LatLng> latLngs) {
            Intrinsics.checkNotNullParameter(latLngs, (String)"latLngs");
            double minLat = 90.0;
            double minLon = Double.MAX_VALUE;
            double maxLat = -90.0;
            double maxLon = -1.7976931348623157E308;
            for (LatLng gp : latLngs) {
                double latitude = gp.getLatitude();
                double longitude = gp.getLongitude();
                minLat = Math.min(minLat, latitude);
                minLon = Math.min(minLon, longitude);
                maxLat = Math.max(maxLat, latitude);
                maxLon = Math.max(maxLon, longitude);
            }
            return new LatLngBounds(maxLat, maxLon, minLat, minLon);
        }

        @JvmStatic
        @NotNull
        public final LatLngBounds from(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
            this.checkParams(latNorth, lonEast, latSouth, lonWest);
            return new LatLngBounds(latNorth, lonEast, latSouth, lonWest);
        }

        private final void checkParams(@FloatRange(from=-90.0, to=90.0) double latNorth, double lonEast, @FloatRange(from=-90.0, to=90.0) double latSouth, double lonWest) {
            if (!(!ExtensionsKt.isNaN(DoubleCompanionObject.INSTANCE, latNorth) && !ExtensionsKt.isNaN(DoubleCompanionObject.INSTANCE, latSouth))) {
                boolean $i$a$-require-LatLngBounds$Companion$checkParams$72 = false;
                String $i$a$-require-LatLngBounds$Companion$checkParams$72 = "latitude must not be NaN";
                throw new IllegalArgumentException($i$a$-require-LatLngBounds$Companion$checkParams$72.toString());
            }
            if (!(!ExtensionsKt.isNaN(DoubleCompanionObject.INSTANCE, lonEast) && !ExtensionsKt.isNaN(DoubleCompanionObject.INSTANCE, lonWest))) {
                boolean $i$a$-require-LatLngBounds$Companion$checkParams$82 = false;
                String $i$a$-require-LatLngBounds$Companion$checkParams$82 = "longitude must not be NaN";
                throw new IllegalArgumentException($i$a$-require-LatLngBounds$Companion$checkParams$82.toString());
            }
            if (!(!ExtensionsKt.isInfinite(DoubleCompanionObject.INSTANCE, lonEast) && !ExtensionsKt.isInfinite(DoubleCompanionObject.INSTANCE, lonWest))) {
                boolean $i$a$-require-LatLngBounds$Companion$checkParams$92 = false;
                String $i$a$-require-LatLngBounds$Companion$checkParams$92 = "longitude must not be infinite";
                throw new IllegalArgumentException($i$a$-require-LatLngBounds$Companion$checkParams$92.toString());
            }
            if (!(!(latNorth > 90.0 || latNorth < -90.0 || latSouth > 90.0 || latSouth < -90.0))) {
                boolean $i$a$-require-LatLngBounds$Companion$checkParams$102 = false;
                String $i$a$-require-LatLngBounds$Companion$checkParams$102 = "latitude must be between -90 and 90";
                throw new IllegalArgumentException($i$a$-require-LatLngBounds$Companion$checkParams$102.toString());
            }
            if (!(latNorth >= latSouth)) {
                boolean $i$a$-require-LatLngBounds$Companion$checkParams$112 = false;
                String $i$a$-require-LatLngBounds$Companion$checkParams$112 = "latNorth cannot be less than latSouth";
                throw new IllegalArgumentException($i$a$-require-LatLngBounds$Companion$checkParams$112.toString());
            }
            if (!(lonEast >= lonWest)) {
                boolean bl = false;
                String string = "lonEast cannot be less than lonWest";
                throw new IllegalArgumentException(string.toString());
            }
        }

        private final double lat_(int z, int y) {
            double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, z);
            return Math.toDegrees(Math.atan(0.5 * (Math.exp(n) - Math.exp(-n))));
        }

        private final double lon_(int z, int x) {
            return (double)x / Math.pow(2.0, z) * 360.0 - 180.0;
        }

        @JvmStatic
        @NotNull
        public final LatLngBounds from(int z, int x, int y) {
            return new LatLngBounds(this.lat_(z, y), this.lon_(z, x + 1), this.lat_(z, y + 1), this.lon_(z, x));
        }

        private final LatLngBounds readFromParcel(Parcel parcel) {
            double northLat = parcel.readDouble();
            double eastLon = parcel.readDouble();
            double southLat = parcel.readDouble();
            double westLon = parcel.readDouble();
            return new LatLngBounds(northLat, eastLon, southLat, westLon);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ LatLngBounds access$readFromParcel(Companion $this, Parcel parcel) {
            return $this.readFromParcel(parcel);
        }
    }
}

