/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import android.animation.Animator;
import android.location.Location;
import android.os.SystemClock;
import android.util.SparseArray;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.Set;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.location.AnimatorListenerHolder;
import org.maphero.android.location.LocationComponentOptions;
import org.maphero.android.location.MapHeroAnimator;
import org.maphero.android.location.MapHeroAnimatorProvider;
import org.maphero.android.location.MapHeroAnimatorSetProvider;
import org.maphero.android.location.MapHeroFloatAnimator;
import org.maphero.android.location.MapHeroLatLngAnimator;
import org.maphero.android.location.PulsingLocationCircleAnimator;
import org.maphero.android.location.Utils;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.Projection;

final class LocationAnimatorCoordinator {
    private static final String TAG = "Mbgl-LocationAnimatorCoordinator";
    @VisibleForTesting
    final SparseArray<MapHeroAnimator> animatorArray = new SparseArray();
    private final Projection projection;
    private Location previousLocation;
    private float previousAccuracyRadius = -1.0f;
    private float previousCompassBearing = -1.0f;
    private long locationUpdateTimestamp = -1L;
    private float durationMultiplier;
    private final MapHeroAnimatorProvider animatorProvider;
    private final MapHeroAnimatorSetProvider animatorSetProvider;
    private boolean compassAnimationEnabled;
    private boolean accuracyAnimationEnabled;
    @VisibleForTesting
    int maxAnimationFps = Integer.MAX_VALUE;
    @VisibleForTesting
    final SparseArray<MapHeroAnimator.AnimationsValueChangeListener> listeners = new SparseArray();

    LocationAnimatorCoordinator(@NonNull Projection projection, @NonNull MapHeroAnimatorSetProvider animatorSetProvider, @NonNull MapHeroAnimatorProvider animatorProvider) {
        this.projection = projection;
        this.animatorProvider = animatorProvider;
        this.animatorSetProvider = animatorSetProvider;
    }

    void updateAnimatorListenerHolders(@NonNull Set<AnimatorListenerHolder> listenerHolders) {
        this.listeners.clear();
        for (AnimatorListenerHolder holder : listenerHolders) {
            this.listeners.append(holder.getAnimatorType(), (Object)holder.getListener());
        }
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            MapHeroAnimator animator;
            int animatorType = this.animatorArray.keyAt(i);
            if (this.listeners.get(animatorType) != null || (animator = (MapHeroAnimator)((Object)this.animatorArray.get(animatorType))) == null) continue;
            animator.makeInvalid();
        }
    }

    void feedNewLocation(@NonNull Location newLocation, @NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.feedNewLocation(new Location[]{newLocation}, currentCameraPosition, isGpsNorth, false);
    }

    void feedNewLocation(@NonNull @Size(min=1L) Location[] newLocations, @NonNull CameraPosition currentCameraPosition, boolean isGpsNorth, boolean lookAheadUpdate) {
        Location newLocation = newLocations[newLocations.length - 1];
        if (this.previousLocation == null) {
            this.previousLocation = newLocation;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime() - 750L;
        }
        LatLng previousLayerLatLng = this.getPreviousLayerLatLng();
        float previousLayerBearing = this.getPreviousLayerGpsBearing();
        LatLng previousCameraLatLng = currentCameraPosition.target;
        float previousCameraBearing = Utils.normalize((float)currentCameraPosition.bearing);
        LatLng[] latLngValues = this.getLatLngValues(previousLayerLatLng, newLocations);
        Float[] bearingValues = this.getBearingValues(Float.valueOf(previousLayerBearing), newLocations);
        this.updateLayerAnimators(latLngValues, bearingValues);
        latLngValues[0] = previousCameraLatLng;
        bearingValues = isGpsNorth ? new Float[]{Float.valueOf(previousCameraBearing), Float.valueOf(Utils.shortestRotation(0.0f, previousCameraBearing))} : this.getBearingValues(Float.valueOf(previousCameraBearing), newLocations);
        this.updateCameraAnimators(latLngValues, bearingValues);
        LatLng targetLatLng = new LatLng(newLocation);
        boolean snap = Utils.immediateAnimation(this.projection, previousCameraLatLng, targetLatLng) || Utils.immediateAnimation(this.projection, previousLayerLatLng, targetLatLng);
        long animationDuration = 0L;
        if (!snap) {
            long previousUpdateTimeStamp = this.locationUpdateTimestamp;
            this.locationUpdateTimestamp = SystemClock.elapsedRealtime();
            if (previousUpdateTimeStamp == 0L) {
                animationDuration = 0L;
            } else if (lookAheadUpdate) {
                long currentTimestamp = System.currentTimeMillis();
                if (currentTimestamp > newLocation.getTime()) {
                    animationDuration = 0L;
                    Logger.e("LocationAnimatorCoordinator", "Lookahead enabled, but the target location's timestamp is smaller than current timestamp");
                } else {
                    animationDuration = newLocation.getTime() - currentTimestamp;
                }
            } else {
                animationDuration = (long)((float)(this.locationUpdateTimestamp - previousUpdateTimeStamp) * this.durationMultiplier);
            }
            animationDuration = Math.min(animationDuration, 2000L);
        }
        this.playAnimators(animationDuration, 0, 2, 1, 4);
        this.previousLocation = newLocation;
    }

    void feedNewCompassBearing(float targetCompassBearing, @NonNull CameraPosition currentCameraPosition) {
        if (this.previousCompassBearing < 0.0f) {
            this.previousCompassBearing = targetCompassBearing;
        }
        float previousLayerBearing = this.getPreviousLayerCompassBearing();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        this.updateCompassAnimators(targetCompassBearing, previousLayerBearing, previousCameraBearing);
        this.playAnimators(this.compassAnimationEnabled ? 500L : 0L, 3, 5);
        this.previousCompassBearing = targetCompassBearing;
    }

    void feedNewAccuracyRadius(float targetAccuracyRadius, boolean noAnimation) {
        if (this.previousAccuracyRadius < 0.0f) {
            this.previousAccuracyRadius = targetAccuracyRadius;
        }
        float previousAccuracyRadius = this.getPreviousAccuracyRadius();
        this.updateAccuracyAnimators(targetAccuracyRadius, previousAccuracyRadius);
        this.playAnimators(noAnimation || !this.accuracyAnimationEnabled ? 0L : 250L, 6);
        this.previousAccuracyRadius = targetAccuracyRadius;
    }

    void startLocationComponentCirclePulsing(LocationComponentOptions options) {
        this.cancelAnimator(9);
        MapHeroAnimator.AnimationsValueChangeListener listener = (MapHeroAnimator.AnimationsValueChangeListener)this.listeners.get(9);
        if (listener != null) {
            PulsingLocationCircleAnimator pulsingLocationCircleAnimator = this.animatorProvider.pulsingCircleAnimator(listener, this.maxAnimationFps, options.pulseSingleDuration(), options.pulseMaxRadius(), (Interpolator)(options.pulseInterpolator() == null ? new DecelerateInterpolator() : options.pulseInterpolator()));
            this.animatorArray.put(9, (Object)pulsingLocationCircleAnimator);
            this.playPulsingAnimator();
        }
    }

    void feedNewZoomLevel(double targetZoomLevel, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.updateZoomAnimator((float)targetZoomLevel, (float)currentCameraPosition.zoom, callback);
        this.playAnimators(animationDuration, 7);
    }

    void feedNewPadding(double[] padding, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.updatePaddingAnimator(padding, currentCameraPosition.padding, callback);
        this.playAnimators(animationDuration, 10);
    }

    void feedNewTilt(double targetTilt, @NonNull CameraPosition currentCameraPosition, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.updateTiltAnimator((float)targetTilt, (float)currentCameraPosition.tilt, callback);
        this.playAnimators(animationDuration, 8);
    }

    private LatLng getPreviousLayerLatLng() {
        MapHeroAnimator latLngAnimator = (MapHeroAnimator)((Object)this.animatorArray.get(0));
        LatLng previousLatLng = latLngAnimator != null ? (LatLng)latLngAnimator.getAnimatedValue() : new LatLng(this.previousLocation);
        return previousLatLng;
    }

    private float getPreviousLayerGpsBearing() {
        MapHeroFloatAnimator animator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(2));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousLocation.getBearing();
        return previousBearing;
    }

    private float getPreviousLayerCompassBearing() {
        MapHeroFloatAnimator animator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(3));
        float previousBearing = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousCompassBearing;
        return previousBearing;
    }

    private float getPreviousAccuracyRadius() {
        MapHeroAnimator animator = (MapHeroAnimator)((Object)this.animatorArray.get(6));
        float previousRadius = animator != null ? ((Float)animator.getAnimatedValue()).floatValue() : this.previousAccuracyRadius;
        return previousRadius;
    }

    private LatLng[] getLatLngValues(LatLng previousLatLng, Location[] targetLocations) {
        LatLng[] latLngs = new LatLng[targetLocations.length + 1];
        latLngs[0] = previousLatLng;
        for (int i = 1; i < latLngs.length; ++i) {
            latLngs[i] = new LatLng(targetLocations[i - 1]);
        }
        return latLngs;
    }

    private Float[] getBearingValues(Float previousBearing, Location[] targetLocations) {
        Float[] bearings = new Float[targetLocations.length + 1];
        bearings[0] = Float.valueOf(Utils.normalize(previousBearing.floatValue()));
        for (int i = 1; i < bearings.length; ++i) {
            bearings[i] = Float.valueOf(Utils.shortestRotation(targetLocations[i - 1].getBearing(), bearings[i - 1].floatValue()));
        }
        return bearings;
    }

    private void updateLayerAnimators(LatLng[] latLngValues, Float[] bearingValues) {
        this.createNewLatLngAnimator(0, latLngValues);
        this.createNewFloatAnimator(2, bearingValues);
    }

    private void updateCameraAnimators(LatLng[] latLngValues, Float[] bearingValues) {
        this.createNewLatLngAnimator(1, latLngValues);
        this.createNewFloatAnimator(4, bearingValues);
    }

    private void updateCompassAnimators(float targetCompassBearing, float previousLayerBearing, float previousCameraBearing) {
        float normalizedLayerBearing = Utils.shortestRotation(targetCompassBearing, previousLayerBearing);
        this.createNewFloatAnimator(3, previousLayerBearing, normalizedLayerBearing);
        float normalizedCameraBearing = Utils.shortestRotation(targetCompassBearing, previousCameraBearing);
        this.createNewFloatAnimator(5, previousCameraBearing, normalizedCameraBearing);
    }

    private void updateAccuracyAnimators(float targetAccuracyRadius, float previousAccuracyRadius) {
        this.createNewFloatAnimator(6, previousAccuracyRadius, targetAccuracyRadius);
    }

    private void updateZoomAnimator(float targetZoomLevel, float previousZoomLevel, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(7, new Float[]{Float.valueOf(previousZoomLevel), Float.valueOf(targetZoomLevel)}, cancelableCallback);
    }

    private void updatePaddingAnimator(double[] targetPadding, double[] previousPadding, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        this.createNewPaddingAnimator(10, new double[][]{previousPadding, targetPadding}, cancelableCallback);
    }

    private void updateTiltAnimator(float targetTilt, float previousTiltLevel, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        this.createNewCameraAdapterAnimator(8, new Float[]{Float.valueOf(previousTiltLevel), Float.valueOf(targetTilt)}, cancelableCallback);
    }

    private void createNewLatLngAnimator(int animatorType, LatLng previous, LatLng target) {
        this.createNewLatLngAnimator(animatorType, new LatLng[]{previous, target});
    }

    private void createNewLatLngAnimator(int animatorType, LatLng[] values) {
        this.cancelAnimator(animatorType);
        MapHeroAnimator.AnimationsValueChangeListener listener = (MapHeroAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.latLngAnimator(values, listener, this.maxAnimationFps));
        }
    }

    private void createNewFloatAnimator(int animatorType, float previous, float target) {
        this.createNewFloatAnimator(animatorType, new Float[]{Float.valueOf(previous), Float.valueOf(target)});
    }

    private void createNewFloatAnimator(int animatorType, @NonNull @Size(min=2L) Float[] values) {
        this.cancelAnimator(animatorType);
        MapHeroAnimator.AnimationsValueChangeListener listener = (MapHeroAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.floatAnimator(values, listener, this.maxAnimationFps));
        }
    }

    private void createNewCameraAdapterAnimator(int animatorType, @NonNull @Size(min=2L) Float[] values, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        this.cancelAnimator(animatorType);
        MapHeroAnimator.AnimationsValueChangeListener listener = (MapHeroAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.cameraAnimator(values, listener, cancelableCallback));
        }
    }

    private void createNewPaddingAnimator(int animatorType, @NonNull @Size(min=2L) double[][] values, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        this.cancelAnimator(animatorType);
        MapHeroAnimator.AnimationsValueChangeListener listener = (MapHeroAnimator.AnimationsValueChangeListener)this.listeners.get(animatorType);
        if (listener != null) {
            this.animatorArray.put(animatorType, (Object)this.animatorProvider.paddingAnimator(values, listener, cancelableCallback));
        }
    }

    private float checkGpsNorth(boolean isGpsNorth, float targetCameraBearing) {
        if (isGpsNorth) {
            targetCameraBearing = 0.0f;
        }
        return targetCameraBearing;
    }

    private void playAnimators(long duration, int ... animatorTypes) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        for (int animatorType : animatorTypes) {
            Animator animator = (Animator)this.animatorArray.get(animatorType);
            if (animator == null) continue;
            animators.add(animator);
        }
        this.animatorSetProvider.startAnimation(animators, (Interpolator)new LinearInterpolator(), duration);
    }

    private void playPulsingAnimator() {
        Animator animator = (Animator)this.animatorArray.get(9);
        if (animator != null) {
            animator.start();
        }
    }

    void resetAllCameraAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraCompassAnimation(currentCameraPosition);
        boolean snap = this.resetCameraLocationAnimations(currentCameraPosition, isGpsNorth);
        this.playAnimators(snap ? 0L : 750L, 1, 4);
    }

    private boolean resetCameraLocationAnimations(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        this.resetCameraGpsBearingAnimation(currentCameraPosition, isGpsNorth);
        return this.resetCameraLatLngAnimation(currentCameraPosition);
    }

    private boolean resetCameraLatLngAnimation(@NonNull CameraPosition currentCameraPosition) {
        MapHeroLatLngAnimator animator = (MapHeroLatLngAnimator)((Object)this.animatorArray.get(1));
        if (animator == null) {
            return false;
        }
        LatLng currentTarget = (LatLng)animator.getTarget();
        LatLng previousCameraTarget = currentCameraPosition.target;
        this.createNewLatLngAnimator(1, previousCameraTarget, currentTarget);
        return Utils.immediateAnimation(this.projection, previousCameraTarget, currentTarget);
    }

    private void resetCameraGpsBearingAnimation(@NonNull CameraPosition currentCameraPosition, boolean isGpsNorth) {
        MapHeroFloatAnimator animator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(4));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        currentTargetBearing = this.checkGpsNorth(isGpsNorth, currentTargetBearing);
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewFloatAnimator(4, previousCameraBearing, normalizedCameraBearing);
    }

    private void resetCameraCompassAnimation(@NonNull CameraPosition currentCameraPosition) {
        MapHeroFloatAnimator animator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(5));
        if (animator == null) {
            return;
        }
        float currentTargetBearing = ((Float)animator.getTarget()).floatValue();
        float previousCameraBearing = (float)currentCameraPosition.bearing;
        float normalizedCameraBearing = Utils.shortestRotation(currentTargetBearing, previousCameraBearing);
        this.createNewFloatAnimator(5, previousCameraBearing, normalizedCameraBearing);
    }

    void resetAllLayerAnimations() {
        MapHeroLatLngAnimator latLngAnimator = (MapHeroLatLngAnimator)((Object)this.animatorArray.get(0));
        MapHeroFloatAnimator gpsBearingAnimator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(2));
        MapHeroFloatAnimator compassBearingAnimator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(3));
        MapHeroFloatAnimator accuracyAnimator = (MapHeroFloatAnimator)((Object)this.animatorArray.get(6));
        if (latLngAnimator != null && gpsBearingAnimator != null) {
            LatLng currentLatLng = (LatLng)latLngAnimator.getAnimatedValue();
            LatLng currentLatLngTarget = (LatLng)latLngAnimator.getTarget();
            this.createNewLatLngAnimator(0, currentLatLng, currentLatLngTarget);
            float currentGpsBearing = ((Float)gpsBearingAnimator.getAnimatedValue()).floatValue();
            float currentGpsBearingTarget = ((Float)gpsBearingAnimator.getTarget()).floatValue();
            this.createNewFloatAnimator(2, currentGpsBearing, currentGpsBearingTarget);
            long duration = latLngAnimator.getDuration() - latLngAnimator.getCurrentPlayTime();
            this.playAnimators(duration, 0, 2);
        }
        if (compassBearingAnimator != null) {
            float currentLayerBearing = this.getPreviousLayerCompassBearing();
            float currentLayerBearingTarget = ((Float)compassBearingAnimator.getTarget()).floatValue();
            this.createNewFloatAnimator(3, currentLayerBearing, currentLayerBearingTarget);
            this.playAnimators(this.compassAnimationEnabled ? 500L : 0L, 3);
        }
        if (accuracyAnimator != null) {
            this.feedNewAccuracyRadius(this.previousAccuracyRadius, false);
        }
    }

    void cancelZoomAnimation() {
        this.cancelAnimator(7);
    }

    void cancelPaddingAnimation() {
        this.cancelAnimator(10);
    }

    void cancelTiltAnimation() {
        this.cancelAnimator(8);
    }

    void cancelAndRemoveGpsBearingAnimation() {
        this.cancelAnimator(2);
        this.animatorArray.remove(2);
    }

    void stopPulsingCircleAnimation() {
        this.cancelAnimator(9);
    }

    void cancelAllAnimations() {
        for (int i = 0; i < this.animatorArray.size(); ++i) {
            int animatorType = this.animatorArray.keyAt(i);
            this.cancelAnimator(animatorType);
        }
    }

    private void cancelAnimator(int animatorType) {
        MapHeroAnimator animator = (MapHeroAnimator)((Object)this.animatorArray.get(animatorType));
        if (animator != null) {
            animator.cancel();
            animator.removeAllUpdateListeners();
            animator.removeAllListeners();
        }
    }

    void setTrackingAnimationDurationMultiplier(float trackingAnimationDurationMultiplier) {
        this.durationMultiplier = trackingAnimationDurationMultiplier;
    }

    void setCompassAnimationEnabled(boolean compassAnimationEnabled) {
        this.compassAnimationEnabled = compassAnimationEnabled;
    }

    void setAccuracyAnimationEnabled(boolean accuracyAnimationEnabled) {
        this.accuracyAnimationEnabled = accuracyAnimationEnabled;
    }

    void setMaxAnimationFps(int maxAnimationFps) {
        if (maxAnimationFps <= 0) {
            Logger.e(TAG, "Max animation FPS cannot be less or equal to 0.");
            return;
        }
        this.maxAnimationFps = maxAnimationFps;
    }
}

