/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.maphero.android.maps.Style;
import org.maphero.android.style.layers.Layer;

class LocationComponentPositionManager {
    @NonNull
    private final Style style;
    @Nullable
    private String layerAbove;
    @Nullable
    private String layerBelow;

    LocationComponentPositionManager(@NonNull Style style2, @Nullable String layerAbove, @Nullable String layerBelow) {
        this.style = style2;
        this.layerAbove = layerAbove;
        this.layerBelow = layerBelow;
    }

    boolean update(@Nullable String layerAbove, @Nullable String layerBelow) {
        boolean requiresUpdate = this.layerAbove != layerAbove && (this.layerAbove == null || !this.layerAbove.equals(layerAbove)) || this.layerBelow != layerBelow && (this.layerBelow == null || !this.layerBelow.equals(layerBelow));
        this.layerAbove = layerAbove;
        this.layerBelow = layerBelow;
        return requiresUpdate;
    }

    void addLayerToMap(@NonNull Layer layer) {
        if (this.layerAbove != null) {
            this.style.addLayerAbove(layer, this.layerAbove);
        } else if (this.layerBelow != null) {
            this.style.addLayerBelow(layer, this.layerBelow);
        } else {
            this.style.addLayer(layer);
        }
    }
}

