/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.engine;

import android.app.PendingIntent;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maphero.android.location.engine.LocationEngine;
import org.maphero.android.location.engine.LocationEngineCallback;
import org.maphero.android.location.engine.LocationEngineImpl;
import org.maphero.android.location.engine.LocationEngineRequest;
import org.maphero.android.location.engine.LocationEngineResult;
import org.maphero.android.location.engine.Utils;

public class LocationEngineProxy<T>
implements LocationEngine {
    private final LocationEngineImpl<T> locationEngineImpl;
    private Map<LocationEngineCallback<LocationEngineResult>, T> listeners;

    public LocationEngineProxy(LocationEngineImpl<T> locationEngineImpl) {
        this.locationEngineImpl = locationEngineImpl;
    }

    @Override
    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        Utils.checkNotNull(callback, "callback == null");
        this.locationEngineImpl.getLastLocation(callback);
    }

    @Override
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationEngineCallback<LocationEngineResult> callback, @Nullable Looper looper) throws SecurityException {
        Utils.checkNotNull(request, "request == null");
        Utils.checkNotNull(callback, "callback == null");
        this.locationEngineImpl.requestLocationUpdates(request, this.getListener(callback), looper == null ? Looper.getMainLooper() : looper);
    }

    @Override
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, PendingIntent pendingIntent) throws SecurityException {
        Utils.checkNotNull(request, "request == null");
        this.locationEngineImpl.requestLocationUpdates(request, pendingIntent);
    }

    @Override
    public void removeLocationUpdates(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        Utils.checkNotNull(callback, "callback == null");
        this.locationEngineImpl.removeLocationUpdates(this.removeListener(callback));
    }

    @Override
    public void removeLocationUpdates(PendingIntent pendingIntent) {
        this.locationEngineImpl.removeLocationUpdates(pendingIntent);
    }

    @VisibleForTesting
    int getListenersCount() {
        return this.listeners != null ? this.listeners.size() : 0;
    }

    @VisibleForTesting
    T getListener(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        T listener;
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap<LocationEngineCallback<LocationEngineResult>, T>();
        }
        if ((listener = this.listeners.get(callback)) == null) {
            listener = this.locationEngineImpl.createListener(callback);
        }
        this.listeners.put(callback, listener);
        return listener;
    }

    @VisibleForTesting
    T removeListener(@NonNull LocationEngineCallback<LocationEngineResult> callback) {
        return this.listeners != null ? (T)this.listeners.remove(callback) : null;
    }
}

