/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.engine;

public class LocationEngineRequest {
    public static final int PRIORITY_HIGH_ACCURACY = 0;
    public static final int PRIORITY_BALANCED_POWER_ACCURACY = 1;
    public static final int PRIORITY_LOW_POWER = 2;
    public static final int PRIORITY_NO_POWER = 3;
    private final long interval;
    private final int priority;
    private final float displacement;
    private final long maxWaitTime;
    private final long fastestInterval;

    private LocationEngineRequest(Builder builder) {
        this.interval = builder.interval;
        this.priority = builder.priority;
        this.displacement = builder.displacement;
        this.maxWaitTime = builder.maxWaitTime;
        this.fastestInterval = builder.fastestInterval;
    }

    public long getInterval() {
        return this.interval;
    }

    public int getPriority() {
        return this.priority;
    }

    public float getDisplacement() {
        return this.displacement;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime;
    }

    public long getFastestInterval() {
        return this.fastestInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationEngineRequest that = (LocationEngineRequest)o;
        if (this.interval != that.interval) {
            return false;
        }
        if (this.priority != that.priority) {
            return false;
        }
        if (Float.compare(that.displacement, this.displacement) != 0) {
            return false;
        }
        if (this.maxWaitTime != that.maxWaitTime) {
            return false;
        }
        return this.fastestInterval == that.fastestInterval;
    }

    public int hashCode() {
        int result = (int)(this.interval ^ this.interval >>> 32);
        result = 31 * result + this.priority;
        result = 31 * result + (this.displacement != 0.0f ? Float.floatToIntBits(this.displacement) : 0);
        result = 31 * result + (int)(this.maxWaitTime ^ this.maxWaitTime >>> 32);
        result = 31 * result + (int)(this.fastestInterval ^ this.fastestInterval >>> 32);
        return result;
    }

    public static final class Builder {
        private final long interval;
        private int priority;
        private float displacement;
        private long maxWaitTime;
        private long fastestInterval;

        public Builder(long interval) {
            this.interval = interval;
            this.priority = 0;
            this.displacement = 0.0f;
            this.maxWaitTime = 0L;
            this.fastestInterval = 0L;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setDisplacement(float displacement) {
            this.displacement = displacement;
            return this;
        }

        public Builder setMaxWaitTime(long maxWaitTime) {
            this.maxWaitTime = maxWaitTime;
            return this;
        }

        public Builder setFastestInterval(long interval) {
            this.fastestInterval = interval;
            return this;
        }

        public LocationEngineRequest build() {
            return new LocationEngineRequest(this);
        }
    }
}

