/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.engine;

import android.location.Location;
import androidx.annotation.Nullable;

final class Utils {
    private static final int TWO_MINUTES = 120000;
    private static final int ACCURACY_THRESHOLD_METERS = 200;

    private Utils() {
    }

    static <T> T checkNotNull(@Nullable T reference, String message) {
        if (reference == null) {
            throw new NullPointerException(message);
        }
        return reference;
    }

    static boolean isOnClasspath(String className) {
        boolean isOnClassPath = true;
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException exception) {
            isOnClassPath = false;
        }
        return isOnClassPath;
    }

    static boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > 120000L;
        boolean isSignificantlyOlder = timeDelta < -120000L;
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = Utils.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private static boolean isSameProvider(String provider1, String provider2) {
        if (provider1 == null) {
            return provider2 == null;
        }
        return provider1.equals(provider2);
    }
}

