/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.maps.Annotations;
import org.maphero.android.maps.NativeMap;

class AnnotationContainer
implements Annotations {
    private final NativeMap nativeMap;
    private final LongSparseArray<Annotation> annotations;

    AnnotationContainer(NativeMap nativeMap, LongSparseArray<Annotation> annotations) {
        this.nativeMap = nativeMap;
        this.annotations = annotations;
    }

    @Override
    public Annotation obtainBy(long id2) {
        return (Annotation)this.annotations.get(id2);
    }

    @Override
    @NonNull
    public List<Annotation> obtainAll() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }

    @Override
    public void removeBy(long id2) {
        if (this.nativeMap != null) {
            this.nativeMap.removeAnnotation(id2);
        }
        this.annotations.remove(id2);
    }

    @Override
    public void removeBy(@NonNull Annotation annotation) {
        long id2 = annotation.getId();
        this.removeBy(id2);
    }

    @Override
    public void removeBy(@NonNull List<? extends Annotation> annotationList) {
        int count = annotationList.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = annotationList.get(i).getId();
        }
        this.removeNativeAnnotations(ids);
        for (long id2 : ids) {
            this.annotations.remove(id2);
        }
    }

    @Override
    public void removeAll() {
        int count = this.annotations.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotations.keyAt(i);
        }
        this.removeNativeAnnotations(ids);
        this.annotations.clear();
    }

    private void removeNativeAnnotations(long[] ids) {
        if (this.nativeMap != null) {
            this.nativeMap.removeAnnotations(ids);
        }
    }
}

