/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.MapHero;
import org.maphero.android.R;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.annotations.BaseMarkerOptions;
import org.maphero.android.annotations.Marker;
import org.maphero.android.annotations.Polygon;
import org.maphero.android.annotations.PolygonOptions;
import org.maphero.android.annotations.Polyline;
import org.maphero.android.annotations.PolylineOptions;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.Annotations;
import org.maphero.android.maps.IconManager;
import org.maphero.android.maps.InfoWindowManager;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.MapView;
import org.maphero.android.maps.Markers;
import org.maphero.android.maps.Polygons;
import org.maphero.android.maps.Polylines;
import org.maphero.android.maps.Projection;
import org.maphero.android.maps.ShapeAnnotations;

class AnnotationManager {
    private static final String TAG = "Mbgl-AnnotationManager";
    private static final long NO_ANNOTATION_ID = -1L;
    @NonNull
    private final MapView mapView;
    private final IconManager iconManager;
    private final InfoWindowManager infoWindowManager = new InfoWindowManager();
    private final LongSparseArray<Annotation> annotationsArray;
    private final List<Marker> selectedMarkers = new ArrayList<Marker>();
    private MapHeroMap mapHeroMap;
    @Nullable
    private MapHeroMap.OnMarkerClickListener onMarkerClickListener;
    @Nullable
    private MapHeroMap.OnPolygonClickListener onPolygonClickListener;
    @Nullable
    private MapHeroMap.OnPolylineClickListener onPolylineClickListener;
    private Annotations annotations;
    private ShapeAnnotations shapeAnnotations;
    private Markers markers;
    private Polygons polygons;
    private Polylines polylines;

    AnnotationManager(@NonNull MapView mapView, LongSparseArray<Annotation> annotationsArray, IconManager iconManager, Annotations annotations, Markers markers, Polygons polygons, Polylines polylines, ShapeAnnotations shapeAnnotations) {
        this.mapView = mapView;
        this.annotationsArray = annotationsArray;
        this.iconManager = iconManager;
        this.annotations = annotations;
        this.markers = markers;
        this.polygons = polygons;
        this.polylines = polylines;
        this.shapeAnnotations = shapeAnnotations;
    }

    @NonNull
    AnnotationManager bind(MapHeroMap mapHeroMap) {
        this.mapHeroMap = mapHeroMap;
        return this;
    }

    void update() {
        this.infoWindowManager.update();
    }

    Annotation getAnnotation(long id2) {
        return this.annotations.obtainBy(id2);
    }

    List<Annotation> getAnnotations() {
        return this.annotations.obtainAll();
    }

    void removeAnnotation(long id2) {
        this.annotations.removeBy(id2);
    }

    void removeAnnotation(@NonNull Annotation annotation) {
        if (annotation instanceof Marker) {
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(annotation);
    }

    void removeAnnotations(@NonNull List<? extends Annotation> annotationList) {
        for (Annotation annotation : annotationList) {
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            if (this.selectedMarkers.contains(marker)) {
                this.selectedMarkers.remove(marker);
            }
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeBy(annotationList);
    }

    void removeAnnotations() {
        int count = this.annotationsArray.size();
        long[] ids = new long[count];
        this.selectedMarkers.clear();
        for (int i = 0; i < count; ++i) {
            ids[i] = this.annotationsArray.keyAt(i);
            Annotation annotation = (Annotation)this.annotationsArray.get(ids[i]);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.hideInfoWindow();
            this.iconManager.iconCleanup(marker.getIcon());
        }
        this.annotations.removeAll();
    }

    Marker addMarker(@NonNull BaseMarkerOptions markerOptions, @NonNull MapHeroMap mapHeroMapMap) {
        return this.markers.addBy(markerOptions, mapHeroMapMap);
    }

    List<Marker> addMarkers(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapHeroMap mapHeroMap) {
        return this.markers.addBy(markerOptionsList, mapHeroMap);
    }

    void updateMarker(@NonNull Marker updatedMarker, @NonNull MapHeroMap mapHeroMap) {
        if (!this.isAddedToMap(updatedMarker)) {
            this.logNonAdded(updatedMarker);
            return;
        }
        this.markers.update(updatedMarker, mapHeroMap);
    }

    List<Marker> getMarkers() {
        return this.markers.obtainAll();
    }

    @NonNull
    List<Marker> getMarkersInRect(@NonNull RectF rectangle) {
        return this.markers.obtainAllIn(rectangle);
    }

    void reloadMarkers() {
        this.markers.reload();
    }

    Polygon addPolygon(@NonNull PolygonOptions polygonOptions, @NonNull MapHeroMap mapHeroMap) {
        return this.polygons.addBy(polygonOptions, mapHeroMap);
    }

    List<Polygon> addPolygons(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapHeroMap mapHeroMap) {
        return this.polygons.addBy(polygonOptionsList, mapHeroMap);
    }

    void updatePolygon(@NonNull Polygon polygon) {
        if (!this.isAddedToMap(polygon)) {
            this.logNonAdded(polygon);
            return;
        }
        this.polygons.update(polygon);
    }

    List<Polygon> getPolygons() {
        return this.polygons.obtainAll();
    }

    Polyline addPolyline(@NonNull PolylineOptions polylineOptions, @NonNull MapHeroMap mapHeroMapMap) {
        return this.polylines.addBy(polylineOptions, mapHeroMapMap);
    }

    List<Polyline> addPolylines(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapHeroMap mapHeroMap) {
        return this.polylines.addBy(polylineOptionsList, mapHeroMap);
    }

    void updatePolyline(@NonNull Polyline polyline) {
        if (!this.isAddedToMap(polyline)) {
            this.logNonAdded(polyline);
            return;
        }
        this.polylines.update(polyline);
    }

    List<Polyline> getPolylines() {
        return this.polylines.obtainAll();
    }

    void setOnMarkerClickListener(@Nullable MapHeroMap.OnMarkerClickListener listener) {
        this.onMarkerClickListener = listener;
    }

    void setOnPolygonClickListener(@Nullable MapHeroMap.OnPolygonClickListener listener) {
        this.onPolygonClickListener = listener;
    }

    void setOnPolylineClickListener(@Nullable MapHeroMap.OnPolylineClickListener listener) {
        this.onPolylineClickListener = listener;
    }

    void selectMarker(@NonNull Marker marker) {
        if (this.selectedMarkers.contains(marker)) {
            return;
        }
        if (!this.infoWindowManager.isAllowConcurrentMultipleOpenInfoWindows()) {
            this.deselectMarkers();
        }
        if (this.infoWindowManager.isInfoWindowValidForMarker(marker) || this.infoWindowManager.getInfoWindowAdapter() != null) {
            this.infoWindowManager.add(marker.showInfoWindow(this.mapHeroMap, this.mapView));
        }
        this.selectedMarkers.add(marker);
    }

    void deselectMarkers() {
        if (this.selectedMarkers.isEmpty()) {
            return;
        }
        for (Marker marker : this.selectedMarkers) {
            if (marker == null || !marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
        }
        this.selectedMarkers.clear();
    }

    void deselectMarker(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            return;
        }
        if (marker.isInfoWindowShown()) {
            marker.hideInfoWindow();
        }
        this.selectedMarkers.remove(marker);
    }

    @NonNull
    List<Marker> getSelectedMarkers() {
        return this.selectedMarkers;
    }

    @NonNull
    InfoWindowManager getInfoWindowManager() {
        return this.infoWindowManager;
    }

    void adjustTopOffsetPixels(@NonNull MapHeroMap mapHeroMap) {
        int count = this.annotationsArray.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotationsArray.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            marker.setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(marker.getIcon()));
        }
        for (Marker marker : this.selectedMarkers) {
            if (!marker.isInfoWindowShown()) continue;
            marker.hideInfoWindow();
            marker.showInfoWindow(mapHeroMap, this.mapView);
        }
    }

    private boolean isAddedToMap(@Nullable Annotation annotation) {
        return annotation != null && annotation.getId() != -1L && this.annotationsArray.indexOfKey(annotation.getId()) > -1;
    }

    private void logNonAdded(@NonNull Annotation annotation) {
        Logger.w(TAG, String.format("Attempting to update non-added %s with value %s", annotation.getClass().getCanonicalName(), annotation));
    }

    boolean onTap(@NonNull PointF tapPoint) {
        MarkerHit markerHit = this.getMarkerHitFromTouchArea(tapPoint);
        long markerId = new MarkerHitResolver(this.mapHeroMap).execute(markerHit);
        if (markerId != -1L && this.isClickHandledForMarker(markerId)) {
            return true;
        }
        ShapeAnnotationHit shapeAnnotationHit = this.getShapeAnnotationHitFromTap(tapPoint);
        Annotation annotation = new ShapeAnnotationHitResolver(this.shapeAnnotations).execute(shapeAnnotationHit);
        return annotation != null && this.handleClickForShapeAnnotation(annotation);
    }

    private ShapeAnnotationHit getShapeAnnotationHitFromTap(PointF tapPoint) {
        float touchTargetSide = MapHero.getApplicationContext().getResources().getDimension(R.dimen.maphero_eight_dp);
        RectF tapRect = new RectF(tapPoint.x - touchTargetSide, tapPoint.y - touchTargetSide, tapPoint.x + touchTargetSide, tapPoint.y + touchTargetSide);
        return new ShapeAnnotationHit(tapRect);
    }

    private boolean handleClickForShapeAnnotation(Annotation annotation) {
        if (annotation instanceof Polygon && this.onPolygonClickListener != null) {
            this.onPolygonClickListener.onPolygonClick((Polygon)annotation);
            return true;
        }
        if (annotation instanceof Polyline && this.onPolylineClickListener != null) {
            this.onPolylineClickListener.onPolylineClick((Polyline)annotation);
            return true;
        }
        return false;
    }

    private MarkerHit getMarkerHitFromTouchArea(PointF tapPoint) {
        int touchSurfaceWidth = (int)((double)this.iconManager.getHighestIconHeight() * 1.5);
        int touchSurfaceHeight = (int)((double)this.iconManager.getHighestIconWidth() * 1.5);
        RectF tapRect = new RectF(tapPoint.x - (float)touchSurfaceWidth, tapPoint.y - (float)touchSurfaceHeight, tapPoint.x + (float)touchSurfaceWidth, tapPoint.y + (float)touchSurfaceHeight);
        return new MarkerHit(tapRect, this.getMarkersInRect(tapRect));
    }

    private boolean isClickHandledForMarker(long markerId) {
        Marker marker = (Marker)this.getAnnotation(markerId);
        boolean handledDefaultClick = this.onClickMarker(marker);
        if (!handledDefaultClick) {
            this.toggleMarkerSelectionState(marker);
        }
        return true;
    }

    private boolean onClickMarker(@NonNull Marker marker) {
        return this.onMarkerClickListener != null && this.onMarkerClickListener.onMarkerClick(marker);
    }

    private void toggleMarkerSelectionState(@NonNull Marker marker) {
        if (!this.selectedMarkers.contains(marker)) {
            this.selectMarker(marker);
        } else {
            this.deselectMarker(marker);
        }
    }

    private static class MarkerHit {
        private final RectF tapRect;
        private final List<Marker> markers;

        MarkerHit(RectF tapRect, List<Marker> markers) {
            this.tapRect = tapRect;
            this.markers = markers;
        }

        float getTapPointX() {
            return this.tapRect.centerX();
        }

        float getTapPointY() {
            return this.tapRect.centerY();
        }
    }

    private static class MarkerHitResolver {
        @NonNull
        private final Projection projection;
        private final int minimalTouchSize;
        @Nullable
        private View view;
        private Bitmap bitmap;
        private int bitmapWidth;
        private int bitmapHeight;
        private PointF markerLocation;
        @NonNull
        private Rect hitRectView = new Rect();
        @NonNull
        private RectF hitRectMarker = new RectF();
        @NonNull
        private RectF highestSurfaceIntersection = new RectF();
        private long closestMarkerId = -1L;

        MarkerHitResolver(@NonNull MapHeroMap mapHeroMap) {
            this.projection = mapHeroMap.getProjection();
            this.minimalTouchSize = (int)(32.0f * MapHero.getApplicationContext().getResources().getDisplayMetrics().density);
        }

        public long execute(@NonNull MarkerHit markerHit) {
            this.resolveForMarkers(markerHit);
            return this.closestMarkerId;
        }

        private void resolveForMarkers(MarkerHit markerHit) {
            for (Marker marker : markerHit.markers) {
                this.resolveForMarker(markerHit, marker);
            }
        }

        private void resolveForMarker(@NonNull MarkerHit markerHit, Marker marker) {
            this.markerLocation = this.projection.toScreenLocation(marker.getPosition());
            this.bitmap = marker.getIcon().getBitmap();
            this.bitmapHeight = this.bitmap.getHeight();
            if (this.bitmapHeight < this.minimalTouchSize) {
                this.bitmapHeight = this.minimalTouchSize;
            }
            this.bitmapWidth = this.bitmap.getWidth();
            if (this.bitmapWidth < this.minimalTouchSize) {
                this.bitmapWidth = this.minimalTouchSize;
            }
            this.hitRectMarker.set(0.0f, 0.0f, (float)this.bitmapWidth, (float)this.bitmapHeight);
            this.hitRectMarker.offsetTo(this.markerLocation.x - (float)(this.bitmapWidth / 2), this.markerLocation.y - (float)(this.bitmapHeight / 2));
            this.hitTestMarker(markerHit, marker, this.hitRectMarker);
        }

        private void hitTestMarker(MarkerHit markerHit, @NonNull Marker marker, RectF hitRectMarker) {
            if (hitRectMarker.contains(markerHit.getTapPointX(), markerHit.getTapPointY())) {
                hitRectMarker.intersect(markerHit.tapRect);
                if (this.isRectangleHighestSurfaceIntersection(hitRectMarker)) {
                    this.highestSurfaceIntersection = new RectF(hitRectMarker);
                    this.closestMarkerId = marker.getId();
                }
            }
        }

        private boolean isRectangleHighestSurfaceIntersection(RectF rectF) {
            return rectF.width() * rectF.height() > this.highestSurfaceIntersection.width() * this.highestSurfaceIntersection.height();
        }
    }

    private static class ShapeAnnotationHit {
        private final RectF tapPoint;

        ShapeAnnotationHit(RectF tapPoint) {
            this.tapPoint = tapPoint;
        }
    }

    private static class ShapeAnnotationHitResolver {
        private ShapeAnnotations shapeAnnotations;

        ShapeAnnotationHitResolver(ShapeAnnotations shapeAnnotations) {
            this.shapeAnnotations = shapeAnnotations;
        }

        @Nullable
        public Annotation execute(@NonNull ShapeAnnotationHit shapeHit) {
            Annotation foundAnnotation = null;
            List<Annotation> annotations = this.shapeAnnotations.obtainAllIn(shapeHit.tapPoint);
            if (annotations.size() > 0) {
                foundAnnotation = annotations.get(0);
            }
            return foundAnnotation;
        }
    }
}

