/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import java.util.concurrent.CopyOnWriteArrayList;
import org.maphero.android.maps.MapHeroMap;

class CameraChangeDispatcher
implements MapHeroMap.OnCameraMoveStartedListener,
MapHeroMap.OnCameraMoveListener,
MapHeroMap.OnCameraMoveCanceledListener,
MapHeroMap.OnCameraIdleListener {
    private final CameraChangeHandler handler = new CameraChangeHandler(this);
    private boolean idle = true;
    private int moveStartedReason;
    private final CopyOnWriteArrayList<MapHeroMap.OnCameraMoveStartedListener> onCameraMoveStarted = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapHeroMap.OnCameraMoveCanceledListener> onCameraMoveCanceled = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapHeroMap.OnCameraMoveListener> onCameraMove = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<MapHeroMap.OnCameraIdleListener> onCameraIdle = new CopyOnWriteArrayList();
    private static final int MOVE_STARTED = 0;
    private static final int MOVE = 1;
    private static final int MOVE_CANCELED = 2;
    private static final int IDLE = 3;

    CameraChangeDispatcher() {
    }

    @Override
    public void onCameraMoveStarted(int reason) {
        this.moveStartedReason = reason;
        this.handler.scheduleMessage(0);
    }

    @Override
    public void onCameraMove() {
        this.handler.scheduleMessage(1);
    }

    @Override
    public void onCameraMoveCanceled() {
        this.handler.scheduleMessage(2);
    }

    @Override
    public void onCameraIdle() {
        this.handler.scheduleMessage(3);
    }

    void addOnCameraIdleListener(@NonNull MapHeroMap.OnCameraIdleListener listener) {
        this.onCameraIdle.add(listener);
    }

    void removeOnCameraIdleListener(@NonNull MapHeroMap.OnCameraIdleListener listener) {
        if (this.onCameraIdle.contains(listener)) {
            this.onCameraIdle.remove(listener);
        }
    }

    void addOnCameraMoveCancelListener(MapHeroMap.OnCameraMoveCanceledListener listener) {
        this.onCameraMoveCanceled.add(listener);
    }

    void removeOnCameraMoveCancelListener(MapHeroMap.OnCameraMoveCanceledListener listener) {
        if (this.onCameraMoveCanceled.contains(listener)) {
            this.onCameraMoveCanceled.remove(listener);
        }
    }

    void addOnCameraMoveStartedListener(MapHeroMap.OnCameraMoveStartedListener listener) {
        this.onCameraMoveStarted.add(listener);
    }

    void removeOnCameraMoveStartedListener(MapHeroMap.OnCameraMoveStartedListener listener) {
        if (this.onCameraMoveStarted.contains(listener)) {
            this.onCameraMoveStarted.remove(listener);
        }
    }

    void addOnCameraMoveListener(MapHeroMap.OnCameraMoveListener listener) {
        this.onCameraMove.add(listener);
    }

    void removeOnCameraMoveListener(MapHeroMap.OnCameraMoveListener listener) {
        if (this.onCameraMove.contains(listener)) {
            this.onCameraMove.remove(listener);
        }
    }

    private void executeOnCameraMoveStarted() {
        if (!this.idle) {
            return;
        }
        this.idle = false;
        if (!this.onCameraMoveStarted.isEmpty()) {
            for (MapHeroMap.OnCameraMoveStartedListener cameraMoveStartedListener : this.onCameraMoveStarted) {
                cameraMoveStartedListener.onCameraMoveStarted(this.moveStartedReason);
            }
        }
    }

    private void executeOnCameraMove() {
        if (!this.onCameraMove.isEmpty() && !this.idle) {
            for (MapHeroMap.OnCameraMoveListener cameraMoveListener : this.onCameraMove) {
                cameraMoveListener.onCameraMove();
            }
        }
    }

    private void executeOnCameraMoveCancelled() {
        if (!this.onCameraMoveCanceled.isEmpty() && !this.idle) {
            for (MapHeroMap.OnCameraMoveCanceledListener cameraMoveCanceledListener : this.onCameraMoveCanceled) {
                cameraMoveCanceledListener.onCameraMoveCanceled();
            }
        }
    }

    private void executeOnCameraIdle() {
        if (this.idle) {
            return;
        }
        this.idle = true;
        if (!this.onCameraIdle.isEmpty()) {
            for (MapHeroMap.OnCameraIdleListener cameraIdleListener : this.onCameraIdle) {
                cameraIdleListener.onCameraIdle();
            }
        }
    }

    void onDestroy() {
        this.handler.removeCallbacksAndMessages(null);
        this.onCameraMoveStarted.clear();
        this.onCameraMoveCanceled.clear();
        this.onCameraMove.clear();
        this.onCameraIdle.clear();
    }

    private static class CameraChangeHandler
    extends Handler {
        private WeakReference<CameraChangeDispatcher> dispatcherWeakReference;

        CameraChangeHandler(CameraChangeDispatcher dispatcher) {
            this.dispatcherWeakReference = new WeakReference<CameraChangeDispatcher>(dispatcher);
        }

        public void handleMessage(@NonNull Message msg) {
            CameraChangeDispatcher dispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (dispatcher != null) {
                switch (msg.what) {
                    case 0: {
                        dispatcher.executeOnCameraMoveStarted();
                        break;
                    }
                    case 1: {
                        dispatcher.executeOnCameraMove();
                        break;
                    }
                    case 2: {
                        dispatcher.executeOnCameraMoveCancelled();
                        break;
                    }
                    case 3: {
                        dispatcher.executeOnCameraIdle();
                    }
                }
            }
        }

        void scheduleMessage(int change) {
            CameraChangeDispatcher dispatcher = (CameraChangeDispatcher)this.dispatcherWeakReference.get();
            if (dispatcher != null) {
                if (change == 0) {
                    boolean shouldReturn = !dispatcher.idle && (this.hasMessages(3) || this.hasMessages(2));
                    this.removeMessages(3);
                    this.removeMessages(2);
                    if (shouldReturn) {
                        return;
                    }
                }
                Message message = new Message();
                message.what = change;
                this.sendMessage(message);
            }
        }
    }
}

