/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.MapHeroMapOptions;
import org.maphero.android.maps.MapView;
import org.maphero.android.maps.OnMapReadyCallback;
import org.maphero.android.utils.MapFragmentUtils;

public final class MapFragment
extends Fragment
implements OnMapReadyCallback {
    private final List<OnMapReadyCallback> mapReadyCallbackList = new ArrayList<OnMapReadyCallback>();
    private OnMapViewReadyCallback mapViewReadyCallback;
    private MapHeroMap mapHeroMap;
    private MapView map;

    public static MapFragment newInstance() {
        return new MapFragment();
    }

    @NonNull
    public static MapFragment newInstance(@Nullable MapHeroMapOptions mapHeroMapOptions) {
        MapFragment mapFragment = new MapFragment();
        mapFragment.setArguments(MapFragmentUtils.createFragmentArgs(mapHeroMapOptions));
        return mapFragment;
    }

    public void onInflate(@NonNull Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        this.setArguments(MapFragmentUtils.createFragmentArgs(MapHeroMapOptions.createFromAttributes(context, attrs)));
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnMapViewReadyCallback) {
            this.mapViewReadyCallback = (OnMapViewReadyCallback)context;
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Context context = inflater.getContext();
        this.map = new MapView(context, MapFragmentUtils.resolveArgs(context, this.getArguments()));
        return this.map;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.map.onCreate(savedInstanceState);
        this.map.getMapAsync(this);
        if (this.mapViewReadyCallback != null) {
            this.mapViewReadyCallback.onMapViewReady(this.map);
        }
    }

    @Override
    public void onMapReady(@NonNull MapHeroMap mapHeroMap) {
        this.mapHeroMap = mapHeroMap;
        for (OnMapReadyCallback onMapReadyCallback : this.mapReadyCallbackList) {
            onMapReadyCallback.onMapReady(mapHeroMap);
        }
    }

    public void onStart() {
        super.onStart();
        this.map.onStart();
    }

    public void onResume() {
        super.onResume();
        this.map.onResume();
    }

    public void onPause() {
        super.onPause();
        this.map.onPause();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.map != null && !this.map.isDestroyed()) {
            this.map.onSaveInstanceState(outState);
        }
    }

    public void onStop() {
        super.onStop();
        this.map.onStop();
    }

    public void onLowMemory() {
        super.onLowMemory();
        if (this.map != null && !this.map.isDestroyed()) {
            this.map.onLowMemory();
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.map.onDestroy();
    }

    public void onDestroy() {
        super.onDestroy();
        this.mapReadyCallbackList.clear();
    }

    public void getMapAsync(@NonNull OnMapReadyCallback onMapReadyCallback) {
        if (this.mapHeroMap == null) {
            this.mapReadyCallbackList.add(onMapReadyCallback);
        } else {
            onMapReadyCallback.onMapReady(this.mapHeroMap);
        }
    }

    public static interface OnMapViewReadyCallback {
        public void onMapViewReady(MapView var1);
    }
}

