/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.annotations.BaseMarkerOptions;
import org.maphero.android.annotations.Icon;
import org.maphero.android.annotations.Marker;
import org.maphero.android.maps.IconManager;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.Markers;
import org.maphero.android.maps.NativeMap;

class MarkerContainer
implements Markers {
    private final NativeMap nativeMapView;
    private final LongSparseArray<Annotation> annotations;
    private final IconManager iconManager;

    MarkerContainer(NativeMap nativeMapView, LongSparseArray<Annotation> annotations, IconManager iconManager) {
        this.nativeMapView = nativeMapView;
        this.annotations = annotations;
        this.iconManager = iconManager;
    }

    @Override
    public Marker addBy(@NonNull BaseMarkerOptions markerOptions, @NonNull MapHeroMap mapHeroMap) {
        Marker marker = this.prepareMarker(markerOptions);
        long id2 = this.nativeMapView != null ? this.nativeMapView.addMarker(marker) : 0L;
        marker.setMapHeroMap(mapHeroMap);
        marker.setId(id2);
        this.annotations.put(id2, (Object)marker);
        return marker;
    }

    @Override
    @NonNull
    public List<Marker> addBy(@NonNull List<? extends BaseMarkerOptions> markerOptionsList, @NonNull MapHeroMap mapHeroMap) {
        int count = markerOptionsList.size();
        ArrayList<Marker> markers = new ArrayList<Marker>(count);
        if (this.nativeMapView != null && count > 0) {
            for (int i = 0; i < count; ++i) {
                BaseMarkerOptions markerOptions = markerOptionsList.get(i);
                Marker marker = this.prepareMarker(markerOptions);
                markers.add(marker);
            }
            if (markers.size() > 0) {
                long[] ids = this.nativeMapView.addMarkers(markers);
                for (int i = 0; i < ids.length; ++i) {
                    Marker createdMarker = (Marker)markers.get(i);
                    createdMarker.setMapHeroMap(mapHeroMap);
                    createdMarker.setId(ids[i]);
                    this.annotations.put(ids[i], (Object)createdMarker);
                }
            }
        }
        return markers;
    }

    @Override
    public void update(@NonNull Marker updatedMarker, @NonNull MapHeroMap mapHeroMap) {
        this.ensureIconLoaded(updatedMarker, mapHeroMap);
        this.nativeMapView.updateMarker(updatedMarker);
        this.annotations.setValueAt(this.annotations.indexOfKey(updatedMarker.getId()), (Object)updatedMarker);
    }

    @Override
    @NonNull
    public List<Marker> obtainAll() {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Marker)) continue;
            markers.add((Marker)annotation);
        }
        return markers;
    }

    @Override
    @NonNull
    public List<Marker> obtainAllIn(@NonNull RectF rectangle) {
        RectF rect = this.nativeMapView.getDensityDependantRectangle(rectangle);
        long[] ids = this.nativeMapView.queryPointAnnotations(rect);
        ArrayList<Long> idsList = new ArrayList<Long>(ids.length);
        for (long id2 : ids) {
            idsList.add(id2);
        }
        ArrayList<Marker> annotations = new ArrayList<Marker>(ids.length);
        List<Annotation> annotationList = this.obtainAnnotations();
        int count = annotationList.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = annotationList.get(i);
            if (!(annotation instanceof Marker) || !idsList.contains(annotation.getId())) continue;
            annotations.add((Marker)annotation);
        }
        return new ArrayList<Marker>(annotations);
    }

    @Override
    public void reload() {
        this.iconManager.reloadIcons();
        int count = this.annotations.size();
        for (int i = 0; i < count; ++i) {
            Annotation annotation = (Annotation)this.annotations.get((long)i);
            if (!(annotation instanceof Marker)) continue;
            Marker marker = (Marker)annotation;
            this.nativeMapView.removeAnnotation(annotation.getId());
            long newId = this.nativeMapView.addMarker(marker);
            marker.setId(newId);
        }
    }

    private Marker prepareMarker(BaseMarkerOptions markerOptions) {
        Object marker = markerOptions.getMarker();
        Icon icon = this.iconManager.loadIconForMarker((Marker)marker);
        ((Marker)marker).setTopOffsetPixels(this.iconManager.getTopOffsetPixelsForIcon(icon));
        return marker;
    }

    private void ensureIconLoaded(Marker marker, @NonNull MapHeroMap mapHeroMap) {
        this.iconManager.ensureIconLoaded(marker, mapHeroMap);
    }

    @NonNull
    private List<Annotation> obtainAnnotations() {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            annotations.add((Annotation)this.annotations.get(this.annotations.keyAt(i)));
        }
        return annotations;
    }
}

