/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.annotations.Polygon;
import org.maphero.android.annotations.PolygonOptions;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.NativeMap;
import org.maphero.android.maps.Polygons;

class PolygonContainer
implements Polygons {
    private final NativeMap nativeMap;
    private final LongSparseArray<Annotation> annotations;

    PolygonContainer(NativeMap nativeMap, LongSparseArray<Annotation> annotations) {
        this.nativeMap = nativeMap;
        this.annotations = annotations;
    }

    @Override
    public Polygon addBy(@NonNull PolygonOptions polygonOptions, @NonNull MapHeroMap mapHeroMap) {
        Polygon polygon = polygonOptions.getPolygon();
        if (!polygon.getPoints().isEmpty()) {
            long id2 = this.nativeMap != null ? this.nativeMap.addPolygon(polygon) : 0L;
            polygon.setId(id2);
            polygon.setMapHeroMap(mapHeroMap);
            this.annotations.put(id2, (Object)polygon);
        }
        return polygon;
    }

    @Override
    @NonNull
    public List<Polygon> addBy(@NonNull List<PolygonOptions> polygonOptionsList, @NonNull MapHeroMap mapHeroMap) {
        int count = polygonOptionsList.size();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>(count);
        if (this.nativeMap != null && count > 0) {
            Polygon polygon;
            for (PolygonOptions polygonOptions : polygonOptionsList) {
                polygon = polygonOptions.getPolygon();
                if (polygon.getPoints().isEmpty()) continue;
                polygons.add(polygon);
            }
            long[] ids = this.nativeMap.addPolygons(polygons);
            for (int i = 0; i < ids.length; ++i) {
                polygon = (Polygon)polygons.get(i);
                polygon.setMapHeroMap(mapHeroMap);
                polygon.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polygon);
            }
        }
        return polygons;
    }

    @Override
    public void update(@NonNull Polygon polygon) {
        this.nativeMap.updatePolygon(polygon);
        this.annotations.setValueAt(this.annotations.indexOfKey(polygon.getId()), (Object)polygon);
    }

    @Override
    @NonNull
    public List<Polygon> obtainAll() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polygon)) continue;
            polygons.add((Polygon)annotation);
        }
        return polygons;
    }
}

