/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import androidx.annotation.NonNull;
import androidx.collection.LongSparseArray;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.Annotation;
import org.maphero.android.annotations.Polyline;
import org.maphero.android.annotations.PolylineOptions;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.NativeMap;
import org.maphero.android.maps.Polylines;

class PolylineContainer
implements Polylines {
    private final NativeMap nativeMap;
    private final LongSparseArray<Annotation> annotations;

    PolylineContainer(NativeMap nativeMap, LongSparseArray<Annotation> annotations) {
        this.nativeMap = nativeMap;
        this.annotations = annotations;
    }

    @Override
    public Polyline addBy(@NonNull PolylineOptions polylineOptions, @NonNull MapHeroMap mapHeroMap) {
        Polyline polyline = polylineOptions.getPolyline();
        if (!polyline.getPoints().isEmpty()) {
            long id2 = this.nativeMap != null ? this.nativeMap.addPolyline(polyline) : 0L;
            polyline.setMapHeroMap(mapHeroMap);
            polyline.setId(id2);
            this.annotations.put(id2, (Object)polyline);
        }
        return polyline;
    }

    @Override
    @NonNull
    public List<Polyline> addBy(@NonNull List<PolylineOptions> polylineOptionsList, @NonNull MapHeroMap mapHeroMap) {
        int count = polylineOptionsList.size();
        ArrayList<Polyline> polylines = new ArrayList<Polyline>(count);
        if (this.nativeMap != null && count > 0) {
            for (PolylineOptions options : polylineOptionsList) {
                Polyline polyline = options.getPolyline();
                if (polyline.getPoints().isEmpty()) continue;
                polylines.add(polyline);
            }
            long[] ids = this.nativeMap.addPolylines(polylines);
            for (int i = 0; i < ids.length; ++i) {
                Polyline polylineCreated = (Polyline)polylines.get(i);
                polylineCreated.setMapHeroMap(mapHeroMap);
                polylineCreated.setId(ids[i]);
                this.annotations.put(ids[i], (Object)polylineCreated);
            }
        }
        return polylines;
    }

    @Override
    public void update(@NonNull Polyline polyline) {
        this.nativeMap.updatePolyline(polyline);
        this.annotations.setValueAt(this.annotations.indexOfKey(polyline.getId()), (Object)polyline);
    }

    @Override
    @NonNull
    public List<Polyline> obtainAll() {
        ArrayList<Polyline> polylines = new ArrayList<Polyline>();
        for (int i = 0; i < this.annotations.size(); ++i) {
            Annotation annotation = (Annotation)this.annotations.get(this.annotations.keyAt(i));
            if (!(annotation instanceof Polyline)) continue;
            polylines.add((Polyline)annotation);
        }
        return polylines;
    }
}

