/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer.surfaceview;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.util.Log;
import java.lang.ref.WeakReference;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import javax.microedition.khronos.opengles.GL;
import javax.microedition.khronos.opengles.GL10;
import org.maphero.android.maps.renderer.egl.EGLLogWrapper;
import org.maphero.android.maps.renderer.surfaceview.MapHeroSurfaceView;
import org.maphero.android.maps.renderer.surfaceview.SurfaceViewMapRenderer;

public class MapHeroGLSurfaceView
extends MapHeroSurfaceView {
    protected final WeakReference<MapHeroGLSurfaceView> viewWeakReference = new WeakReference<MapHeroGLSurfaceView>(this);
    private GLSurfaceView.EGLConfigChooser eglConfigChooser;
    private GLSurfaceView.EGLContextFactory eglContextFactory;
    private GLSurfaceView.EGLWindowSurfaceFactory eglWindowSurfaceFactory;
    private boolean preserveEGLContextOnPause;

    public MapHeroGLSurfaceView(Context context) {
        super(context);
    }

    public MapHeroGLSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setPreserveEGLContextOnPause(boolean preserveOnPause) {
        this.preserveEGLContextOnPause = preserveOnPause;
    }

    public boolean getPreserveEGLContextOnPause() {
        return this.preserveEGLContextOnPause;
    }

    @Override
    public void setRenderer(SurfaceViewMapRenderer renderer) {
        if (this.eglConfigChooser == null) {
            throw new IllegalStateException("No eglConfigChooser provided");
        }
        if (this.eglContextFactory == null) {
            throw new IllegalStateException("No eglContextFactory provided");
        }
        if (this.eglWindowSurfaceFactory == null) {
            throw new IllegalStateException("No eglWindowSurfaceFactory provided");
        }
        super.setRenderer(renderer);
    }

    public void setEGLContextFactory(GLSurfaceView.EGLContextFactory factory) {
        this.checkRenderThreadState();
        this.eglContextFactory = factory;
    }

    public void setEGLWindowSurfaceFactory(GLSurfaceView.EGLWindowSurfaceFactory factory) {
        this.checkRenderThreadState();
        this.eglWindowSurfaceFactory = factory;
    }

    public void setEGLConfigChooser(GLSurfaceView.EGLConfigChooser configChooser) {
        this.checkRenderThreadState();
        this.eglConfigChooser = configChooser;
    }

    @Override
    protected void createRenderThread() {
        this.renderThread = new GLThread(this.viewWeakReference);
    }

    static class GLThread
    extends MapHeroSurfaceView.RenderThread {
        private boolean surfaceIsBad;
        private boolean haveEglContext;
        private boolean haveEglSurface;
        private boolean finishedCreatingEglSurface;
        private boolean shouldReleaseEglContext;
        private EglHelper eglHelper;
        protected WeakReference<MapHeroGLSurfaceView> mSurfaceViewWeakRef;

        GLThread(WeakReference<MapHeroGLSurfaceView> surfaceViewWeakRef) {
            this.mSurfaceViewWeakRef = surfaceViewWeakRef;
        }

        private void stopEglSurfaceLocked() {
            if (this.haveEglSurface) {
                this.haveEglSurface = false;
                this.eglHelper.destroySurface();
            }
        }

        private void stopEglContextLocked() {
            if (this.haveEglContext) {
                this.eglHelper.finish();
                this.haveEglContext = false;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void guardedRun() throws InterruptedException {
            this.eglHelper = new EglHelper(this.mSurfaceViewWeakRef);
            this.haveEglContext = false;
            this.haveEglSurface = false;
            this.wantRenderNotification = false;
            try {
                gl = null;
                createEglContext = false;
                createEglSurface = false;
                createGlInterface = false;
                lostEglContext = false;
                sizeChanged = false;
                wantRenderNotification = false;
                doRenderNotification = false;
                askedToReleaseEglContext = false;
                w = 0;
                h = 0;
                event = null;
                finishDrawingRunnable = null;
lbl19:
                // 5 sources

                while (true) {
                    var14_14 = MapHeroSurfaceView.renderThreadManager;
                    synchronized (var14_14) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            if (!this.shouldExit) ** break block49
                            // MONITOREXIT @DISABLED, blocks:[0, 25, 26, 13] lbl24 : MonitorExitStatement: MONITOREXIT : var14_14
                            var15_16 = MapHeroSurfaceView.renderThreadManager;
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Throwable var23_21) {
                var24_22 = MapHeroSurfaceView.renderThreadManager;
                synchronized (var24_22) {
                    this.stopEglSurfaceLocked();
                    this.stopEglContextLocked();
                    throw var23_21;
                }
            }
            synchronized (var15_16) {
                this.stopEglSurfaceLocked();
                this.stopEglContextLocked();
                return;
            }
            {
                block51: {
                    block50: {
                        if (this.eventQueue.isEmpty()) break block50;
                        event = (Runnable)this.eventQueue.remove(0);
                        ** GOTO lbl126
                    }
                    pausing = false;
                    if (this.paused != this.requestPaused) {
                        pausing = this.requestPaused;
                        this.paused = this.requestPaused;
                        MapHeroSurfaceView.renderThreadManager.notifyAll();
                    }
                    if (this.shouldReleaseEglContext) {
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        this.shouldReleaseEglContext = false;
                        askedToReleaseEglContext = true;
                    }
                    if (lostEglContext) {
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        lostEglContext = false;
                    }
                    if (pausing && this.haveEglSurface) {
                        this.stopEglSurfaceLocked();
                    }
                    if (pausing && this.haveEglContext) {
                        view = (MapHeroGLSurfaceView)this.mSurfaceViewWeakRef.get();
                        v0 = preserveEglContextOnPause = view != null && view.preserveEGLContextOnPause != false;
                        if (!preserveEglContextOnPause) {
                            this.stopEglContextLocked();
                        }
                    }
                    if (!this.hasSurface && !this.waitingForSurface) {
                        if (this.haveEglSurface) {
                            this.stopEglSurfaceLocked();
                        }
                        this.waitingForSurface = true;
                        this.surfaceIsBad = false;
                        MapHeroSurfaceView.renderThreadManager.notifyAll();
                    }
                    if (this.hasSurface && this.waitingForSurface) {
                        this.waitingForSurface = false;
                        MapHeroSurfaceView.renderThreadManager.notifyAll();
                    }
                    if (doRenderNotification) {
                        this.wantRenderNotification = false;
                        doRenderNotification = false;
                        this.renderComplete = true;
                        MapHeroSurfaceView.renderThreadManager.notifyAll();
                    }
                    if (this.finishDrawingRunnable != null) {
                        finishDrawingRunnable = this.finishDrawingRunnable;
                        this.finishDrawingRunnable = null;
                    }
                    if (!this.readyToDraw()) ** GOTO lbl118
                    if (this.haveEglContext) ** GOTO lbl100
                    if (!askedToReleaseEglContext) break block51;
                    askedToReleaseEglContext = false;
                    ** GOTO lbl100
                }
                try {
                    this.eglHelper.start();
                }
                catch (RuntimeException exception) {
                    MapHeroSurfaceView.renderThreadManager.notifyAll();
                    // MONITOREXIT @DISABLED, blocks:[23, 13] lbl90 : MonitorExitStatement: MONITOREXIT : var14_14
                    var17_20 = MapHeroSurfaceView.renderThreadManager;
                    synchronized (var17_20) {
                        this.stopEglSurfaceLocked();
                        this.stopEglContextLocked();
                        return;
                    }
                }
                {
                    block55: {
                        block56: {
                            block54: {
                                block53: {
                                    block52: {
                                        this.haveEglContext = true;
                                        createEglContext = true;
                                        MapHeroSurfaceView.renderThreadManager.notifyAll();
lbl100:
                                        // 3 sources

                                        if (this.haveEglContext && !this.haveEglSurface) {
                                            this.haveEglSurface = true;
                                            createEglSurface = true;
                                            createGlInterface = true;
                                            sizeChanged = true;
                                        }
                                        if (!this.haveEglSurface) break block52;
                                        if (this.sizeChanged) {
                                            sizeChanged = true;
                                            w = this.width;
                                            h = this.height;
                                            this.wantRenderNotification = true;
                                            createEglSurface = true;
                                            this.sizeChanged = false;
                                        }
                                        this.requestRender = false;
                                        MapHeroSurfaceView.renderThreadManager.notifyAll();
                                        if (this.wantRenderNotification) {
                                            wantRenderNotification = true;
                                        }
                                        break block53;
lbl118:
                                        // 1 sources

                                        if (finishDrawingRunnable != null) {
                                            Log.w((String)"MapHeroSurfaceView", (String)"Warning, !readyToDraw() but waiting for draw finished! Early reporting draw finished.");
                                            finishDrawingRunnable.run();
                                            finishDrawingRunnable = null;
                                        }
                                    }
                                    MapHeroSurfaceView.renderThreadManager.wait();
                                    ** continue;
                                }
                                // MONITOREXIT @DISABLED, blocks:[6, 13] lbl126 : MonitorExitStatement: MONITOREXIT : var14_14
                                if (event == null) break block54;
                                event.run();
                                event = null;
                                ** GOTO lbl19
                            }
                            if (!createEglSurface) break block55;
                            if (!this.eglHelper.createSurface()) break block56;
                            var14_14 = MapHeroSurfaceView.renderThreadManager;
                            synchronized (var14_14) {
                                this.finishedCreatingEglSurface = true;
                                MapHeroSurfaceView.renderThreadManager.notifyAll();
                            }
                            createEglSurface = false;
                            break block55;
                        }
                        var14_14 = MapHeroSurfaceView.renderThreadManager;
                        synchronized (var14_14) {
                            this.finishedCreatingEglSurface = true;
                            this.surfaceIsBad = true;
                            MapHeroSurfaceView.renderThreadManager.notifyAll();
                            ** GOTO lbl19
                        }
                    }
                    if (createGlInterface) {
                        gl = (GL10)this.eglHelper.createGL();
                        createGlInterface = false;
                    }
                    if (createEglContext) {
                        view = (MapHeroSurfaceView)this.mSurfaceViewWeakRef.get();
                        if (view != null) {
                            view.renderer.onSurfaceCreated(null);
                        }
                        createEglContext = false;
                    }
                    if (sizeChanged) {
                        view = (MapHeroSurfaceView)this.mSurfaceViewWeakRef.get();
                        if (view != null) {
                            view.renderer.onSurfaceChanged(w, h);
                        }
                        sizeChanged = false;
                    }
                    if ((view = (MapHeroSurfaceView)this.mSurfaceViewWeakRef.get()) != null) {
                        view.renderer.onDrawFrame();
                        if (finishDrawingRunnable != null) {
                            finishDrawingRunnable.run();
                            finishDrawingRunnable = null;
                        }
                    }
                    swapError = this.eglHelper.swap();
                    switch (swapError) {
                        case 12288: {
                            break;
                        }
                        case 12302: {
                            lostEglContext = true;
                            break;
                        }
                        default: {
                            EglHelper.logEglErrorAsWarning("MapHeroSurfaceView", "eglSwapBuffers", swapError);
                            var16_17 = MapHeroSurfaceView.renderThreadManager;
                            synchronized (var16_17) {
                                this.surfaceIsBad = true;
                                MapHeroSurfaceView.renderThreadManager.notifyAll();
                                break;
                            }
                        }
                    }
                    if (!wantRenderNotification) ** GOTO lbl19
                    doRenderNotification = true;
                    wantRenderNotification = false;
                    ** continue;
                }
            }
        }

        @Override
        protected boolean readyToDraw() {
            return super.readyToDraw() && !this.surfaceIsBad;
        }

        @Override
        public boolean ableToDraw() {
            return this.haveEglContext && this.haveEglSurface && this.readyToDraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void surfaceCreated() {
            MapHeroSurfaceView.RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.hasSurface = true;
                this.finishedCreatingEglSurface = false;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (this.waitingForSurface && !this.finishedCreatingEglSurface && !this.exited) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        public void requestReleaseEglContextLocked() {
            this.shouldReleaseEglContext = true;
            MapHeroSurfaceView.renderThreadManager.notifyAll();
        }
    }

    private static class EglHelper {
        private WeakReference<MapHeroGLSurfaceView> mGLSurfaceViewWeakRef;
        EGL10 mEgl;
        EGLDisplay mEglDisplay;
        EGLSurface mEglSurface;
        EGLConfig mEglConfig;
        EGLContext mEglContext;

        private EglHelper(WeakReference<MapHeroGLSurfaceView> glSurfaceViewWeakRef) {
            this.mGLSurfaceViewWeakRef = glSurfaceViewWeakRef;
        }

        public void start() {
            try {
                this.mEgl = (EGL10)EGLContext.getEGL();
                this.mEglDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
                if (this.mEglDisplay == EGL10.EGL_NO_DISPLAY) {
                    Log.e((String)"MapHeroSurfaceView", (String)"eglGetDisplay failed");
                    return;
                }
                int[] version = new int[2];
                if (!this.mEgl.eglInitialize(this.mEglDisplay, version)) {
                    Log.e((String)"MapHeroSurfaceView", (String)"eglInitialize failed");
                    return;
                }
                MapHeroGLSurfaceView view = (MapHeroGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (view == null) {
                    this.mEglConfig = null;
                    this.mEglContext = null;
                } else {
                    this.mEglConfig = view.eglConfigChooser.chooseConfig(this.mEgl, this.mEglDisplay);
                    if (this.mEglConfig == null) {
                        Log.e((String)"MapHeroSurfaceView", (String)"failed to select an EGL configuration");
                        return;
                    }
                    this.mEglContext = view.eglContextFactory.createContext(this.mEgl, this.mEglDisplay, this.mEglConfig);
                }
                if (this.mEglContext == null || this.mEglContext == EGL10.EGL_NO_CONTEXT) {
                    this.mEglContext = null;
                    Log.e((String)"MapHeroSurfaceView", (String)"createContext failed");
                    return;
                }
            }
            catch (Exception exception) {
                Log.e((String)"MapHeroSurfaceView", (String)"createContext failed: ", (Throwable)exception);
            }
            this.mEglSurface = null;
        }

        boolean createSurface() {
            if (this.mEgl == null) {
                Log.e((String)"MapHeroSurfaceView", (String)"egl not initialized");
                return false;
            }
            if (this.mEglDisplay == null) {
                Log.e((String)"MapHeroSurfaceView", (String)"eglDisplay not initialized");
                return false;
            }
            if (this.mEglConfig == null) {
                Log.e((String)"MapHeroSurfaceView", (String)"mEglConfig not initialized");
                return false;
            }
            this.destroySurfaceImp();
            MapHeroGLSurfaceView view = (MapHeroGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
            this.mEglSurface = view != null ? view.eglWindowSurfaceFactory.createWindowSurface(this.mEgl, this.mEglDisplay, this.mEglConfig, (Object)view.getHolder()) : null;
            if (this.mEglSurface == null || this.mEglSurface == EGL10.EGL_NO_SURFACE) {
                int error = this.mEgl.eglGetError();
                if (error == 12299) {
                    Log.e((String)"MapHeroSurfaceView", (String)"createWindowSurface returned EGL_BAD_NATIVE_WINDOW.");
                }
                return false;
            }
            if (!this.mEgl.eglMakeCurrent(this.mEglDisplay, this.mEglSurface, this.mEglSurface, this.mEglContext)) {
                EglHelper.logEglErrorAsWarning("MapHeroSurfaceView", "eglMakeCurrent", this.mEgl.eglGetError());
                return false;
            }
            return true;
        }

        GL createGL() {
            return this.mEglContext.getGL();
        }

        public int swap() {
            if (!this.mEgl.eglSwapBuffers(this.mEglDisplay, this.mEglSurface)) {
                return this.mEgl.eglGetError();
            }
            return 12288;
        }

        void destroySurface() {
            this.destroySurfaceImp();
        }

        private void destroySurfaceImp() {
            if (this.mEglSurface != null && this.mEglSurface != EGL10.EGL_NO_SURFACE) {
                this.mEgl.eglMakeCurrent(this.mEglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
                MapHeroGLSurfaceView view = (MapHeroGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (view != null) {
                    view.eglWindowSurfaceFactory.destroySurface(this.mEgl, this.mEglDisplay, this.mEglSurface);
                }
                this.mEglSurface = null;
            }
        }

        public void finish() {
            if (this.mEglContext != null) {
                MapHeroGLSurfaceView view = (MapHeroGLSurfaceView)((Object)this.mGLSurfaceViewWeakRef.get());
                if (view != null) {
                    view.eglContextFactory.destroyContext(this.mEgl, this.mEglDisplay, this.mEglContext);
                }
                this.mEglContext = null;
            }
            if (this.mEglDisplay != null) {
                this.mEgl.eglTerminate(this.mEglDisplay);
                this.mEglDisplay = null;
            }
        }

        static void logEglErrorAsWarning(String tag, String function, int error) {
            Log.w((String)tag, (String)EglHelper.formatEglError(function, error));
        }

        static String formatEglError(String function, int error) {
            return function + " failed: " + EGLLogWrapper.getErrorString(error);
        }
    }
}

