/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps.renderer.surfaceview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import org.maphero.android.maps.renderer.surfaceview.SurfaceViewMapRenderer;

public abstract class MapHeroSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2 {
    protected static final String TAG = "MapHeroSurfaceView";
    protected static final RenderThreadManager renderThreadManager = new RenderThreadManager();
    protected SurfaceViewMapRenderer renderer;
    protected RenderThread renderThread;
    protected OnSurfaceViewDetachedListener detachedListener;
    protected boolean detached;
    public static final int RENDERMODE_WHEN_DIRTY = 0;
    public static final int RENDERMODE_CONTINUOUSLY = 1;

    public MapHeroSurfaceView(Context context) {
        super(context);
        this.init();
    }

    public MapHeroSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        SurfaceHolder holder = this.getHolder();
        holder.setFormat(-2);
        holder.addCallback((SurfaceHolder.Callback)this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.renderThread != null) {
                this.renderThread.requestExitAndWait();
            }
        }
        finally {
            super.finalize();
        }
    }

    public void setDetachedListener(@NonNull OnSurfaceViewDetachedListener detachedListener) {
        if (this.detachedListener != null) {
            throw new IllegalArgumentException("Detached from window listener has been already set.");
        }
        this.detachedListener = detachedListener;
    }

    public void setRenderer(SurfaceViewMapRenderer renderer) {
        this.checkRenderThreadState();
        this.renderer = renderer;
        this.createRenderThread();
        this.renderThread.start();
    }

    public void setRenderMode(int renderMode) {
        this.renderThread.setRenderMode(renderMode);
    }

    public int getRenderMode() {
        return this.renderThread.getRenderMode();
    }

    public void requestRender() {
        this.renderThread.requestRender();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.renderThread.surfaceCreated();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.renderThread.surfaceDestroyed();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        this.renderThread.onWindowResize(w, h);
    }

    public void surfaceRedrawNeededAsync(SurfaceHolder holder, Runnable finishDrawing) {
        if (this.renderThread != null) {
            this.renderThread.requestRenderAndNotify(finishDrawing);
        }
    }

    @Deprecated
    public void surfaceRedrawNeeded(SurfaceHolder holder) {
    }

    public void onPause() {
        this.renderThread.onPause();
    }

    public void onResume() {
        this.renderThread.onResume();
    }

    public void queueEvent(Runnable r) {
        this.renderThread.queueEvent(r);
    }

    public void waitForEmpty() {
        this.renderThread.waitForEmpty();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.detached && this.renderer != null) {
            int renderMode = 1;
            if (this.renderThread != null) {
                renderMode = this.renderThread.getRenderMode();
            }
            this.createRenderThread();
            if (renderMode != 1) {
                this.renderThread.setRenderMode(renderMode);
            }
            this.renderThread.start();
        }
        this.detached = false;
    }

    protected void onDetachedFromWindow() {
        if (this.detachedListener != null) {
            this.detachedListener.onSurfaceViewDetached();
        }
        if (this.renderThread != null) {
            this.renderThread.requestExitAndWait();
        }
        this.detached = true;
        super.onDetachedFromWindow();
    }

    protected abstract void createRenderThread();

    protected void checkRenderThreadState() {
        if (this.renderThread != null) {
            throw new IllegalStateException("setRenderer has already been called for this instance.");
        }
    }

    static abstract class RenderThread
    extends Thread {
        protected boolean shouldExit;
        protected boolean exited;
        protected boolean requestPaused;
        protected boolean paused;
        protected boolean hasSurface;
        protected boolean waitingForSurface;
        protected int width = 0;
        protected int height = 0;
        protected int renderMode = 1;
        protected boolean requestRender = true;
        protected boolean wantRenderNotification = false;
        protected boolean renderComplete;
        protected ArrayList<Runnable> eventQueue = new ArrayList();
        protected boolean sizeChanged = true;
        protected Runnable finishDrawingRunnable = null;

        RenderThread() {
        }

        @Override
        public void run() {
            this.setName("RenderThread " + this.getId());
            try {
                this.guardedRun();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                renderThreadManager.threadExiting(this);
            }
        }

        protected abstract void guardedRun() throws InterruptedException;

        protected boolean readyToDraw() {
            return !this.paused && this.hasSurface && this.width > 0 && this.height > 0 && (this.requestRender || this.renderMode == 1);
        }

        public boolean ableToDraw() {
            return this.readyToDraw();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRenderMode(int renderMode) {
            if (0 > renderMode || renderMode > 1) {
                throw new IllegalArgumentException("renderMode");
            }
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.renderMode = renderMode;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getRenderMode() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                return this.renderMode;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRender() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.requestRender = true;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestRenderAndNotify(Runnable finishDrawing) {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                if (Thread.currentThread() == this) {
                    return;
                }
                this.wantRenderNotification = true;
                this.requestRender = true;
                this.renderComplete = false;
                this.finishDrawingRunnable = finishDrawing;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceCreated() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.hasSurface = true;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited && this.waitingForSurface) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void surfaceDestroyed() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.hasSurface = false;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited && !this.waitingForSurface) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPause() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.requestPaused = true;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited && !this.paused) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResume() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.requestPaused = false;
                this.requestRender = true;
                this.renderComplete = false;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited && this.paused && !this.renderComplete) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onWindowResize(int w, int h) {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.width = w;
                this.height = h;
                this.sizeChanged = true;
                this.requestRender = true;
                this.renderComplete = false;
                if (Thread.currentThread() == this) {
                    return;
                }
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited && !this.paused && !this.renderComplete && this.ableToDraw()) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestExitAndWait() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.shouldExit = true;
                MapHeroSurfaceView.renderThreadManager.notifyAll();
                while (!this.exited) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueEvent(@NonNull Runnable r) {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                this.eventQueue.add(r);
                MapHeroSurfaceView.renderThreadManager.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEmpty() {
            RenderThreadManager renderThreadManager = MapHeroSurfaceView.renderThreadManager;
            synchronized (renderThreadManager) {
                while (!this.eventQueue.isEmpty()) {
                    try {
                        MapHeroSurfaceView.renderThreadManager.wait();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    public static interface OnSurfaceViewDetachedListener {
        public void onSurfaceViewDetached();
    }

    protected static class RenderThreadManager {
        protected RenderThreadManager() {
        }

        synchronized void threadExiting(RenderThread thread) {
            thread.exited = true;
            this.notifyAll();
        }
    }
}

