/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.module.http;

import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Optional;
import javax.net.ssl.SSLException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.maphero.android.MapHero;
import org.maphero.android.constants.MapHeroConstants;
import org.maphero.android.http.HttpIdentifier;
import org.maphero.android.http.HttpLogger;
import org.maphero.android.http.HttpRequest;
import org.maphero.android.http.HttpRequestUrl;
import org.maphero.android.http.HttpResponder;
import org.maphero.android.module.http.HttpRequestUtil;

public class HttpRequestImpl
implements HttpRequest {
    private static final String userAgentString = HttpRequestUtil.toHumanReadableAscii(String.format("%s %s (%s) Android/%s (%s)", HttpIdentifier.getIdentifier(), "MapHero Native/11.3.0", "7142dc88", Build.VERSION.SDK_INT, Build.SUPPORTED_ABIS[0]));
    @VisibleForTesting
    static final OkHttpClient DEFAULT_CLIENT;
    @VisibleForTesting
    static OkHttpClient client;
    private Call call;

    @Override
    public void executeRequest(HttpResponder httpRequest, long nativePtr, @NonNull String resourceUrl, @NonNull String etag, @NonNull String modified, boolean offlineUsage) {
        OkHttpCallback callback = new OkHttpCallback(httpRequest);
        try {
            HttpUrl httpUrl = HttpUrl.parse((String)resourceUrl);
            if (httpUrl == null) {
                HttpLogger.log(6, String.format("[HTTP] Unable to parse resourceUrl %s", resourceUrl));
                return;
            }
            String host = httpUrl.host().toLowerCase(MapHeroConstants.MAPHERO_LOCALE);
            resourceUrl = HttpRequestUrl.buildResourceUrl(host, resourceUrl, httpUrl.querySize(), offlineUsage);
            Request.Builder builder = new Request.Builder().url(resourceUrl).tag((Object)resourceUrl.toLowerCase(MapHeroConstants.MAPHERO_LOCALE)).addHeader("map-token", Optional.ofNullable(MapHero.getApiKey()).orElse("")).addHeader("User-Agent", userAgentString);
            if (etag.length() > 0) {
                builder.addHeader("If-None-Match", etag);
            } else if (modified.length() > 0) {
                builder.addHeader("If-Modified-Since", modified);
            }
            Request request = builder.build();
            this.call = client.newCall(request);
            this.call.enqueue((Callback)callback);
        }
        catch (Exception exception) {
            callback.handleFailure(this.call, exception);
        }
    }

    @Override
    public void cancelRequest() {
        if (this.call != null) {
            HttpLogger.log(3, String.format("[HTTP] This request was cancelled (%s). This is expected for tiles that were being prefetched but are no longer needed for the map to render.", this.call.request().url()));
            this.call.cancel();
        }
    }

    public static void enablePrintRequestUrlOnFailure(boolean enabled) {
        HttpLogger.logRequestUrl = enabled;
    }

    public static void enableLog(boolean enabled) {
        HttpLogger.logEnabled = enabled;
    }

    public static void setOkHttpClient(@Nullable OkHttpClient okHttpClient) {
        client = okHttpClient != null ? okHttpClient : DEFAULT_CLIENT;
    }

    @NonNull
    private static Dispatcher getDispatcher() {
        Dispatcher dispatcher = new Dispatcher();
        if (Build.VERSION.SDK_INT >= 21) {
            dispatcher.setMaxRequestsPerHost(20);
        } else {
            dispatcher.setMaxRequestsPerHost(10);
        }
        return dispatcher;
    }

    static {
        client = DEFAULT_CLIENT = new OkHttpClient.Builder().dispatcher(HttpRequestImpl.getDispatcher()).build();
    }

    private static class OkHttpCallback
    implements Callback {
        private HttpResponder httpRequest;

        OkHttpCallback(HttpResponder httpRequest) {
            this.httpRequest = httpRequest;
        }

        public void onFailure(@NonNull Call call, @NonNull IOException e) {
            this.handleFailure(call, e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(@NonNull Call call, @NonNull Response response) {
            byte[] body;
            if (response.isSuccessful()) {
                HttpLogger.log(2, String.format("[HTTP] Request was successful (code = %s).", response.code()));
            } else {
                String message = !TextUtils.isEmpty((CharSequence)response.message()) ? response.message() : "No additional information";
                HttpLogger.log(3, String.format("[HTTP] Request with response = %s: %s", response.code(), message));
            }
            ResponseBody responseBody = response.body();
            if (responseBody == null) {
                HttpLogger.log(6, "[HTTP] Received empty response body");
                return;
            }
            try {
                body = responseBody.bytes();
            }
            catch (IOException ioException) {
                this.onFailure(call, ioException);
                return;
            }
            finally {
                response.close();
            }
            this.httpRequest.onResponse(response.code(), response.header("ETag"), response.header("Last-Modified"), response.header("Cache-Control"), response.header("Expires"), response.header("Retry-After"), response.header("x-rate-limit-reset"), body);
        }

        private void handleFailure(@Nullable Call call, Exception e) {
            String errorMessage = e.getMessage() != null ? e.getMessage() : "Error processing the request";
            int type = this.getFailureType(e);
            if (HttpLogger.logEnabled && call != null && call.request() != null) {
                String requestUrl = call.request().url().toString();
                HttpLogger.logFailure(type, errorMessage, requestUrl);
            }
            this.httpRequest.handleFailure(type, errorMessage);
        }

        private int getFailureType(Exception e) {
            if (e instanceof NoRouteToHostException || e instanceof UnknownHostException || e instanceof SocketException || e instanceof ProtocolException || e instanceof SSLException) {
                return 0;
            }
            if (e instanceof InterruptedIOException) {
                return 1;
            }
            return 2;
        }
    }
}

