/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.offline;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.LibraryLoader;
import org.maphero.android.R;
import org.maphero.android.geometry.LatLngBounds;
import org.maphero.android.net.ConnectivityReceiver;
import org.maphero.android.offline.OfflineManager;
import org.maphero.android.offline.OfflineRegion;
import org.maphero.android.offline.OfflineRegionDefinition;
import org.maphero.android.storage.FileSource;
import org.maphero.android.utils.FileUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u001a\b\u0007\u0018\u0000 B2\u00020\u0001:\u0006=>?@ABB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001a\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001b\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019J\u0010\u0010\u001c\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019J \u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u000f\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020)J\u0010\u0010*\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0011\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0007H\u0087 J\u0011\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00020#H\u0087 J\u0011\u0010/\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0083 J\t\u00100\u001a\u00020\rH\u0085 J\u0019\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0083 J!\u0010\u0011\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0013H\u0083 J)\u0010$\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u000f\u001a\u00020)H\u0083 J!\u0010\u0014\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0017H\u0083 J\u0013\u00101\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019H\u0083 J\u0013\u00102\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019H\u0083 J\u0013\u00103\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019H\u0083 J\u0013\u00104\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019H\u0083 J\u001b\u00105\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0019H\u0083 J?\u00106\u001a\u00020\r2\b\u00107\u001a\u0004\u0018\u00010\u00162\b\u00108\u001a\u0004\u0018\u00010(2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\b\u0010;\u001a\u0004\u0018\u00010\u00162\u0006\u0010<\u001a\u00020#H\u0087 R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/maphero/android/offline/OfflineManager;", "", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "nativePtr", "", "fileSource", "Lorg/maphero/android/storage/FileSource;", "handler", "Landroid/os/Handler;", "deleteAmbientDatabase", "", "listOfflineRegions", "callback", "Lorg/maphero/android/offline/OfflineManager$ListOfflineRegionsCallback;", "getOfflineRegion", "regionID", "Lorg/maphero/android/offline/OfflineManager$GetOfflineRegionCallback;", "mergeOfflineRegions", "path", "", "Lorg/maphero/android/offline/OfflineManager$MergeOfflineRegionsCallback;", "resetDatabase", "Lorg/maphero/android/offline/OfflineManager$FileSourceCallback;", "packDatabase", "invalidateAmbientCache", "clearAmbientCache", "setMaximumAmbientCacheSize", "size", "mergeOfflineDatabaseFiles", "file", "Ljava/io/File;", "isTemporaryFile", "", "createOfflineRegion", "definition", "Lorg/maphero/android/offline/OfflineRegionDefinition;", "metadata", "", "Lorg/maphero/android/offline/OfflineManager$CreateOfflineRegionCallback;", "isValidOfflineRegionDefinition", "setOfflineMapboxTileCountLimit", "limit", "runPackDatabaseAutomatically", "autopack", "initialize", "finalize", "nativeResetDatabase", "nativePackDatabase", "nativeInvalidateAmbientCache", "nativeClearAmbientCache", "nativeSetMaximumAmbientCacheSize", "putResourceWithUrl", "url", "data", "modified", "expires", "etag", "mustRevalidate", "ListOfflineRegionsCallback", "GetOfflineRegionCallback", "CreateOfflineRegionCallback", "MergeOfflineRegionsCallback", "FileSourceCallback", "Companion", "MapHeroAndroid_legacyRelease"})
@UiThread
public final class OfflineManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    private final long nativePtr;
    @NotNull
    private final FileSource fileSource;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    @NotNull
    private final Context context;
    @NotNull
    private static final String TAG = "Mbgl - OfflineManager";
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static OfflineManager instance;

    private OfflineManager(Context context) {
        this.context = context.getApplicationContext();
        this.fileSource = FileSource.getInstance(this.context);
        this.initialize(this.fileSource);
        this.deleteAmbientDatabase(this.context);
    }

    private final void deleteAmbientDatabase(Context context) {
        String path = FileSource.getInternalCachePath(context) + File.separator + "mbgl-cache.db";
        FileUtils.deleteFile(path);
    }

    public final void listOfflineRegions(@NotNull ListOfflineRegionsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.fileSource.activate();
        this.listOfflineRegions(this.fileSource, new ListOfflineRegionsCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ ListOfflineRegionsCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onList(OfflineRegion[] offlineRegions) {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> listOfflineRegions.1.onList$lambda$0(this.this$0, this.$callback, offlineRegions));
            }

            public void onError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> listOfflineRegions.1.onError$lambda$1(this.this$0, this.$callback, error));
            }

            private static final void onList$lambda$0(OfflineManager this$0, ListOfflineRegionsCallback $callback, OfflineRegion[] $offlineRegions) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onList($offlineRegions);
            }

            private static final void onError$lambda$1(OfflineManager this$0, ListOfflineRegionsCallback $callback, String $error) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onError($error);
            }
        });
    }

    public final void getOfflineRegion(long regionID, @NotNull GetOfflineRegionCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.fileSource.activate();
        this.getOfflineRegion(this.fileSource, regionID, new GetOfflineRegionCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ GetOfflineRegionCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onRegion(OfflineRegion offlineRegion) {
                Intrinsics.checkNotNullParameter((Object)offlineRegion, (String)"offlineRegion");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> getOfflineRegion.1.onRegion$lambda$0(this.this$0, this.$callback, offlineRegion));
            }

            public void onRegionNotFound() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> getOfflineRegion.1.onRegionNotFound$lambda$1(this.this$0, this.$callback));
            }

            public void onError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> getOfflineRegion.1.onError$lambda$2(this.this$0, this.$callback, error));
            }

            private static final void onRegion$lambda$0(OfflineManager this$0, GetOfflineRegionCallback $callback, OfflineRegion $offlineRegion) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onRegion($offlineRegion);
            }

            private static final void onRegionNotFound$lambda$1(OfflineManager this$0, GetOfflineRegionCallback $callback) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onRegionNotFound();
            }

            private static final void onError$lambda$2(OfflineManager this$0, GetOfflineRegionCallback $callback, String $error) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onError($error);
            }
        });
    }

    public final void mergeOfflineRegions(@NotNull String path, @NotNull MergeOfflineRegionsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        File src = new File(path);
        new Thread(() -> OfflineManager.mergeOfflineRegions$lambda$3(src, this, callback)).start();
    }

    public final void resetDatabase(@Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeResetDatabase(new FileSourceCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ FileSourceCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> resetDatabase.1.onSuccess$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> resetDatabase.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onSuccess$lambda$0(OfflineManager this$0, FileSourceCallback $callback) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onSuccess();
                }
            }

            private static final void onError$lambda$1(OfflineManager this$0, FileSourceCallback $callback, String $message) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onError($message);
                }
            }
        });
    }

    public final void packDatabase(@Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativePackDatabase(new FileSourceCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ FileSourceCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> packDatabase.1.onSuccess$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> packDatabase.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onSuccess$lambda$0(OfflineManager this$0, FileSourceCallback $callback) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onSuccess();
                }
            }

            private static final void onError$lambda$1(OfflineManager this$0, FileSourceCallback $callback, String $message) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onError($message);
                }
            }
        });
    }

    public final void invalidateAmbientCache(@Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeInvalidateAmbientCache(new FileSourceCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ FileSourceCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> invalidateAmbientCache.1.onSuccess$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> invalidateAmbientCache.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onSuccess$lambda$0(OfflineManager this$0, FileSourceCallback $callback) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onSuccess();
                }
            }

            private static final void onError$lambda$1(OfflineManager this$0, FileSourceCallback $callback, String $message) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onError($message);
                }
            }
        });
    }

    public final void clearAmbientCache(@Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeClearAmbientCache(new FileSourceCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ FileSourceCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> clearAmbientCache.1.onSuccess$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> clearAmbientCache.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onSuccess$lambda$0(OfflineManager this$0, FileSourceCallback $callback) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onSuccess();
                }
            }

            private static final void onError$lambda$1(OfflineManager this$0, FileSourceCallback $callback, String $message) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onError($message);
                }
            }
        });
    }

    public final void setMaximumAmbientCacheSize(long size, @Nullable FileSourceCallback callback) {
        this.fileSource.activate();
        this.nativeSetMaximumAmbientCacheSize(size, new FileSourceCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ FileSourceCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onSuccess() {
                OfflineManager.access$getHandler$p(this.this$0).post(() -> setMaximumAmbientCacheSize.1.onSuccess$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineManager.access$getFileSource$p(this.this$0).activate();
                OfflineManager.access$getHandler$p(this.this$0).post(() -> setMaximumAmbientCacheSize.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onSuccess$lambda$0(OfflineManager this$0, FileSourceCallback $callback) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onSuccess();
                }
            }

            private static final void onError$lambda$1(OfflineManager this$0, FileSourceCallback $callback, String $message) {
                block0: {
                    OfflineManager.access$getFileSource$p(this$0).deactivate();
                    FileSourceCallback fileSourceCallback = $callback;
                    if (fileSourceCallback == null) break block0;
                    fileSourceCallback.onError($message);
                }
            }
        });
    }

    private final void mergeOfflineDatabaseFiles(File file, MergeOfflineRegionsCallback callback, boolean isTemporaryFile) {
        this.fileSource.activate();
        String string2 = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        this.mergeOfflineRegions(this.fileSource, string2, new MergeOfflineRegionsCallback(isTemporaryFile, file, this, callback){
            final /* synthetic */ boolean $isTemporaryFile;
            final /* synthetic */ File $file;
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ MergeOfflineRegionsCallback $callback;
            {
                this.$isTemporaryFile = $isTemporaryFile;
                this.$file = $file;
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onMerge(OfflineRegion[] offlineRegions) {
                if (this.$isTemporaryFile) {
                    this.$file.delete();
                }
                OfflineManager.access$getHandler$p(this.this$0).post(() -> mergeOfflineDatabaseFiles.1.onMerge$lambda$0(this.this$0, this.$callback, offlineRegions));
            }

            public void onError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (this.$isTemporaryFile) {
                    this.$file.delete();
                }
                OfflineManager.access$getHandler$p(this.this$0).post(() -> mergeOfflineDatabaseFiles.1.onError$lambda$1(this.this$0, this.$callback, error));
            }

            private static final void onMerge$lambda$0(OfflineManager this$0, MergeOfflineRegionsCallback $callback, OfflineRegion[] $offlineRegions) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onMerge($offlineRegions);
            }

            private static final void onError$lambda$1(OfflineManager this$0, MergeOfflineRegionsCallback $callback, String $error) {
                OfflineManager.access$getFileSource$p(this$0).deactivate();
                $callback.onError($error);
            }
        });
    }

    public final void createOfflineRegion(@NotNull OfflineRegionDefinition definition, @NotNull byte[] metadata, @NotNull CreateOfflineRegionCallback callback) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!this.isValidOfflineRegionDefinition(definition)) {
            String string2 = this.context.getString(R.string.maphero_offline_error_region_definition_invalid);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            String string3 = string2;
            Object[] objectArray = new Object[]{definition.getBounds()};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            callback.onError(string4);
            return;
        }
        ConnectivityReceiver.instance(this.context).activate();
        FileSource.getInstance(this.context).activate();
        this.createOfflineRegion(this.fileSource, definition, metadata, new CreateOfflineRegionCallback(this, callback){
            final /* synthetic */ OfflineManager this$0;
            final /* synthetic */ CreateOfflineRegionCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onCreate(OfflineRegion offlineRegion) {
                Intrinsics.checkNotNullParameter((Object)offlineRegion, (String)"offlineRegion");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> createOfflineRegion.1.onCreate$lambda$0(this.this$0, this.$callback, offlineRegion));
            }

            public void onError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                OfflineManager.access$getHandler$p(this.this$0).post(() -> createOfflineRegion.1.onError$lambda$1(this.this$0, this.$callback, error));
            }

            private static final void onCreate$lambda$0(OfflineManager this$0, CreateOfflineRegionCallback $callback, OfflineRegion $offlineRegion) {
                ConnectivityReceiver.instance(OfflineManager.access$getContext$p(this$0)).deactivate();
                FileSource.getInstance(OfflineManager.access$getContext$p(this$0)).deactivate();
                $callback.onCreate($offlineRegion);
            }

            private static final void onError$lambda$1(OfflineManager this$0, CreateOfflineRegionCallback $callback, String $error) {
                ConnectivityReceiver.instance(OfflineManager.access$getContext$p(this$0)).deactivate();
                FileSource.getInstance(OfflineManager.access$getContext$p(this$0)).deactivate();
                $callback.onError($error);
            }
        });
    }

    private final boolean isValidOfflineRegionDefinition(OfflineRegionDefinition definition) {
        LatLngBounds latLngBounds = LatLngBounds.Companion.world();
        LatLngBounds latLngBounds2 = definition.getBounds();
        Intrinsics.checkNotNull((Object)latLngBounds2);
        return latLngBounds.contains(latLngBounds2);
    }

    @Keep
    public final native void setOfflineMapboxTileCountLimit(long var1);

    @Keep
    public final native void runPackDatabaseAutomatically(boolean var1);

    @Keep
    private final native void initialize(FileSource var1);

    @Keep
    protected final native void finalize() throws Throwable;

    @Keep
    private final native void listOfflineRegions(FileSource var1, ListOfflineRegionsCallback var2);

    @Keep
    private final native void getOfflineRegion(FileSource var1, long var2, GetOfflineRegionCallback var4);

    @Keep
    private final native void createOfflineRegion(FileSource var1, OfflineRegionDefinition var2, byte[] var3, CreateOfflineRegionCallback var4);

    @Keep
    private final native void mergeOfflineRegions(FileSource var1, String var2, MergeOfflineRegionsCallback var3);

    @Keep
    private final native void nativeResetDatabase(FileSourceCallback var1);

    @Keep
    private final native void nativePackDatabase(FileSourceCallback var1);

    @Keep
    private final native void nativeInvalidateAmbientCache(FileSourceCallback var1);

    @Keep
    private final native void nativeClearAmbientCache(FileSourceCallback var1);

    @Keep
    private final native void nativeSetMaximumAmbientCacheSize(long var1, FileSourceCallback var3);

    @Keep
    public final native void putResourceWithUrl(@Nullable String var1, @Nullable byte[] var2, long var3, long var5, @Nullable String var7, boolean var8);

    private static final void mergeOfflineRegions$lambda$3$lambda$0(OfflineManager this$0, File $src, MergeOfflineRegionsCallback $callback) {
        this$0.mergeOfflineDatabaseFiles($src, $callback, false);
    }

    private static final void mergeOfflineRegions$lambda$3$lambda$1(OfflineManager this$0, File $dst, MergeOfflineRegionsCallback $callback) {
        this$0.mergeOfflineDatabaseFiles($dst, $callback, true);
    }

    private static final void mergeOfflineRegions$lambda$3$lambda$2(MergeOfflineRegionsCallback $callback, String $finalErrorMessage) {
        $callback.onError($finalErrorMessage);
    }

    private static final void mergeOfflineRegions$lambda$3(File $src, OfflineManager this$0, MergeOfflineRegionsCallback $callback) {
        String errorMessage = null;
        if ($src.canWrite()) {
            this$0.handler.post(() -> OfflineManager.mergeOfflineRegions$lambda$3$lambda$0(this$0, $src, $callback));
        } else if ($src.canRead()) {
            File dst = new File(FileSource.getInternalCachePath(this$0.context), $src.getName());
            try {
                OfflineManager.Companion.copyTempDatabaseFile($src, dst);
                Boolean bl = this$0.handler.post(() -> OfflineManager.mergeOfflineRegions$lambda$3$lambda$1(this$0, dst, $callback));
            }
            catch (IOException ex) {
                ex.printStackTrace();
                errorMessage = ex.getMessage();
                Unit unit = Unit.INSTANCE;
            }
        } else {
            errorMessage = "Secondary database needs to be located in a readable path.";
        }
        if (errorMessage != null) {
            String finalErrorMessage = errorMessage;
            this$0.handler.post(() -> OfflineManager.mergeOfflineRegions$lambda$3$lambda$2($callback, finalErrorMessage));
        }
    }

    @JvmStatic
    @NotNull
    public static final synchronized OfflineManager getInstance(@NotNull Context context) {
        return Companion.getInstance(context);
    }

    public static final /* synthetic */ Handler access$getHandler$p(OfflineManager $this) {
        return $this.handler;
    }

    public static final /* synthetic */ FileSource access$getFileSource$p(OfflineManager $this) {
        return $this.fileSource;
    }

    public static final /* synthetic */ Context access$getContext$p(OfflineManager $this) {
        return $this.context;
    }

    public /* synthetic */ OfflineManager(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    static {
        LibraryLoader.load();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/maphero/android/offline/OfflineManager$Companion;", "", "<init>", "()V", "TAG", "", "instance", "Lorg/maphero/android/offline/OfflineManager;", "getInstance", "context", "Landroid/content/Context;", "copyTempDatabaseFile", "", "sourceFile", "Ljava/io/File;", "destFile", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final synchronized OfflineManager getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (instance == null) {
                instance = new OfflineManager(context, null);
            }
            OfflineManager offlineManager = instance;
            Intrinsics.checkNotNull((Object)offlineManager);
            return offlineManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyTempDatabaseFile(File sourceFile, File destFile) throws IOException {
            if (!destFile.exists() && !destFile.createNewFile()) {
                throw new IOException("Unable to copy database file for merge.");
            }
            AbstractInterruptibleChannel source = null;
            AbstractInterruptibleChannel destination = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom((ReadableByteChannel)((Object)source), 0L, ((FileChannel)source).size());
            }
            catch (IOException ex) {
                String string2 = "Unable to copy database file for merge. %s";
                Object[] objectArray = new Object[]{ex.getMessage()};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                throw new IOException(string3);
            }
            finally {
                AbstractInterruptibleChannel abstractInterruptibleChannel = source;
                if (abstractInterruptibleChannel != null) {
                    abstractInterruptibleChannel.close();
                }
                AbstractInterruptibleChannel abstractInterruptibleChannel2 = destination;
                if (abstractInterruptibleChannel2 != null) {
                    abstractInterruptibleChannel2.close();
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lorg/maphero/android/offline/OfflineManager$CreateOfflineRegionCallback;", "", "onCreate", "", "offlineRegion", "Lorg/maphero/android/offline/OfflineRegion;", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface CreateOfflineRegionCallback {
        public void onCreate(@NotNull OfflineRegion var1);

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/maphero/android/offline/OfflineManager$FileSourceCallback;", "", "onSuccess", "", "onError", "message", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface FileSourceCallback {
        public void onSuccess();

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH&\u00a8\u0006\n"}, d2={"Lorg/maphero/android/offline/OfflineManager$GetOfflineRegionCallback;", "", "onRegion", "", "offlineRegion", "Lorg/maphero/android/offline/OfflineRegion;", "onRegionNotFound", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface GetOfflineRegionCallback {
        public void onRegion(@NotNull OfflineRegion var1);

        public void onRegionNotFound();

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u001d\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lorg/maphero/android/offline/OfflineManager$ListOfflineRegionsCallback;", "", "onList", "", "offlineRegions", "", "Lorg/maphero/android/offline/OfflineRegion;", "([Lorg/maphero/android/offline/OfflineRegion;)V", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface ListOfflineRegionsCallback {
        public void onList(@Nullable OfflineRegion[] var1);

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u001d\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H&\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lorg/maphero/android/offline/OfflineManager$MergeOfflineRegionsCallback;", "", "onMerge", "", "offlineRegions", "", "Lorg/maphero/android/offline/OfflineRegion;", "([Lorg/maphero/android/offline/OfflineRegion;)V", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface MergeOfflineRegionsCallback {
        public void onMerge(@Nullable OfflineRegion[] var1);

        public void onError(@NotNull String var1);
    }
}

