/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.offline;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import java.lang.annotation.RetentionPolicy;
import kotlin.Metadata;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.Retention;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.LibraryLoader;
import org.maphero.android.MapHero;
import org.maphero.android.net.ConnectivityReceiver;
import org.maphero.android.offline.OfflineRegion;
import org.maphero.android.offline.OfflineRegionDefinition;
import org.maphero.android.offline.OfflineRegionError;
import org.maphero.android.offline.OfflineRegionStatus;
import org.maphero.android.storage.FileSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 A2\u00020\u0001:\u0007;<=>?@AB1\b\u0003\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0014J\b\u0010#\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020!2\b\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010'\u001a\u00020!2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020!2\u0006\u0010)\u001a\u00020,J\u0010\u0010-\u001a\u00020!2\b\u0010)\u001a\u0004\u0018\u00010.J\u0016\u0010/\u001a\u00020!2\u0006\u00100\u001a\u00020\n2\u0006\u0010)\u001a\u000201J\u0019\u00102\u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0083 J\t\u00103\u001a\u00020!H\u0085 J\u0011\u00104\u001a\u00020!2\u0006\u0010)\u001a\u00020&H\u0083 J\u0011\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u001dH\u0083 J\u0011\u00107\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0083 J\u0011\u00108\u001a\u00020!2\u0006\u0010)\u001a\u00020,H\u0083 J\u0019\u00109\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u000201H\u0083 J\u0011\u0010:\u001a\u00020!2\u0006\u0010)\u001a\u00020.H\u0083 R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00038\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006B"}, d2={"Lorg/maphero/android/offline/OfflineRegion;", "", "offlineRegionPtr", "", "fileSource", "Lorg/maphero/android/storage/FileSource;", "idParam", "definition", "Lorg/maphero/android/offline/OfflineRegionDefinition;", "metadata", "", "<init>", "(JLorg/maphero/android/storage/FileSource;JLorg/maphero/android/offline/OfflineRegionDefinition;[B)V", "context", "Landroid/content/Context;", "nativePtr", "id", "getId", "()J", "isDeleted", "", "getDefinition", "()Lorg/maphero/android/offline/OfflineRegionDefinition;", "value", "getMetadata", "()[B", "handler", "Landroid/os/Handler;", "state", "", "isDeliveringInactiveMessages", "()Z", "setDeliverInactiveMessages", "", "deliverInactiveMessages", "deliverMessages", "setObserver", "observer", "Lorg/maphero/android/offline/OfflineRegion$OfflineRegionObserver;", "setDownloadState", "getStatus", "callback", "Lorg/maphero/android/offline/OfflineRegion$OfflineRegionStatusCallback;", "delete", "Lorg/maphero/android/offline/OfflineRegion$OfflineRegionDeleteCallback;", "invalidate", "Lorg/maphero/android/offline/OfflineRegion$OfflineRegionInvalidateCallback;", "updateMetadata", "bytes", "Lorg/maphero/android/offline/OfflineRegion$OfflineRegionUpdateMetadataCallback;", "initialize", "finalize", "setOfflineRegionObserver", "setOfflineRegionDownloadState", "offlineRegionDownloadState", "getOfflineRegionStatus", "deleteOfflineRegion", "updateOfflineRegionMetadata", "invalidateOfflineRegion", "OfflineRegionObserver", "OfflineRegionStatusCallback", "OfflineRegionDeleteCallback", "OfflineRegionInvalidateCallback", "OfflineRegionUpdateMetadataCallback", "DownloadState", "Companion", "MapHeroAndroid_legacyRelease"})
public final class OfflineRegion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Keep
    private final long nativePtr;
    @NotNull
    private final FileSource fileSource;
    private final long id;
    private boolean isDeleted;
    @NotNull
    private final OfflineRegionDefinition definition;
    @NotNull
    private byte[] metadata;
    @NotNull
    private final Handler handler = new Handler(Looper.getMainLooper());
    private int state;
    private boolean isDeliveringInactiveMessages;
    public static final int STATE_INACTIVE = 0;
    public static final int STATE_ACTIVE = 1;

    @Keep
    private OfflineRegion(long offlineRegionPtr, FileSource fileSource, long idParam, OfflineRegionDefinition definition, byte[] metadata) {
        this.context = MapHero.getApplicationContext();
        this.fileSource = fileSource;
        this.id = idParam;
        this.definition = definition;
        this.metadata = metadata;
        this.initialize(offlineRegionPtr, fileSource);
    }

    public final long getId() {
        return this.id;
    }

    @NotNull
    public final OfflineRegionDefinition getDefinition() {
        return this.definition;
    }

    @NotNull
    public final byte[] getMetadata() {
        return this.metadata;
    }

    public final boolean isDeliveringInactiveMessages() {
        return this.isDeliveringInactiveMessages;
    }

    public final void setDeliverInactiveMessages(boolean deliverInactiveMessages) {
        this.isDeliveringInactiveMessages = deliverInactiveMessages;
    }

    private final boolean deliverMessages() {
        return this.state == 1 ? true : this.isDeliveringInactiveMessages;
    }

    public final void setObserver(@Nullable OfflineRegionObserver observer) {
        this.setOfflineRegionObserver(new OfflineRegionObserver(this, observer){
            final /* synthetic */ OfflineRegion this$0;
            final /* synthetic */ OfflineRegionObserver $observer;
            {
                this.this$0 = $receiver;
                this.$observer = $observer;
            }

            public void onStatusChanged(OfflineRegionStatus status) {
                Intrinsics.checkNotNullParameter((Object)status, (String)"status");
                if (OfflineRegion.access$deliverMessages(this.this$0)) {
                    OfflineRegion.access$getHandler$p(this.this$0).post(() -> setObserver.1.onStatusChanged$lambda$0(this.$observer, status));
                }
            }

            public void onError(OfflineRegionError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                if (OfflineRegion.access$deliverMessages(this.this$0)) {
                    OfflineRegion.access$getHandler$p(this.this$0).post(() -> setObserver.1.onError$lambda$1(this.$observer, error));
                }
            }

            public void mapboxTileCountLimitExceeded(long limit) {
                if (OfflineRegion.access$deliverMessages(this.this$0)) {
                    OfflineRegion.access$getHandler$p(this.this$0).post(() -> setObserver.1.mapboxTileCountLimitExceeded$lambda$2(this.$observer, limit));
                }
            }

            private static final void onStatusChanged$lambda$0(OfflineRegionObserver $observer, OfflineRegionStatus $status) {
                block0: {
                    OfflineRegionObserver offlineRegionObserver = $observer;
                    if (offlineRegionObserver == null) break block0;
                    offlineRegionObserver.onStatusChanged($status);
                }
            }

            private static final void onError$lambda$1(OfflineRegionObserver $observer, OfflineRegionError $error) {
                block0: {
                    OfflineRegionObserver offlineRegionObserver = $observer;
                    if (offlineRegionObserver == null) break block0;
                    offlineRegionObserver.onError($error);
                }
            }

            private static final void mapboxTileCountLimitExceeded$lambda$2(OfflineRegionObserver $observer, long $limit) {
                block0: {
                    OfflineRegionObserver offlineRegionObserver = $observer;
                    if (offlineRegionObserver == null) break block0;
                    offlineRegionObserver.mapboxTileCountLimitExceeded($limit);
                }
            }
        });
    }

    public final void setDownloadState(int state) {
        if (this.state == state) {
            return;
        }
        if (state == 1) {
            ConnectivityReceiver.instance(this.context).activate();
            this.fileSource.activate();
        } else {
            this.fileSource.deactivate();
            ConnectivityReceiver.instance(this.context).deactivate();
        }
        this.state = state;
        this.setOfflineRegionDownloadState(state);
    }

    public final void getStatus(@NotNull OfflineRegionStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.fileSource.activate();
        this.getOfflineRegionStatus(new OfflineRegionStatusCallback(this, callback){
            final /* synthetic */ OfflineRegion this$0;
            final /* synthetic */ OfflineRegionStatusCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onStatus(OfflineRegionStatus status) {
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> getStatus.1.onStatus$lambda$0(this.this$0, this.$callback, status));
            }

            public void onError(String error) {
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> getStatus.1.onError$lambda$1(this.this$0, this.$callback, error));
            }

            private static final void onStatus$lambda$0(OfflineRegion this$0, OfflineRegionStatusCallback $callback, OfflineRegionStatus $status) {
                OfflineRegion.access$getFileSource$p(this$0).deactivate();
                $callback.onStatus($status);
            }

            private static final void onError$lambda$1(OfflineRegion this$0, OfflineRegionStatusCallback $callback, String $error) {
                OfflineRegion.access$getFileSource$p(this$0).deactivate();
                $callback.onError($error);
            }
        });
    }

    public final void delete(@NotNull OfflineRegionDeleteCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!this.isDeleted) {
            this.isDeleted = true;
            this.fileSource.activate();
            this.deleteOfflineRegion(new OfflineRegionDeleteCallback(this, callback){
                final /* synthetic */ OfflineRegion this$0;
                final /* synthetic */ OfflineRegionDeleteCallback $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                }

                public void onDelete() {
                    OfflineRegion.access$getHandler$p(this.this$0).post(() -> delete.1.onDelete$lambda$0(this.this$0, this.$callback));
                }

                public void onError(String error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    OfflineRegion.access$getHandler$p(this.this$0).post(() -> delete.1.onError$lambda$1(this.this$0, this.$callback, error));
                }

                private static final void onDelete$lambda$0(OfflineRegion this$0, OfflineRegionDeleteCallback $callback) {
                    OfflineRegion.access$getFileSource$p(this$0).deactivate();
                    $callback.onDelete();
                    this$0.finalize();
                }

                private static final void onError$lambda$1(OfflineRegion this$0, OfflineRegionDeleteCallback $callback, String $error) {
                    OfflineRegion.access$setDeleted$p(this$0, false);
                    OfflineRegion.access$getFileSource$p(this$0).deactivate();
                    $callback.onError($error);
                }
            });
        }
    }

    public final void invalidate(@Nullable OfflineRegionInvalidateCallback callback) {
        this.fileSource.activate();
        this.invalidateOfflineRegion(new OfflineRegionInvalidateCallback(this, callback){
            final /* synthetic */ OfflineRegion this$0;
            final /* synthetic */ OfflineRegionInvalidateCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onInvalidate() {
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> invalidate.1.onInvalidate$lambda$0(this.this$0, this.$callback));
            }

            public void onError(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> invalidate.1.onError$lambda$1(this.this$0, this.$callback, message));
            }

            private static final void onInvalidate$lambda$0(OfflineRegion this$0, OfflineRegionInvalidateCallback $callback) {
                block0: {
                    OfflineRegion.access$getFileSource$p(this$0).deactivate();
                    OfflineRegionInvalidateCallback offlineRegionInvalidateCallback = $callback;
                    if (offlineRegionInvalidateCallback == null) break block0;
                    offlineRegionInvalidateCallback.onInvalidate();
                }
            }

            private static final void onError$lambda$1(OfflineRegion this$0, OfflineRegionInvalidateCallback $callback, String $message) {
                block0: {
                    OfflineRegion.access$getFileSource$p(this$0).deactivate();
                    OfflineRegionInvalidateCallback offlineRegionInvalidateCallback = $callback;
                    if (offlineRegionInvalidateCallback == null) break block0;
                    offlineRegionInvalidateCallback.onError($message);
                }
            }
        });
    }

    public final void updateMetadata(@NotNull byte[] bytes, @NotNull OfflineRegionUpdateMetadataCallback callback) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.updateOfflineRegionMetadata(bytes, new OfflineRegionUpdateMetadataCallback(this, callback){
            final /* synthetic */ OfflineRegion this$0;
            final /* synthetic */ OfflineRegionUpdateMetadataCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
            }

            public void onUpdate(byte[] metadata) {
                Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> updateMetadata.1.onUpdate$lambda$0(this.this$0, metadata, this.$callback));
            }

            public void onError(String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                OfflineRegion.access$getHandler$p(this.this$0).post(() -> updateMetadata.1.onError$lambda$1(this.$callback, error));
            }

            private static final void onUpdate$lambda$0(OfflineRegion this$0, byte[] $metadata, OfflineRegionUpdateMetadataCallback $callback) {
                OfflineRegion.access$setMetadata$p(this$0, $metadata);
                $callback.onUpdate($metadata);
            }

            private static final void onError$lambda$1(OfflineRegionUpdateMetadataCallback $callback, String $error) {
                $callback.onError($error);
            }
        });
    }

    @Keep
    private final native void initialize(long var1, FileSource var3);

    @Keep
    protected final native void finalize();

    @Keep
    private final native void setOfflineRegionObserver(OfflineRegionObserver var1);

    @Keep
    private final native void setOfflineRegionDownloadState(int var1);

    @Keep
    private final native void getOfflineRegionStatus(OfflineRegionStatusCallback var1);

    @Keep
    private final native void deleteOfflineRegion(OfflineRegionDeleteCallback var1);

    @Keep
    private final native void updateOfflineRegionMetadata(byte[] var1, OfflineRegionUpdateMetadataCallback var2);

    @Keep
    private final native void invalidateOfflineRegion(OfflineRegionInvalidateCallback var1);

    public static final /* synthetic */ boolean access$deliverMessages(OfflineRegion $this) {
        return $this.deliverMessages();
    }

    public static final /* synthetic */ Handler access$getHandler$p(OfflineRegion $this) {
        return $this.handler;
    }

    public static final /* synthetic */ FileSource access$getFileSource$p(OfflineRegion $this) {
        return $this.fileSource;
    }

    public static final /* synthetic */ void access$setDeleted$p(OfflineRegion $this, boolean bl) {
        $this.isDeleted = bl;
    }

    public static final /* synthetic */ void access$setMetadata$p(OfflineRegion $this, byte[] byArray) {
        $this.metadata = byArray;
    }

    static {
        LibraryLoader.load();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/maphero/android/offline/OfflineRegion$Companion;", "", "<init>", "()V", "STATE_INACTIVE", "", "STATE_ACTIVE", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=AnnotationRetention.SOURCE)
    @java.lang.annotation.Retention(value=RetentionPolicy.SOURCE)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\b\u0087\u0002\u0018\u00002\u00020\u0001B\u0000\u00a8\u0006\u0002"}, d2={"Lorg/maphero/android/offline/OfflineRegion$DownloadState;", "", "MapHeroAndroid_legacyRelease"})
    public static @interface DownloadState {
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/maphero/android/offline/OfflineRegion$OfflineRegionDeleteCallback;", "", "onDelete", "", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface OfflineRegionDeleteCallback {
        public void onDelete();

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/maphero/android/offline/OfflineRegion$OfflineRegionInvalidateCallback;", "", "onInvalidate", "", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface OfflineRegionInvalidateCallback {
        public void onInvalidate();

        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lorg/maphero/android/offline/OfflineRegion$OfflineRegionObserver;", "", "onStatusChanged", "", "status", "Lorg/maphero/android/offline/OfflineRegionStatus;", "onError", "error", "Lorg/maphero/android/offline/OfflineRegionError;", "mapboxTileCountLimitExceeded", "limit", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface OfflineRegionObserver {
        public void onStatusChanged(@NotNull OfflineRegionStatus var1);

        public void onError(@NotNull OfflineRegionError var1);

        public void mapboxTileCountLimitExceeded(long var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J\u0012\u0010\u0006\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\bH&\u00a8\u0006\t"}, d2={"Lorg/maphero/android/offline/OfflineRegion$OfflineRegionStatusCallback;", "", "onStatus", "", "status", "Lorg/maphero/android/offline/OfflineRegionStatus;", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface OfflineRegionStatusCallback {
        public void onStatus(@Nullable OfflineRegionStatus var1);

        public void onError(@Nullable String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bH&\u00a8\u0006\t"}, d2={"Lorg/maphero/android/offline/OfflineRegion$OfflineRegionUpdateMetadataCallback;", "", "onUpdate", "", "metadata", "", "onError", "error", "", "MapHeroAndroid_legacyRelease"})
    @Keep
    public static interface OfflineRegionUpdateMetadataCallback {
        public void onUpdate(@NotNull byte[] var1);

        public void onError(@NotNull String var1);
    }
}

