/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.snapshotter;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.os.Handler;
import android.os.Looper;
import android.text.Html;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import androidx.core.content.res.ResourcesCompat;
import java.util.Arrays;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.R;
import org.maphero.android.attribution.AttributionLayout;
import org.maphero.android.attribution.AttributionMeasure;
import org.maphero.android.attribution.AttributionParser;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.geometry.LatLngBounds;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.Image;
import org.maphero.android.maps.Style;
import org.maphero.android.snapshotter.MapSnapshot;
import org.maphero.android.storage.FileSource;
import org.maphero.android.style.layers.Layer;
import org.maphero.android.style.sources.Source;
import org.maphero.android.utils.FontUtils;
import org.maphero.android.utils.ThreadUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0017\u0018\u0000 {2\u00020\u0001:\u0006vwxyz{B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0019\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0087 J\u0013\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0087 J\u0013\u0010\u001b\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0087 J\u0013\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0087 J\u0013\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010 H\u0087 J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020 H\u0002J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020 H\u0002J\u0018\u0010)\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%2\u0006\u0010*\u001a\u00020\u0016H\u0002J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0002J\u001e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020 2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u000bJ\u0006\u00103\u001a\u00020\u0013J\u0010\u00104\u001a\u00020\u00132\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u000207H\u0014J(\u00108\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u0016H\u0002J \u0010=\u001a\u00020>2\u0006\u00106\u001a\u0002072\u0006\u00109\u001a\u0002012\u0006\u0010<\u001a\u00020\u0016H\u0002J(\u0010?\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00162\u0006\u0010@\u001a\u00020AH\u0002J(\u0010?\u001a\u00020\u00132\u0006\u00109\u001a\u0002012\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u00162\u0006\u0010B\u001a\u00020AH\u0002J*\u0010C\u001a\u00020\u00132\u0006\u00106\u001a\u0002072\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020>2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J \u0010C\u001a\u00020\u00132\u0006\u0010:\u001a\u00020;2\u0006\u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020FH\u0002J \u0010G\u001a\u00020H2\u0006\u00106\u001a\u0002072\u0006\u0010I\u001a\u00020\u000b2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u0010I\u001a\u00020\u000bH\u0002J\u0014\u0010M\u001a\u00060NR\u00020\u00002\u0006\u00109\u001a\u000201H\u0002J\u0018\u0010O\u001a\u00020K2\u0006\u00109\u001a\u0002012\u0006\u0010P\u001a\u000201H\u0002J\u0010\u0010Q\u001a\u00020\u00132\u0006\u00109\u001a\u000207H\u0005J\u0010\u0010R\u001a\u00020\u00132\u0006\u0010S\u001a\u00020 H\u0005J\u0010\u0010T\u001a\u00020\u00132\u0006\u0010S\u001a\u00020 H\u0005J\b\u0010U\u001a\u00020\u0013H\u0005J\u0010\u0010V\u001a\u0004\u0018\u00010%2\u0006\u0010W\u001a\u00020 J\u0010\u0010X\u001a\u0004\u0018\u00010-2\u0006\u0010Y\u001a\u00020 J\u0010\u0010Z\u001a\u00020\u00132\u0006\u0010[\u001a\u00020 H\u0005J\b\u0010\\\u001a\u00020\u0013H\u0002J\b\u0010]\u001a\u00020\u0013H\u0004Jo\u0010^\u001a\u00020\u00132\b\u0010_\u001a\u0004\u0018\u00010\u00002\b\u0010`\u001a\u0004\u0018\u00010a2\u0006\u0010b\u001a\u00020K2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010\"\u001a\u0004\u0018\u00010 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010c\u001a\u0004\u0018\u00010\u001a2\u0006\u0010d\u001a\u00020\u000b2\b\u0010e\u001a\u0004\u0018\u00010 H\u0085 J\t\u0010f\u001a\u00020\u0013H\u0085 J\t\u0010g\u001a\u00020\u0013H\u0085 J\u0019\u0010h\u001a\u00020\u00132\u0006\u0010i\u001a\u00020\t2\u0006\u0010&\u001a\u00020 H\u0083 J\u0019\u0010j\u001a\u00020\u00132\u0006\u0010i\u001a\u00020\t2\u0006\u0010(\u001a\u00020 H\u0083 J\u0019\u0010k\u001a\u00020\u00132\u0006\u0010i\u001a\u00020\t2\u0006\u0010*\u001a\u00020\u0016H\u0083 J\u0019\u0010l\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-2\u0006\u0010m\u001a\u00020\tH\u0083 J\u001c\u0010n\u001a\u00020\u00132\f\u0010o\u001a\b\u0012\u0004\u0012\u00020q0pH\u0083 \u00a2\u0006\u0002\u0010rJ\u0011\u0010s\u001a\u00020%2\u0006\u0010W\u001a\u00020 H\u0083 J\u0011\u0010t\u001a\u00020-2\u0006\u0010Y\u001a\u00020 H\u0083 J\t\u0010u\u001a\u00020\u0013H\u0095 R\u0010\u0010\b\u001a\u00020\t8\u0002X\u0083D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter;", "", "context", "Landroid/content/Context;", "options", "Lorg/maphero/android/snapshotter/MapSnapshotter$Options;", "<init>", "(Landroid/content/Context;Lorg/maphero/android/snapshotter/MapSnapshotter$Options;)V", "nativePtr", "", "fullyLoaded", "", "callback", "Lorg/maphero/android/snapshotter/MapSnapshotter$SnapshotReadyCallback;", "errorHandler", "Lorg/maphero/android/snapshotter/MapSnapshotter$ErrorHandler;", "observer", "Lorg/maphero/android/snapshotter/MapSnapshotter$Observer;", "start", "", "setSize", "width", "", "height", "setCameraPosition", "cameraPosition", "Lorg/maphero/android/camera/CameraPosition;", "setRegion", "region", "Lorg/maphero/android/geometry/LatLngBounds;", "setStyleUrl", "styleUrl", "", "setStyleJson", "styleJson", "addLayerBelow", "layer", "Lorg/maphero/android/style/layers/Layer;", "below", "addLayerAbove", "above", "addLayerAt", "index", "addSource", "source", "Lorg/maphero/android/style/sources/Source;", "addImage", "name", "bitmap", "Landroid/graphics/Bitmap;", "sdf", "cancel", "setObserver", "addOverlay", "mapSnapshot", "Lorg/maphero/android/snapshotter/MapSnapshot;", "drawOverlay", "snapshot", "canvas", "Landroid/graphics/Canvas;", "margin", "getAttributionMeasure", "Lorg/maphero/android/attribution/AttributionMeasure;", "drawLogo", "layout", "Lorg/maphero/android/attribution/AttributionLayout;", "placement", "drawAttribution", "measure", "anchorPoint", "Landroid/graphics/PointF;", "createTextView", "Landroid/widget/TextView;", "shortText", "scale", "", "createAttributionString", "createScaledLogo", "Lorg/maphero/android/snapshotter/MapSnapshotter$Logo;", "calculateLogoScale", "logo", "onSnapshotReady", "onSnapshotFailed", "reason", "onDidFailLoadingStyle", "onDidFinishLoadingStyle", "getLayer", "layerId", "getSource", "sourceId", "onStyleImageMissing", "imageName", "checkThread", "reset", "nativeInitialize", "mapSnapshotter", "fileSource", "Lorg/maphero/android/storage/FileSource;", "pixelRatio", "position", "showLogo", "localIdeographFontFamily", "nativeStart", "nativeCancel", "nativeAddLayerBelow", "layerPtr", "nativeAddLayerAbove", "nativeAddLayerAt", "nativeAddSource", "sourcePtr", "nativeAddImages", "images", "", "Lorg/maphero/android/maps/Image;", "([Lorg/maphero/android/maps/Image;)V", "nativeGetLayer", "nativeGetSource", "finalize", "SnapshotReadyCallback", "ErrorHandler", "Observer", "Options", "Logo", "Companion", "MapHeroAndroid_legacyRelease"})
@UiThread
@SourceDebugExtension(value={"SMAP\nMapSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSnapshotter.kt\norg/maphero/android/snapshotter/MapSnapshotter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1#2:773\n*E\n"})
public class MapSnapshotter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Keep
    private final long nativePtr;
    @NotNull
    private final Context context;
    private boolean fullyLoaded;
    @NotNull
    private final Options options;
    @Nullable
    private SnapshotReadyCallback callback;
    @Nullable
    private ErrorHandler errorHandler;
    @Nullable
    private Observer observer;
    @NotNull
    private static final String TAG = "Mbgl-MapSnapshotter";
    private static final int LOGO_MARGIN_DP = 4;

    public MapSnapshotter(@NotNull Context context, @NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.checkThread();
        this.context = context.getApplicationContext();
        this.options = options;
        FileSource fileSource = FileSource.getInstance(context);
        String apiBaseUrl = options.getApiBaseUri();
        if (!TextUtils.isEmpty((CharSequence)apiBaseUrl)) {
            fileSource.setApiBaseUrl(apiBaseUrl);
        }
        this.nativeInitialize(this, fileSource, options.getPixelRatio(), options.getWidth(), options.getHeight(), options.getStyleUri(), options.getStyleJson(), options.getRegion(), options.getCameraPosition(), options.getShowLogo(), options.getLocalIdeographFontFamily());
    }

    @JvmOverloads
    public final void start(@NotNull SnapshotReadyCallback callback, @Nullable ErrorHandler errorHandler) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (!(this.callback == null)) {
            boolean bl = false;
            String string2 = "Snapshotter was already started";
            throw new IllegalStateException(string2.toString());
        }
        this.checkThread();
        this.callback = callback;
        this.errorHandler = errorHandler;
        this.nativeStart();
    }

    public static /* synthetic */ void start$default(MapSnapshotter mapSnapshotter, SnapshotReadyCallback snapshotReadyCallback, ErrorHandler errorHandler, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: start");
        }
        if ((n & 2) != 0) {
            errorHandler = null;
        }
        mapSnapshotter.start(snapshotReadyCallback, errorHandler);
    }

    @Keep
    public final native void setSize(int var1, int var2);

    @Keep
    public final native void setCameraPosition(@Nullable CameraPosition var1);

    @Keep
    public final native void setRegion(@Nullable LatLngBounds var1);

    @Keep
    public final native void setStyleUrl(@Nullable String var1);

    @Keep
    public final native void setStyleJson(@Nullable String var1);

    private final void addLayerBelow(Layer layer, String below) {
        this.nativeAddLayerBelow(layer.getNativePtr(), below);
    }

    private final void addLayerAbove(Layer layer, String above) {
        this.nativeAddLayerAbove(layer.getNativePtr(), above);
    }

    private final void addLayerAt(Layer layer, int index) {
        this.nativeAddLayerAt(layer.getNativePtr(), index);
    }

    private final void addSource(Source source) {
        this.nativeAddSource(source, source.getNativePtr());
    }

    public final void addImage(@NotNull String name, @NotNull Bitmap bitmap, boolean sdf) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Image[] imageArray = new Image[]{Style.toImage(new Style.Builder.ImageWrapper(name, bitmap, sdf))};
        this.nativeAddImages(imageArray);
    }

    public final void cancel() {
        this.checkThread();
        this.reset();
        this.nativeCancel();
    }

    public final void setObserver(@Nullable Observer observer) {
        this.checkThread();
        this.observer = observer;
    }

    protected void addOverlay(@NotNull MapSnapshot mapSnapshot) {
        Bitmap snapshot;
        Intrinsics.checkNotNullParameter((Object)mapSnapshot, (String)"mapSnapshot");
        Bitmap bitmap = snapshot = mapSnapshot.getBitmap();
        Intrinsics.checkNotNull((Object)bitmap);
        Canvas canvas = new Canvas(bitmap);
        int margin = (int)this.context.getResources().getDisplayMetrics().density * 4;
        this.drawOverlay(mapSnapshot, snapshot, canvas, margin);
    }

    private final void drawOverlay(MapSnapshot mapSnapshot, Bitmap snapshot, Canvas canvas, int margin) {
        AttributionLayout layout;
        AttributionMeasure measure = this.getAttributionMeasure(mapSnapshot, snapshot, margin);
        AttributionLayout attributionLayout = layout = measure.measure();
        Intrinsics.checkNotNull((Object)attributionLayout);
        this.drawLogo(mapSnapshot, canvas, margin, attributionLayout);
        this.drawAttribution(mapSnapshot, canvas, measure, layout);
    }

    private final AttributionMeasure getAttributionMeasure(MapSnapshot mapSnapshot, Bitmap snapshot, int margin) {
        Logo logo = this.createScaledLogo(snapshot);
        TextView longText = this.createTextView(mapSnapshot, false, logo.getScale());
        TextView shortText = this.createTextView(mapSnapshot, true, logo.getScale());
        AttributionMeasure attributionMeasure = new AttributionMeasure.Builder().setSnapshot(snapshot).setLogo(logo.getLarge()).setLogoSmall(logo.getSmall()).setTextView(longText).setTextViewShort(shortText).setMarginPadding(margin).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionMeasure, (String)"build(...)");
        return attributionMeasure;
    }

    private final void drawLogo(MapSnapshot mapSnapshot, Canvas canvas, int margin, AttributionLayout layout) {
        if (mapSnapshot.isShowLogo()) {
            this.drawLogo(mapSnapshot.getBitmap(), canvas, margin, layout);
        }
    }

    private final void drawLogo(Bitmap snapshot, Canvas canvas, int margin, AttributionLayout placement) {
        Bitmap selectedLogo = placement.getLogo();
        if (selectedLogo != null) {
            canvas.drawBitmap(selectedLogo, (float)margin, (float)(snapshot.getHeight() - selectedLogo.getHeight() - margin), null);
        }
    }

    private final void drawAttribution(MapSnapshot mapSnapshot, Canvas canvas, AttributionMeasure measure, AttributionLayout layout) {
        AttributionLayout attributionLayout = layout;
        Intrinsics.checkNotNull((Object)attributionLayout);
        PointF anchorPoint = attributionLayout.getAnchorPoint();
        if (anchorPoint != null) {
            this.drawAttribution(canvas, measure, anchorPoint);
        } else {
            Bitmap snapshot = mapSnapshot.getBitmap();
            String string2 = "Could not generate attribution for snapshot size: %s x %s. You are required to provide your own attribution for the used sources: %s";
            Object[] objectArray = new Object[]{snapshot.getWidth(), snapshot.getHeight(), mapSnapshot.getAttributions()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            Logger.e(TAG, string3);
        }
    }

    private final void drawAttribution(Canvas canvas, AttributionMeasure measure, PointF anchorPoint) {
        canvas.save();
        canvas.translate(anchorPoint.x, anchorPoint.y);
        measure.getTextView().draw(canvas);
        canvas.restore();
    }

    private final TextView createTextView(MapSnapshot mapSnapshot, boolean shortText, float scale) {
        int textColor = ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.maphero_gray_dark, (Resources.Theme)this.context.getTheme());
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        TextView textView = new TextView(this.context);
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        textView.setSingleLine(true);
        textView.setTextSize((float)10 * scale);
        textView.setTextColor(textColor);
        textView.setBackgroundResource(R.drawable.maphero_rounded_corner);
        textView.setText((CharSequence)Html.fromHtml((String)this.createAttributionString(mapSnapshot, shortText)));
        textView.measure(widthMeasureSpec, heightMeasureSpec);
        textView.layout(0, 0, textView.getMeasuredWidth(), textView.getMeasuredHeight());
        return textView;
    }

    private final String createAttributionString(MapSnapshot mapSnapshot, boolean shortText) {
        String[] stringArray = mapSnapshot.getAttributions();
        AttributionParser attributionParser = new AttributionParser.Options(this.context).withAttributionData(Arrays.copyOf(stringArray, stringArray.length)).withCopyrightSign(false).withImproveMap(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)attributionParser, (String)"build(...)");
        AttributionParser attributionParser2 = attributionParser;
        String string2 = attributionParser2.createAttributionString(shortText);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"createAttributionString(...)");
        return string2;
    }

    private final Logo createScaledLogo(Bitmap snapshot) {
        Bitmap logo = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.maphero_logo_icon, null);
        Intrinsics.checkNotNull((Object)logo);
        float scale = this.calculateLogoScale(snapshot, logo);
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap helmet = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)R.drawable.maphero_logo_helmet, null);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(...)");
        Bitmap large = bitmap;
        Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)helmet, (int)0, (int)0, (int)helmet.getWidth(), (int)helmet.getHeight(), (Matrix)matrix, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"createBitmap(...)");
        Bitmap small = bitmap2;
        return new Logo(large, small, scale);
    }

    private final float calculateLogoScale(Bitmap snapshot, Bitmap logo) {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        float widthRatio = displayMetrics.widthPixels / snapshot.getWidth();
        float heightRatio = displayMetrics.heightPixels / snapshot.getHeight();
        float prefWidth = (float)logo.getWidth() / widthRatio;
        float prefHeight = (float)logo.getHeight() / heightRatio;
        float calculatedScale = Math.min(prefWidth / (float)logo.getWidth(), prefHeight / (float)logo.getHeight()) * (float)2;
        if (calculatedScale > 1.0f) {
            calculatedScale = 1.0f;
        } else if (calculatedScale < 0.6f) {
            calculatedScale = 0.6f;
        }
        return calculatedScale;
    }

    @Keep
    protected final void onSnapshotReady(@NotNull MapSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        new Handler(Looper.getMainLooper()).post(() -> MapSnapshotter.onSnapshotReady$lambda$1(this, snapshot));
    }

    @Keep
    protected final void onSnapshotFailed(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        new Handler(Looper.getMainLooper()).post(() -> MapSnapshotter.onSnapshotFailed$lambda$2(this, reason));
    }

    @Keep
    protected final void onDidFailLoadingStyle(@NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.onSnapshotFailed(reason);
    }

    @Keep
    protected final void onDidFinishLoadingStyle() {
        if (!this.fullyLoaded) {
            this.fullyLoaded = true;
            Style.Builder builder = this.options.getBuilder();
            if (builder != null) {
                for (Source source : builder.getSources()) {
                    Intrinsics.checkNotNull((Object)source);
                    this.nativeAddSource(source, source.getNativePtr());
                }
                for (Style.Builder.LayerWrapper layerWrapper : builder.getLayers()) {
                    if (layerWrapper instanceof Style.Builder.LayerAtWrapper) {
                        Layer layer = ((Style.Builder.LayerAtWrapper)layerWrapper).getLayer();
                        Intrinsics.checkNotNullExpressionValue((Object)layer, (String)"getLayer(...)");
                        this.addLayerAt(layer, ((Style.Builder.LayerAtWrapper)layerWrapper).getIndex());
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerAboveWrapper) {
                        Layer layer = ((Style.Builder.LayerAboveWrapper)layerWrapper).getLayer();
                        Intrinsics.checkNotNullExpressionValue((Object)layer, (String)"getLayer(...)");
                        String string2 = ((Style.Builder.LayerAboveWrapper)layerWrapper).getAboveLayer();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAboveLayer(...)");
                        this.addLayerAbove(layer, string2);
                        continue;
                    }
                    if (layerWrapper instanceof Style.Builder.LayerBelowWrapper) {
                        Layer layer = ((Style.Builder.LayerBelowWrapper)layerWrapper).getLayer();
                        Intrinsics.checkNotNullExpressionValue((Object)layer, (String)"getLayer(...)");
                        String string3 = ((Style.Builder.LayerBelowWrapper)layerWrapper).getBelowLayer();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getBelowLayer(...)");
                        this.addLayerBelow(layer, string3);
                        continue;
                    }
                    Layer layer = layerWrapper.getLayer();
                    Intrinsics.checkNotNullExpressionValue((Object)layer, (String)"getLayer(...)");
                    this.addLayerBelow(layer, "org.maplibre.annotations.points");
                }
                for (Style.Builder.ImageWrapper image : builder.getImages()) {
                    String string4 = image.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getId(...)");
                    Bitmap bitmap = image.getBitmap();
                    Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"getBitmap(...)");
                    this.addImage(string4, bitmap, image.isSdf());
                }
            }
        }
        if (this.observer != null) {
            Observer observer = this.observer;
            Intrinsics.checkNotNull((Object)observer);
            observer.onDidFinishLoadingStyle();
        }
    }

    @Nullable
    public final Layer getLayer(@NotNull String layerId) {
        Intrinsics.checkNotNullParameter((Object)layerId, (String)"layerId");
        this.checkThread();
        return this.fullyLoaded ? this.nativeGetLayer(layerId) : null;
    }

    @Nullable
    public final Source getSource(@NotNull String sourceId) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        this.checkThread();
        return this.fullyLoaded ? this.nativeGetSource(sourceId) : null;
    }

    @Keep
    protected final void onStyleImageMissing(@NotNull String imageName) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        if (this.observer != null) {
            Observer observer = this.observer;
            Intrinsics.checkNotNull((Object)observer);
            observer.onStyleImageMissing(imageName);
        }
    }

    private final void checkThread() {
        ThreadUtils.checkThread(TAG);
    }

    protected final void reset() {
        this.callback = null;
        this.errorHandler = null;
    }

    @Keep
    protected final native void nativeInitialize(@Nullable MapSnapshotter var1, @Nullable FileSource var2, float var3, int var4, int var5, @Nullable String var6, @Nullable String var7, @Nullable LatLngBounds var8, @Nullable CameraPosition var9, boolean var10, @Nullable String var11);

    @Keep
    protected final native void nativeStart();

    @Keep
    protected final native void nativeCancel();

    @Keep
    private final native void nativeAddLayerBelow(long var1, String var3);

    @Keep
    private final native void nativeAddLayerAbove(long var1, String var3);

    @Keep
    private final native void nativeAddLayerAt(long var1, int var3);

    @Keep
    private final native void nativeAddSource(Source var1, long var2);

    @Keep
    private final native void nativeAddImages(Image[] var1);

    @Keep
    private final native Layer nativeGetLayer(String var1);

    @Keep
    private final native Source nativeGetSource(String var1);

    @Keep
    protected native void finalize() throws Throwable;

    @JvmOverloads
    public final void start(@NotNull SnapshotReadyCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        MapSnapshotter.start$default(this, callback, null, 2, null);
    }

    private static final void onSnapshotReady$lambda$1(MapSnapshotter this$0, MapSnapshot $snapshot) {
        if (this$0.callback != null) {
            this$0.addOverlay($snapshot);
            SnapshotReadyCallback snapshotReadyCallback = this$0.callback;
            Intrinsics.checkNotNull((Object)snapshotReadyCallback);
            snapshotReadyCallback.onSnapshotReady($snapshot);
            this$0.reset();
        }
    }

    private static final void onSnapshotFailed$lambda$2(MapSnapshotter this$0, String $reason) {
        if (this$0.errorHandler != null) {
            ErrorHandler errorHandler = this$0.errorHandler;
            Intrinsics.checkNotNull((Object)errorHandler);
            errorHandler.onError($reason);
            this$0.reset();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$Companion;", "", "<init>", "()V", "TAG", "", "LOGO_MARGIN_DP", "", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$ErrorHandler;", "", "onError", "", "error", "", "MapHeroAndroid_legacyRelease"})
    public static interface ErrorHandler {
        public void onError(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$Logo;", "", "large", "Landroid/graphics/Bitmap;", "small", "scale", "", "<init>", "(Lorg/maphero/android/snapshotter/MapSnapshotter;Landroid/graphics/Bitmap;Landroid/graphics/Bitmap;F)V", "getLarge", "()Landroid/graphics/Bitmap;", "getSmall", "getScale", "()F", "MapHeroAndroid_legacyRelease"})
    private final class Logo {
        @NotNull
        private final Bitmap large;
        @NotNull
        private final Bitmap small;
        private final float scale;

        public Logo(@NotNull Bitmap large, Bitmap small, float scale) {
            Intrinsics.checkNotNullParameter((Object)large, (String)"large");
            Intrinsics.checkNotNullParameter((Object)small, (String)"small");
            this.large = large;
            this.small = small;
            this.scale = scale;
        }

        @NotNull
        public final Bitmap getLarge() {
            return this.large;
        }

        @NotNull
        public final Bitmap getSmall() {
            return this.small;
        }

        public final float getScale() {
            return this.scale;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&\u00a8\u0006\u0007"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$Observer;", "", "onDidFinishLoadingStyle", "", "onStyleImageMissing", "imageName", "", "MapHeroAndroid_legacyRelease"})
    public static interface Observer {
        public void onDidFinishLoadingStyle();

        public void onStyleImageMissing(@NotNull String var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010'\u001a\u00020\u00002\b\u0010$\u001a\u0004\u0018\u00010#J\u0012\u0010(\u001a\u00020\u00002\b\u0010)\u001a\u0004\u0018\u00010\u001dH\u0007J\u0012\u0010*\u001a\u00020\u00002\b\u0010+\u001a\u0004\u0018\u00010\u001dH\u0007J\u0010\u0010,\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010.\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\u000e\u0010/\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u00100\u001a\u00020\u00002\b\u00101\u001a\u0004\u0018\u00010\u001dJ#\u00100\u001a\u00020\u00002\u0016\u00102\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u001d03\"\u0004\u0018\u00010\u001d\u00a2\u0006\u0002\u00104J\u0012\u00105\u001a\u00020\u00002\b\u00106\u001a\u0004\u0018\u00010\u001dH\u0007J\u0010\u00107\u001a\u00020\u00002\b\u0010!\u001a\u0004\u0018\u00010\u001dR\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u0007\u001a\u0004\u0018\u00010\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0007\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010!\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0007\u001a\u0004\u0018\u00010\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\"\u0010$\u001a\u0004\u0018\u00010#2\b\u0010\u0007\u001a\u0004\u0018\u00010#@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u00108\u001a\u0004\u0018\u00010\u001d8G\u00a2\u0006\u0006\u001a\u0004\b9\u0010 R\u0013\u0010:\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b;\u0010 R\u0013\u0010+\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010 \u00a8\u0006="}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$Options;", "", "width", "", "height", "<init>", "(II)V", "value", "", "pixelRatio", "getPixelRatio", "()F", "getWidth", "()I", "getHeight", "Lorg/maphero/android/geometry/LatLngBounds;", "region", "getRegion", "()Lorg/maphero/android/geometry/LatLngBounds;", "Lorg/maphero/android/camera/CameraPosition;", "cameraPosition", "getCameraPosition", "()Lorg/maphero/android/camera/CameraPosition;", "showLogo", "", "getShowLogo", "()Z", "setShowLogo", "(Z)V", "", "localIdeographFontFamily", "getLocalIdeographFontFamily", "()Ljava/lang/String;", "apiBaseUri", "getApiBaseUri", "Lorg/maphero/android/maps/Style$Builder;", "builder", "getBuilder", "()Lorg/maphero/android/maps/Style$Builder;", "withStyleBuilder", "withStyle", "uri", "withStyleJson", "styleJson", "withRegion", "withPixelRatio", "withCameraPosition", "withLogo", "withLocalIdeographFontFamily", "fontFamily", "fontFamilies", "", "([Ljava/lang/String;)Lorg/maphero/android/snapshotter/MapSnapshotter$Options;", "withApiBaseUrl", "apiBaseUrl", "withApiBaseUri", "styleUrl", "getStyleUrl", "styleUri", "getStyleUri", "getStyleJson", "MapHeroAndroid_legacyRelease"})
    @SourceDebugExtension(value={"SMAP\nMapSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapSnapshotter.kt\norg/maphero/android/snapshotter/MapSnapshotter$Options\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1#2:773\n*E\n"})
    public static final class Options {
        private float pixelRatio = 1.0f;
        private final int width;
        private final int height;
        @Nullable
        private LatLngBounds region;
        @Nullable
        private CameraPosition cameraPosition;
        private boolean showLogo = true;
        @NotNull
        private String localIdeographFontFamily = "sans-serif";
        @Nullable
        private String apiBaseUri;
        @Nullable
        private Style.Builder builder;

        public Options(int width, int height) {
            if (!(width != 0 && height != 0)) {
                boolean bl = false;
                String string2 = "Unable to create a snapshot with width or height set to 0";
                throw new IllegalArgumentException(string2.toString());
            }
            this.width = width;
            this.height = height;
        }

        public final float getPixelRatio() {
            return this.pixelRatio;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        @Nullable
        public final LatLngBounds getRegion() {
            return this.region;
        }

        @Nullable
        public final CameraPosition getCameraPosition() {
            return this.cameraPosition;
        }

        public final boolean getShowLogo() {
            return this.showLogo;
        }

        public final void setShowLogo(boolean bl) {
            this.showLogo = bl;
        }

        @NotNull
        public final String getLocalIdeographFontFamily() {
            return this.localIdeographFontFamily;
        }

        @Nullable
        public final String getApiBaseUri() {
            return this.apiBaseUri;
        }

        @Nullable
        public final Style.Builder getBuilder() {
            return this.builder;
        }

        @NotNull
        public final Options withStyleBuilder(@Nullable Style.Builder builder) {
            this.builder = builder;
            return this;
        }

        @Deprecated(message="use {@link  #withStyleBuilder(Style.Builder)} instead")
        @NotNull
        public final Options withStyle(@Nullable String uri) {
            Style.Builder builder = new Style.Builder();
            String string2 = uri;
            Intrinsics.checkNotNull((Object)string2);
            this.withStyleBuilder(builder.fromUri(string2));
            return this;
        }

        @Deprecated(message="use {@link  #withStyleBuilder(Style.Builder)} instead")
        @NotNull
        public final Options withStyleJson(@Nullable String styleJson) {
            Style.Builder builder = new Style.Builder();
            String string2 = styleJson;
            Intrinsics.checkNotNull((Object)string2);
            this.withStyleBuilder(builder.fromJson(string2));
            return this;
        }

        @NotNull
        public final Options withRegion(@Nullable LatLngBounds region) {
            this.region = region;
            return this;
        }

        @NotNull
        public final Options withPixelRatio(float pixelRatio) {
            this.pixelRatio = pixelRatio;
            return this;
        }

        @NotNull
        public final Options withCameraPosition(@Nullable CameraPosition cameraPosition) {
            this.cameraPosition = cameraPosition;
            return this;
        }

        @NotNull
        public final Options withLogo(boolean showLogo) {
            this.showLogo = showLogo;
            return this;
        }

        @NotNull
        public final Options withLocalIdeographFontFamily(@Nullable String fontFamily) {
            String[] stringArray = new String[]{fontFamily};
            this.localIdeographFontFamily = FontUtils.extractValidFont(stringArray);
            return this;
        }

        @NotNull
        public final Options withLocalIdeographFontFamily(String ... fontFamilies) {
            Intrinsics.checkNotNullParameter((Object)fontFamilies, (String)"fontFamilies");
            this.localIdeographFontFamily = FontUtils.extractValidFont(Arrays.copyOf(fontFamilies, fontFamilies.length));
            return this;
        }

        @Deprecated(message="use {@link  #withApiBaseUri(String)} instead")
        @NotNull
        public final Options withApiBaseUrl(@Nullable String apiBaseUrl) {
            this.apiBaseUri = apiBaseUrl;
            return this;
        }

        @NotNull
        public final Options withApiBaseUri(@Nullable String apiBaseUri) {
            this.apiBaseUri = apiBaseUri;
            return this;
        }

        @Deprecated(message="use {@link #getStyleUri()} instead")
        @Nullable
        public final String getStyleUrl() {
            String string2;
            if (this.builder == null) {
                string2 = null;
            } else {
                Style.Builder builder = this.builder;
                Intrinsics.checkNotNull((Object)builder);
                string2 = builder.getUri();
            }
            return string2;
        }

        @Nullable
        public final String getStyleUri() {
            String string2;
            if (this.builder == null) {
                string2 = null;
            } else {
                Style.Builder builder = this.builder;
                Intrinsics.checkNotNull((Object)builder);
                string2 = builder.getUri();
            }
            return string2;
        }

        @Nullable
        public final String getStyleJson() {
            String string2;
            if (this.builder == null) {
                string2 = null;
            } else {
                Style.Builder builder = this.builder;
                Intrinsics.checkNotNull((Object)builder);
                string2 = builder.getJson();
            }
            return string2;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/maphero/android/snapshotter/MapSnapshotter$SnapshotReadyCallback;", "", "onSnapshotReady", "", "snapshot", "Lorg/maphero/android/snapshotter/MapSnapshot;", "MapHeroAndroid_legacyRelease"})
    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(@NotNull MapSnapshot var1);
    }
}

