/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.google.gson.JsonElement;
import org.maphero.android.style.expressions.Expression;
import org.maphero.android.style.layers.Layer;
import org.maphero.android.style.layers.PropertyValue;
import org.maphero.android.style.layers.TransitionOptions;
import org.maphero.android.utils.ColorUtils;

@UiThread
public class FillExtrusionLayer
extends Layer {
    @Keep
    FillExtrusionLayer(long nativePtr) {
        super(nativePtr);
    }

    public FillExtrusionLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public FillExtrusionLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public FillExtrusionLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    @NonNull
    public FillExtrusionLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<Float> getFillExtrusionOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-opacity", this.nativeGetFillExtrusionOpacity());
    }

    @NonNull
    public TransitionOptions getFillExtrusionOpacityTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionOpacityTransition();
    }

    public void setFillExtrusionOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getFillExtrusionColor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-color", this.nativeGetFillExtrusionColor());
    }

    @ColorInt
    public int getFillExtrusionColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getFillExtrusionColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("fill-extrusion-color was set as a Function");
    }

    @NonNull
    public TransitionOptions getFillExtrusionColorTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionColorTransition();
    }

    public void setFillExtrusionColorTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionColorTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float[]> getFillExtrusionTranslate() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-translate", this.nativeGetFillExtrusionTranslate());
    }

    @NonNull
    public TransitionOptions getFillExtrusionTranslateTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionTranslateTransition();
    }

    public void setFillExtrusionTranslateTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionTranslateTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getFillExtrusionTranslateAnchor() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-translate-anchor", this.nativeGetFillExtrusionTranslateAnchor());
    }

    @NonNull
    public PropertyValue<String> getFillExtrusionPattern() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-pattern", this.nativeGetFillExtrusionPattern());
    }

    @NonNull
    public TransitionOptions getFillExtrusionPatternTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionPatternTransition();
    }

    public void setFillExtrusionPatternTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionPatternTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getFillExtrusionHeight() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-height", this.nativeGetFillExtrusionHeight());
    }

    @NonNull
    public TransitionOptions getFillExtrusionHeightTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionHeightTransition();
    }

    public void setFillExtrusionHeightTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionHeightTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getFillExtrusionBase() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-base", this.nativeGetFillExtrusionBase());
    }

    @NonNull
    public TransitionOptions getFillExtrusionBaseTransition() {
        this.checkThread();
        return this.nativeGetFillExtrusionBaseTransition();
    }

    public void setFillExtrusionBaseTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetFillExtrusionBaseTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Boolean> getFillExtrusionVerticalGradient() {
        this.checkThread();
        return new PropertyValue<Object>("fill-extrusion-vertical-gradient", this.nativeGetFillExtrusionVerticalGradient());
    }

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionOpacityTransition();

    @Keep
    private native void nativeSetFillExtrusionOpacityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionColor();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionColorTransition();

    @Keep
    private native void nativeSetFillExtrusionColorTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionTranslate();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionTranslateTransition();

    @Keep
    private native void nativeSetFillExtrusionTranslateTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionTranslateAnchor();

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionPattern();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionPatternTransition();

    @Keep
    private native void nativeSetFillExtrusionPatternTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionHeight();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionHeightTransition();

    @Keep
    private native void nativeSetFillExtrusionHeightTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionBase();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetFillExtrusionBaseTransition();

    @Keep
    private native void nativeSetFillExtrusionBaseTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetFillExtrusionVerticalGradient();

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

