/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import com.google.gson.JsonElement;
import org.maphero.android.style.expressions.Expression;
import org.maphero.android.style.layers.Layer;
import org.maphero.android.style.layers.PropertyValue;
import org.maphero.android.style.layers.TransitionOptions;
import org.maphero.android.utils.ColorUtils;

@UiThread
public class HeatmapLayer
extends Layer {
    @Keep
    HeatmapLayer(long nativePtr) {
        super(nativePtr);
    }

    public HeatmapLayer(String layerId, String sourceId) {
        this.initialize(layerId, sourceId);
    }

    @Keep
    protected native void initialize(String var1, String var2);

    public void setSourceLayer(String sourceLayer) {
        this.checkThread();
        this.nativeSetSourceLayer(sourceLayer);
    }

    @NonNull
    public HeatmapLayer withSourceLayer(String sourceLayer) {
        this.setSourceLayer(sourceLayer);
        return this;
    }

    @NonNull
    public String getSourceId() {
        this.checkThread();
        return this.nativeGetSourceId();
    }

    @NonNull
    public String getSourceLayer() {
        this.checkThread();
        return this.nativeGetSourceLayer();
    }

    public void setFilter(@NonNull Expression filter) {
        this.checkThread();
        this.nativeSetFilter(filter.toArray());
    }

    @NonNull
    public HeatmapLayer withFilter(@NonNull Expression filter) {
        this.setFilter(filter);
        return this;
    }

    @Nullable
    public Expression getFilter() {
        this.checkThread();
        JsonElement jsonElement = this.nativeGetFilter();
        if (jsonElement != null) {
            return Expression.Converter.convert(jsonElement);
        }
        return null;
    }

    @NonNull
    public HeatmapLayer withProperties(PropertyValue<?> ... properties) {
        this.setProperties(properties);
        return this;
    }

    @NonNull
    public PropertyValue<Float> getHeatmapRadius() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-radius", this.nativeGetHeatmapRadius());
    }

    @NonNull
    public TransitionOptions getHeatmapRadiusTransition() {
        this.checkThread();
        return this.nativeGetHeatmapRadiusTransition();
    }

    public void setHeatmapRadiusTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapRadiusTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<Float> getHeatmapWeight() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-weight", this.nativeGetHeatmapWeight());
    }

    @NonNull
    public PropertyValue<Float> getHeatmapIntensity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-intensity", this.nativeGetHeatmapIntensity());
    }

    @NonNull
    public TransitionOptions getHeatmapIntensityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapIntensityTransition();
    }

    public void setHeatmapIntensityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapIntensityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    public PropertyValue<String> getHeatmapColor() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-color", this.nativeGetHeatmapColor());
    }

    @ColorInt
    public int getHeatmapColorAsInt() {
        this.checkThread();
        PropertyValue<String> value = this.getHeatmapColor();
        if (value.isValue()) {
            return ColorUtils.rgbaToColor(value.getValue());
        }
        throw new RuntimeException("heatmap-color was set as a Function");
    }

    @NonNull
    public PropertyValue<Float> getHeatmapOpacity() {
        this.checkThread();
        return new PropertyValue<Object>("heatmap-opacity", this.nativeGetHeatmapOpacity());
    }

    @NonNull
    public TransitionOptions getHeatmapOpacityTransition() {
        this.checkThread();
        return this.nativeGetHeatmapOpacityTransition();
    }

    public void setHeatmapOpacityTransition(@NonNull TransitionOptions options) {
        this.checkThread();
        this.nativeSetHeatmapOpacityTransition(options.getDuration(), options.getDelay());
    }

    @NonNull
    @Keep
    private native Object nativeGetHeatmapRadius();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetHeatmapRadiusTransition();

    @Keep
    private native void nativeSetHeatmapRadiusTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetHeatmapWeight();

    @NonNull
    @Keep
    private native Object nativeGetHeatmapIntensity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetHeatmapIntensityTransition();

    @Keep
    private native void nativeSetHeatmapIntensityTransition(long var1, long var3);

    @NonNull
    @Keep
    private native Object nativeGetHeatmapColor();

    @NonNull
    @Keep
    private native Object nativeGetHeatmapOpacity();

    @NonNull
    @Keep
    private native TransitionOptions nativeGetHeatmapOpacityTransition();

    @Keep
    private native void nativeSetHeatmapOpacityTransition(long var1, long var3);

    @Override
    @Keep
    protected native void finalize() throws Throwable;
}

