/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.layers;

import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonArray;
import java.util.Arrays;
import org.maphero.android.MapStrictMode;
import org.maphero.android.exceptions.ConversionException;
import org.maphero.android.log.Logger;
import org.maphero.android.style.expressions.Expression;
import org.maphero.android.utils.ColorUtils;

public class PropertyValue<T> {
    private static final String TAG = "Mbgl-PropertyValue";
    @NonNull
    public final String name;
    public final T value;

    public PropertyValue(@NonNull String name, T value) {
        this.name = name;
        this.value = value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean isExpression() {
        return !this.isNull() && (this.value instanceof JsonArray || this.value instanceof Expression);
    }

    @Nullable
    public Expression getExpression() {
        if (this.isExpression()) {
            return this.value instanceof JsonArray ? Expression.Converter.convert((JsonArray)this.value) : (Expression)this.value;
        }
        Logger.w(TAG, String.format("%s not an expression, try PropertyValue#getValue()", this.name));
        return null;
    }

    public boolean isValue() {
        return !this.isNull() && !this.isExpression();
    }

    @Nullable
    public T getValue() {
        if (this.isValue()) {
            return this.value;
        }
        Logger.w(TAG, String.format("%s not a value, try PropertyValue#getExpression()", this.name));
        return null;
    }

    @ColorInt
    @Nullable
    public Integer getColorInt() {
        if (!this.isValue() || !(this.value instanceof String)) {
            Logger.e(TAG, String.format("%s is not a String value and can not be converted to a color it", this.name));
            return null;
        }
        try {
            return ColorUtils.rgbaToColor((String)this.value);
        }
        catch (ConversionException ex) {
            Logger.e(TAG, String.format("%s could not be converted to a Color int: %s", this.name, ex.getMessage()));
            MapStrictMode.strictModeViolation(ex);
            return null;
        }
    }

    public String toString() {
        return String.format("%s: %s", this.name, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyValue that = (PropertyValue)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (this.value != null) {
            if (this.value instanceof Object[]) {
                return Arrays.deepEquals((Object[])this.value, (Object[])that.value);
            }
            return this.value.equals(that.value);
        }
        return that.value == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

