/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.sources;

import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import androidx.annotation.WorkerThread;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.geometry.LatLngBounds;
import org.maphero.android.style.expressions.Expression;
import org.maphero.android.style.sources.CustomGeometrySourceOptions;
import org.maphero.android.style.sources.GeometryTileProvider;
import org.maphero.android.style.sources.Source;
import org.maplibre.geojson.Feature;
import org.maplibre.geojson.FeatureCollection;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 ;2\u00020\u0001:\u00039:;B'\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bJ&\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\b\u0010$\u001a\u0004\u0018\u00010%J\u001d\u0010&\u001a\u00020\u00162\b\u0010'\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010(H\u0083 J$\u0010!\u001a\b\u0012\u0004\u0012\u00020#0)2\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020(\u0018\u00010)H\u0083 \u00a2\u0006\u0002\u0010*J)\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0083 J!\u0010-\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0083 J\u0011\u0010.\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0083 J\t\u0010/\u001a\u00020\u0016H\u0085 J\u0018\u0010\u001e\u001a\u00020\u00162\u0006\u00100\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 H\u0002J \u00101\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0003J\u0010\u00102\u001a\u00020\u00162\u0006\u00103\u001a\u00020\u0012H\u0002J \u00104\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0003J\b\u00105\u001a\u00020\u0016H\u0003J\b\u00106\u001a\u00020\u0016H\u0003J \u00107\u001a\u0002082\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bH\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lorg/maphero/android/style/sources/CustomGeometrySource;", "Lorg/maphero/android/style/sources/Source;", "id", "", "options", "Lorg/maphero/android/style/sources/CustomGeometrySourceOptions;", "provider", "Lorg/maphero/android/style/sources/GeometryTileProvider;", "<init>", "(Ljava/lang/String;Lorg/maphero/android/style/sources/CustomGeometrySourceOptions;Lorg/maphero/android/style/sources/GeometryTileProvider;)V", "(Ljava/lang/String;Lorg/maphero/android/style/sources/GeometryTileProvider;)V", "executorLock", "Ljava/util/concurrent/locks/Lock;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "awaitingTasksMap", "", "Lorg/maphero/android/style/sources/CustomGeometrySource$TileID;", "Lorg/maphero/android/style/sources/CustomGeometrySource$GeometryTileRequest;", "inProgressTasksMap", "Ljava/util/concurrent/atomic/AtomicBoolean;", "invalidateRegion", "", "bounds", "Lorg/maphero/android/geometry/LatLngBounds;", "invalidateTile", "zoomLevel", "", "x", "y", "setTileData", "data", "Lorg/maplibre/geojson/FeatureCollection;", "querySourceFeatures", "", "Lorg/maplibre/geojson/Feature;", "filter", "Lorg/maphero/android/style/expressions/Expression;", "initialize", "sourceId", "", "", "([Ljava/lang/Object;)[Lorg/maplibre/geojson/Feature;", "nativeSetTileData", "z", "nativeInvalidateTile", "nativeInvalidateBounds", "finalize", "tileId", "fetchTile", "executeRequest", "request", "cancelTile", "startThreads", "releaseThreads", "isCancelled", "", "TileID", "GeometryTileRequest", "Companion", "MapHeroAndroid_legacyRelease"})
public final class CustomGeometrySource
extends Source {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final GeometryTileProvider provider;
    @NotNull
    private final Lock executorLock;
    @Nullable
    private ThreadPoolExecutor executor;
    @NotNull
    private final Map<TileID, GeometryTileRequest> awaitingTasksMap;
    @NotNull
    private final Map<TileID, AtomicBoolean> inProgressTasksMap;
    @NotNull
    public static final String THREAD_PREFIX = "CustomGeom";
    public static final int THREAD_POOL_LIMIT = 4;
    @NotNull
    private static final AtomicInteger poolCount = new AtomicInteger();

    @UiThread
    public CustomGeometrySource(@Nullable String id, @Nullable CustomGeometrySourceOptions options, @Nullable GeometryTileProvider provider) {
        this.provider = provider;
        this.executorLock = new ReentrantLock();
        this.awaitingTasksMap = new HashMap();
        this.inProgressTasksMap = new HashMap();
        this.initialize(id, options);
    }

    @UiThread
    public CustomGeometrySource(@Nullable String id, @Nullable GeometryTileProvider provider) {
        this(id, new CustomGeometrySourceOptions(), provider);
    }

    public final void invalidateRegion(@NotNull LatLngBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        this.nativeInvalidateBounds(bounds);
    }

    public final void invalidateTile(int zoomLevel, int x, int y) {
        this.nativeInvalidateTile(zoomLevel, x, y);
    }

    public final void setTileData(int zoomLevel, int x, int y, @NotNull FeatureCollection data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.nativeSetTileData(zoomLevel, x, y, data);
    }

    @NotNull
    public final List<Feature> querySourceFeatures(@Nullable Expression filter) {
        this.checkThread();
        Expression expression = filter;
        Feature[] features = this.querySourceFeatures((Object[])(expression != null ? expression.toArray() : null));
        return CollectionsKt.listOf((Object[])Arrays.copyOf(features, features.length));
    }

    @Keep
    private final native void initialize(String var1, Object var2);

    @Keep
    private final native Feature[] querySourceFeatures(Object[] var1);

    @Keep
    private final native void nativeSetTileData(int var1, int var2, int var3, FeatureCollection var4);

    @Keep
    private final native void nativeInvalidateTile(int var1, int var2, int var3);

    @Keep
    private final native void nativeInvalidateBounds(LatLngBounds var1);

    @Keep
    protected final native void finalize() throws Throwable;

    private final void setTileData(TileID tileId, FeatureCollection data) {
        this.nativeSetTileData(tileId.getZ(), tileId.getX(), tileId.getY(), data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Keep
    private final void fetchTile(int z, int x, int y) {
        AtomicBoolean cancelFlag = new AtomicBoolean(false);
        TileID tileID = new TileID(z, x, y);
        GeometryTileRequest request = new GeometryTileRequest(tileID, this.provider, this.awaitingTasksMap, this.inProgressTasksMap, this, cancelFlag);
        Map<TileID, GeometryTileRequest> map = this.awaitingTasksMap;
        synchronized (map) {
            Object object;
            boolean bl = false;
            Map<TileID, AtomicBoolean> map2 = this.inProgressTasksMap;
            synchronized (map2) {
                Object object2;
                boolean bl2 = false;
                ThreadPoolExecutor threadPoolExecutor = this.executor;
                Intrinsics.checkNotNull((Object)threadPoolExecutor);
                if (threadPoolExecutor.getQueue().contains(request)) {
                    ThreadPoolExecutor threadPoolExecutor2 = this.executor;
                    Intrinsics.checkNotNull((Object)threadPoolExecutor2);
                    threadPoolExecutor2.remove(request);
                    this.executeRequest(request);
                    object2 = Unit.INSTANCE;
                } else if (this.inProgressTasksMap.containsKey(tileID)) {
                    object2 = this.awaitingTasksMap.put(tileID, request);
                } else {
                    this.executeRequest(request);
                    object2 = Unit.INSTANCE;
                }
                object = object2;
            }
            Object object3 = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeRequest(GeometryTileRequest request) {
        this.executorLock.lock();
        try {
            if (this.executor != null) {
                ThreadPoolExecutor threadPoolExecutor = this.executor;
                Intrinsics.checkNotNull((Object)threadPoolExecutor);
                if (!threadPoolExecutor.isShutdown()) {
                    ThreadPoolExecutor threadPoolExecutor2 = this.executor;
                    Intrinsics.checkNotNull((Object)threadPoolExecutor2);
                    threadPoolExecutor2.execute(request);
                }
            }
        }
        finally {
            this.executorLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @Keep
    private final void cancelTile(int z, int x, int y) {
        TileID tileID = new TileID(z, x, y);
        Map<TileID, GeometryTileRequest> map = this.awaitingTasksMap;
        synchronized (map) {
            boolean bl = false;
            Map<TileID, AtomicBoolean> map2 = this.inProgressTasksMap;
            synchronized (map2) {
                boolean bl2 = false;
                AtomicBoolean cancelFlag = this.inProgressTasksMap.get(tileID);
                if (cancelFlag == null || !cancelFlag.compareAndSet(false, true)) {
                    GeometryTileRequest emptyRequest = new GeometryTileRequest(tileID, null, null, null, null, null);
                    ThreadPoolExecutor threadPoolExecutor = this.executor;
                    Intrinsics.checkNotNull((Object)threadPoolExecutor);
                    if (!threadPoolExecutor.getQueue().remove(emptyRequest)) {
                        this.awaitingTasksMap.remove(tileID);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final void startThreads() {
        ThreadPoolExecutor threadPoolExecutor;
        this.executorLock.lock();
        CustomGeometrySource customGeometrySource = this;
        try {
            CustomGeometrySource customGeometrySource2 = customGeometrySource;
            if (this.executor != null) {
                ThreadPoolExecutor threadPoolExecutor2 = this.executor;
                Intrinsics.checkNotNull((Object)threadPoolExecutor2);
                if (!threadPoolExecutor2.isShutdown()) {
                    ThreadPoolExecutor threadPoolExecutor3 = this.executor;
                    Intrinsics.checkNotNull((Object)threadPoolExecutor3);
                    threadPoolExecutor3.shutdownNow();
                }
            }
            threadPoolExecutor = new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new ThreadFactory(){
                private final AtomicInteger threadCount;
                private final int poolId;
                {
                    this.threadCount = new AtomicInteger();
                    this.poolId = CustomGeometrySource.access$getPoolCount$cp().getAndIncrement();
                }

                public final AtomicInteger getThreadCount() {
                    return this.threadCount;
                }

                public final int getPoolId() {
                    return this.poolId;
                }

                public Thread newThread(Runnable runnable) {
                    Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                    Locale locale = Locale.US;
                    String string2 = "%s-%d-%d";
                    Object[] objectArray = new Object[]{"CustomGeom", this.poolId, this.threadCount.getAndIncrement()};
                    String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    return new Thread(runnable, string3);
                }
            });
        }
        finally {
            this.executorLock.unlock();
        }
        customGeometrySource2.executor = threadPoolExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Keep
    private final void releaseThreads() {
        this.executorLock.lock();
        try {
            ThreadPoolExecutor threadPoolExecutor = this.executor;
            Intrinsics.checkNotNull((Object)threadPoolExecutor);
            threadPoolExecutor.shutdownNow();
        }
        finally {
            this.executorLock.unlock();
        }
    }

    @Keep
    private final boolean isCancelled(int z, int x, int y) {
        AtomicBoolean atomicBoolean = this.inProgressTasksMap.get(new TileID(z, x, y));
        Intrinsics.checkNotNull((Object)atomicBoolean);
        return atomicBoolean.get();
    }

    public static final /* synthetic */ AtomicInteger access$getPoolCount$cp() {
        return poolCount;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/maphero/android/style/sources/CustomGeometrySource$Companion;", "", "<init>", "()V", "THREAD_PREFIX", "", "THREAD_POOL_LIMIT", "", "poolCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "MapHeroAndroid_legacyRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0013\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/maphero/android/style/sources/CustomGeometrySource$GeometryTileRequest;", "Ljava/lang/Runnable;", "id", "Lorg/maphero/android/style/sources/CustomGeometrySource$TileID;", "provider", "Lorg/maphero/android/style/sources/GeometryTileProvider;", "awaiting", "", "inProgress", "Ljava/util/concurrent/atomic/AtomicBoolean;", "_source", "Lorg/maphero/android/style/sources/CustomGeometrySource;", "_cancelled", "<init>", "(Lorg/maphero/android/style/sources/CustomGeometrySource$TileID;Lorg/maphero/android/style/sources/GeometryTileProvider;Ljava/util/Map;Ljava/util/Map;Lorg/maphero/android/style/sources/CustomGeometrySource;Ljava/util/concurrent/atomic/AtomicBoolean;)V", "sourceRef", "Ljava/lang/ref/WeakReference;", "cancelled", "run", "", "isCancelled", "", "equals", "other", "", "MapHeroAndroid_legacyRelease"})
    public static final class GeometryTileRequest
    implements Runnable {
        @NotNull
        private final TileID id;
        @Nullable
        private final GeometryTileProvider provider;
        @Nullable
        private final Map<TileID, GeometryTileRequest> awaiting;
        @Nullable
        private final Map<TileID, AtomicBoolean> inProgress;
        @NotNull
        private final WeakReference<CustomGeometrySource> sourceRef;
        @Nullable
        private final AtomicBoolean cancelled;

        public GeometryTileRequest(@NotNull TileID id, @Nullable GeometryTileProvider provider, @Nullable Map<TileID, GeometryTileRequest> awaiting, @Nullable Map<TileID, AtomicBoolean> inProgress, @Nullable CustomGeometrySource _source, @Nullable AtomicBoolean _cancelled) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.provider = provider;
            this.awaiting = awaiting;
            this.inProgress = inProgress;
            this.sourceRef = new WeakReference<CustomGeometrySource>(_source);
            this.cancelled = _cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<TileID, AtomicBoolean> map;
            Map<TileID, GeometryTileRequest> map2 = this.awaiting;
            Intrinsics.checkNotNull(map2);
            Map<TileID, GeometryTileRequest> map3 = map2;
            synchronized (map3) {
                AtomicBoolean $i$a$-synchronized-CustomGeometrySource$GeometryTileRequest$run$1$2;
                boolean bl = false;
                Map<TileID, AtomicBoolean> map4 = this.inProgress;
                Intrinsics.checkNotNull(map4);
                map = map4;
                synchronized (map) {
                    boolean bl2 = false;
                    if (this.inProgress.containsKey(this.id)) {
                        if (!this.awaiting.containsKey(this.id)) {
                            this.awaiting.put(this.id, this);
                        }
                        return;
                    }
                    $i$a$-synchronized-CustomGeometrySource$GeometryTileRequest$run$1$2 = this.inProgress.put(this.id, this.cancelled);
                }
                AtomicBoolean $i$a$-synchronized-CustomGeometrySource$GeometryTileRequest$run$3 = $i$a$-synchronized-CustomGeometrySource$GeometryTileRequest$run$1$2;
            }
            if (!this.isCancelled()) {
                GeometryTileProvider geometryTileProvider = this.provider;
                Intrinsics.checkNotNull((Object)geometryTileProvider);
                FeatureCollection data = geometryTileProvider.getFeaturesForBounds(LatLngBounds.Companion.from(this.id.getZ(), this.id.getX(), this.id.getY()), this.id.getZ());
                CustomGeometrySource source = (CustomGeometrySource)this.sourceRef.get();
                if (!this.isCancelled() && source != null) {
                    source.setTileData(this.id, data);
                }
            }
            map3 = this.awaiting;
            synchronized (map3) {
                boolean bl = false;
                Map<TileID, AtomicBoolean> map5 = this.inProgress;
                Intrinsics.checkNotNull(map5);
                map = map5;
                synchronized (map) {
                    boolean bl3 = false;
                    this.inProgress.remove(this.id);
                    if (this.awaiting.containsKey(this.id)) {
                        GeometryTileRequest queuedRequest = this.awaiting.get(this.id);
                        CustomGeometrySource source = (CustomGeometrySource)this.sourceRef.get();
                        if (source != null && queuedRequest != null) {
                            ThreadPoolExecutor threadPoolExecutor = source.executor;
                            Intrinsics.checkNotNull((Object)threadPoolExecutor);
                            threadPoolExecutor.execute(queuedRequest);
                        }
                        this.awaiting.remove(this.id);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        private final boolean isCancelled() {
            AtomicBoolean atomicBoolean = this.cancelled;
            Intrinsics.checkNotNull((Object)atomicBoolean);
            return atomicBoolean.get();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            GeometryTileRequest request = (GeometryTileRequest)other;
            return Intrinsics.areEqual((Object)this.id, (Object)request.id);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/maphero/android/style/sources/CustomGeometrySource$TileID;", "", "z", "", "x", "y", "<init>", "(III)V", "getZ", "()I", "setZ", "(I)V", "getX", "setX", "getY", "setY", "hashCode", "equals", "", "other", "MapHeroAndroid_legacyRelease"})
    public static final class TileID {
        private int z;
        private int x;
        private int y;

        public TileID(int z, int x, int y) {
            this.z = z;
            this.x = x;
            this.y = y;
        }

        public final int getZ() {
            return this.z;
        }

        public final void setZ(int n) {
            this.z = n;
        }

        public final int getX() {
            return this.x;
        }

        public final void setX(int n) {
            this.x = n;
        }

        public final int getY() {
            return this.y;
        }

        public final void setY(int n) {
            this.y = n;
        }

        public int hashCode() {
            int[] nArray = new int[]{this.z, this.x, this.y};
            return Arrays.hashCode(nArray);
        }

        public boolean equals(@Nullable Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            if (other instanceof TileID) {
                return this.z == ((TileID)other).z && this.x == ((TileID)other).x && this.y == ((TileID)other).y;
            }
            return false;
        }
    }
}

