/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.style.sources;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.Keep;
import androidx.annotation.UiThread;
import java.net.URI;
import java.net.URL;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.maphero.android.MapHero;
import org.maphero.android.geometry.LatLngQuad;
import org.maphero.android.style.sources.Source;
import org.maphero.android.utils.BitmapUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0017\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0004\u0010\fB%\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0004\u0010\u000fB%\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0004\u0010\u0012B'\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0001\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0004\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0007J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0019\u001a\u00020\u00172\b\b\u0001\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001d\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\tJ\u001d\u0010\u001f\u001a\u00020\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00072\b\u0010!\u001a\u0004\u0018\u00010\tH\u0085 J\u0013\u0010\"\u001a\u00020\u00172\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0085 J\t\u0010#\u001a\u00020\u0007H\u0085 J\u0013\u0010$\u001a\u00020\u00172\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0085 J\u0013\u0010%\u001a\u00020\u00172\b\u0010\u001e\u001a\u0004\u0018\u00010\tH\u0085 J\t\u0010&\u001a\u00020\u0017H\u0085 R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\r\u001a\u0004\u0018\u00010\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006'"}, d2={"Lorg/maphero/android/style/sources/ImageSource;", "Lorg/maphero/android/style/sources/Source;", "nativePtr", "", "<init>", "(J)V", "id", "", "coordinates", "Lorg/maphero/android/geometry/LatLngQuad;", "url", "Ljava/net/URL;", "(Ljava/lang/String;Lorg/maphero/android/geometry/LatLngQuad;Ljava/net/URL;)V", "uri", "Ljava/net/URI;", "(Ljava/lang/String;Lorg/maphero/android/geometry/LatLngQuad;Ljava/net/URI;)V", "bitmap", "Landroid/graphics/Bitmap;", "(Ljava/lang/String;Lorg/maphero/android/geometry/LatLngQuad;Landroid/graphics/Bitmap;)V", "resourceId", "", "(Ljava/lang/String;Lorg/maphero/android/geometry/LatLngQuad;I)V", "setUrl", "", "setUri", "setImage", "getUrl", "()Ljava/lang/String;", "getUri", "setCoordinates", "latLngQuad", "initialize", "layerId", "payload", "nativeSetUrl", "nativeGetUrl", "nativeSetImage", "nativeSetCoordinates", "finalize", "MapHeroAndroid_legacyRelease"})
@UiThread
public final class ImageSource
extends Source {
    @Keep
    public ImageSource(long nativePtr) {
        super(nativePtr);
    }

    @Deprecated(message="use {@link ImageSource#ImageSource(String, LatLngQuad, URI)} instead")
    public ImageSource(@Nullable String id, @Nullable LatLngQuad coordinates, @NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.initialize(id, coordinates);
        this.setUrl(url);
    }

    public ImageSource(@Nullable String id, @Nullable LatLngQuad coordinates, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.initialize(id, coordinates);
        this.setUri(uri);
    }

    public ImageSource(@Nullable String id, @Nullable LatLngQuad coordinates, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.initialize(id, coordinates);
        this.setImage(bitmap);
    }

    public ImageSource(@Nullable String id, @Nullable LatLngQuad coordinates, @DrawableRes int resourceId) {
        this.initialize(id, coordinates);
        this.setImage(resourceId);
    }

    @Deprecated(message="use {@link #setUri(URI)} instead")
    public final void setUrl(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.setUrl(url.toExternalForm());
    }

    @Deprecated(message="use {@link #setUri(String)} instead")
    public final void setUrl(@Nullable String url) {
        this.checkThread();
        this.nativeSetUrl(url);
    }

    public final void setUri(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.checkThread();
        this.nativeSetUrl(uri.toString());
    }

    public final void setUri(@Nullable String uri) {
        this.checkThread();
        this.nativeSetUrl(uri);
    }

    public final void setImage(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        this.checkThread();
        this.nativeSetImage(bitmap);
    }

    public final void setImage(@DrawableRes int resourceId) throws IllegalArgumentException {
        this.checkThread();
        Context context = MapHero.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getApplicationContext(...)");
        Context context2 = context;
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(context2, resourceId);
        if (!(drawable2 instanceof BitmapDrawable)) {
            throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
        }
        this.nativeSetImage(((BitmapDrawable)drawable2).getBitmap());
    }

    @Deprecated(message="use {@link #getUri()} instead")
    @Nullable
    public final String getUrl() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    @Nullable
    public final String getUri() {
        this.checkThread();
        return this.nativeGetUrl();
    }

    public final void setCoordinates(@Nullable LatLngQuad latLngQuad) {
        this.checkThread();
        this.nativeSetCoordinates(latLngQuad);
    }

    @Keep
    protected final native void initialize(@Nullable String var1, @Nullable LatLngQuad var2);

    @Keep
    protected final native void nativeSetUrl(@Nullable String var1);

    @Keep
    @NotNull
    protected final native String nativeGetUrl();

    @Keep
    protected final native void nativeSetImage(@Nullable Bitmap var1);

    @Keep
    protected final native void nativeSetCoordinates(@Nullable LatLngQuad var1);

    @Keep
    protected final native void finalize() throws Throwable;
}

