/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.annotations;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.maphero.android.MapStrictMode;
import org.maphero.android.R;
import org.maphero.android.annotations.Icon;
import org.maphero.android.exceptions.TooManyIconsException;
import org.maphero.android.utils.BitmapUtils;

public final class IconFactory {
    private static final String ICON_ID_PREFIX = "com.mapbox.icons.icon_";
    private Context context;
    @SuppressLint(value={"StaticFieldLeak"})
    private static IconFactory instance;
    private Icon defaultMarker;
    private BitmapFactory.Options options;
    private int nextId = 0;

    public static synchronized IconFactory getInstance(@NonNull Context context) {
        if (instance == null) {
            instance = new IconFactory(context.getApplicationContext());
        }
        return instance;
    }

    private IconFactory(@NonNull Context context) {
        this.context = context;
        DisplayMetrics realMetrics = null;
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 17) {
            realMetrics = new DisplayMetrics();
            wm.getDefaultDisplay().getRealMetrics(realMetrics);
        }
        wm.getDefaultDisplay().getMetrics(metrics);
        this.options = new BitmapFactory.Options();
        this.options.inScaled = true;
        this.options.inDensity = 160;
        this.options.inTargetDensity = metrics.densityDpi;
        if (realMetrics != null) {
            this.options.inScreenDensity = realMetrics.densityDpi;
        }
    }

    public Icon fromBitmap(@NonNull Bitmap bitmap) {
        if (this.nextId < 0) {
            throw new TooManyIconsException();
        }
        String id = ICON_ID_PREFIX + ++this.nextId;
        return new Icon(id, bitmap);
    }

    public Icon fromResource(@DrawableRes int resourceId) {
        Drawable drawable2 = BitmapUtils.getDrawableFromRes(this.context, resourceId);
        if (drawable2 instanceof BitmapDrawable) {
            BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
            return this.fromBitmap(bitmapDrawable.getBitmap());
        }
        throw new IllegalArgumentException("Failed to decode image. The resource provided must be a Bitmap.");
    }

    public Icon defaultMarker() {
        if (this.defaultMarker == null) {
            this.defaultMarker = this.fromResource(R.drawable.maphero_marker_icon_default);
        }
        return this.defaultMarker;
    }

    private Icon fromInputStream(@NonNull InputStream is) {
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)this.options);
        return this.fromBitmap(bitmap);
    }

    public Icon fromAsset(@NonNull String assetName) {
        InputStream is;
        try {
            is = this.context.getAssets().open(assetName);
        }
        catch (IOException ioException) {
            MapStrictMode.strictModeViolation(ioException);
            return null;
        }
        return this.fromInputStream(is);
    }

    public Icon fromPath(@NonNull String absolutePath) {
        Bitmap bitmap = BitmapFactory.decodeFile((String)absolutePath, (BitmapFactory.Options)this.options);
        return this.fromBitmap(bitmap);
    }

    public Icon fromFile(@NonNull String fileName) {
        FileInputStream is;
        try {
            is = this.context.openFileInput(fileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MapStrictMode.strictModeViolation(fileNotFoundException);
            return null;
        }
        return this.fromInputStream(is);
    }

    public static Icon recreate(@NonNull String iconId, @NonNull Bitmap bitmap) {
        return new Icon(iconId, bitmap);
    }
}

