/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.attribution;

import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;

public class Attribution {
    private static final String OPENSTREETMAP = "OpenStreetMap";
    private static final String OPENSTREETMAP_ABBR = "OSM";
    static final String MAPBOX_URL = "https://www.mapbox.com/about/maps/";
    static final List<String> IMPROVE_MAP_URLS = new ArrayList<String>();
    private String title;
    private String url;

    Attribution(String title, String url) {
        this.title = title;
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTitleAbbreviated() {
        if (this.title.equals(OPENSTREETMAP)) {
            return OPENSTREETMAP_ABBR;
        }
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribution that = (Attribution)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.url != null ? this.url.equals(that.url) : that.url == null;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    static {
        IMPROVE_MAP_URLS.add("https://www.mapbox.com/feedback/");
        IMPROVE_MAP_URLS.add("https://www.mapbox.com/map-feedback/");
        IMPROVE_MAP_URLS.add("https://apps.mapbox.com/feedback/");
    }
}

