/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.attribution;

import android.graphics.Bitmap;
import android.graphics.PointF;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.maphero.android.attribution.AttributionLayout;

public class AttributionMeasure {
    private Bitmap logo;
    private Bitmap logoSmall;
    private Bitmap snapshot;
    private TextView textView;
    private TextView textViewShort;
    private float margin;
    private boolean shorterText;

    AttributionMeasure(Bitmap snapshot, Bitmap logo, Bitmap logoSmall, TextView tv, TextView tvShort, float margin) {
        this.snapshot = snapshot;
        this.logo = logo;
        this.logoSmall = logoSmall;
        this.textView = tv;
        this.textViewShort = tvShort;
        this.margin = margin;
    }

    @Nullable
    public AttributionLayout measure() {
        Chain chain = new Chain(new FullLogoLongTextCommand(), new FullLogoShortTextCommand(), new SmallLogoLongTextCommand(), new SmallLogoShortTextCommand(), new LongTextCommand(), new ShortTextCommand(), new NoTextCommand());
        AttributionLayout attributionLayout = chain.start(this);
        this.shorterText = attributionLayout.isShortText();
        return attributionLayout;
    }

    private static PointF calculateAnchor(Bitmap snapshot, TextView textView, float margin) {
        return new PointF((float)(snapshot.getWidth() - textView.getMeasuredWidth()) - margin, (float)snapshot.getHeight() - margin - (float)textView.getMeasuredHeight());
    }

    public TextView getTextView() {
        return this.shorterText ? this.textViewShort : this.textView;
    }

    private float getTextViewContainerWidth() {
        return (float)this.textView.getMeasuredWidth() + this.margin;
    }

    private float getLogoContainerWidth() {
        return (float)this.logo.getWidth() + 2.0f * this.margin;
    }

    private float getTextViewShortContainerWidth() {
        return (float)this.textViewShort.getMeasuredWidth() + this.margin;
    }

    private float getLogoSmallContainerWidth() {
        return (float)this.logoSmall.getWidth() + 2.0f * this.margin;
    }

    private float getMaxSize() {
        return this.snapshot.getWidth() * 8 / 10;
    }

    private float getMaxSizeShort() {
        return this.snapshot.getWidth();
    }

    private class Chain {
        public List<Command> commands;

        Chain(Command ... commands) {
            this.commands = Arrays.asList(commands);
        }

        @Nullable
        public AttributionLayout start(AttributionMeasure measure) {
            Command command;
            AttributionLayout attributionLayout = null;
            Iterator<Command> iterator = this.commands.iterator();
            while (iterator.hasNext() && (attributionLayout = (command = iterator.next()).execute(measure)) == null) {
            }
            return attributionLayout;
        }
    }

    public static interface Command {
        @Nullable
        public AttributionLayout execute(AttributionMeasure var1);
    }

    private static class FullLogoLongTextCommand
    implements Command {
        private FullLogoLongTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin);
                return new AttributionLayout(measure.logo, anchor, false);
            }
            return null;
        }
    }

    private static class FullLogoShortTextCommand
    implements Command {
        private FullLogoShortTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewShortContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textViewShort, measure.margin);
                return new AttributionLayout(measure.logo, anchor, true);
            }
            return null;
        }
    }

    private static class SmallLogoLongTextCommand
    implements Command {
        private SmallLogoLongTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoSmallContainerWidth() + measure.getTextViewContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin);
                return new AttributionLayout(measure.logoSmall, anchor, false);
            }
            return null;
        }
    }

    private static class SmallLogoShortTextCommand
    implements Command {
        private SmallLogoShortTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getLogoContainerWidth() + measure.getTextViewShortContainerWidth();
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textViewShort, measure.margin);
                return new AttributionLayout(measure.logoSmall, anchor, true);
            }
            return null;
        }
    }

    private static class LongTextCommand
    implements Command {
        private LongTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getTextViewContainerWidth() + measure.margin;
            boolean bl = fitBounds = width <= measure.getMaxSize();
            if (fitBounds) {
                return new AttributionLayout(null, AttributionMeasure.calculateAnchor(measure.snapshot, measure.textView, measure.margin), false);
            }
            return null;
        }
    }

    private static class ShortTextCommand
    implements Command {
        private ShortTextCommand() {
        }

        @Override
        @Nullable
        public AttributionLayout execute(@NonNull AttributionMeasure measure) {
            boolean fitBounds;
            float width = measure.getTextViewShortContainerWidth() + measure.margin;
            boolean bl = fitBounds = width <= measure.getMaxSizeShort();
            if (fitBounds) {
                PointF anchor = AttributionMeasure.calculateAnchor(measure.snapshot, measure.textViewShort, measure.margin);
                return new AttributionLayout(null, anchor, true);
            }
            return null;
        }
    }

    private static class NoTextCommand
    implements Command {
        private NoTextCommand() {
        }

        @Override
        @NonNull
        public AttributionLayout execute(AttributionMeasure measure) {
            return new AttributionLayout(null, null, false);
        }
    }

    public static class Builder {
        private Bitmap snapshot;
        private Bitmap logo;
        private Bitmap logoSmall;
        private TextView textView;
        private TextView textViewShort;
        private float marginPadding;

        @NonNull
        public Builder setSnapshot(Bitmap snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        @NonNull
        public Builder setLogo(Bitmap logo) {
            this.logo = logo;
            return this;
        }

        @NonNull
        public Builder setLogoSmall(Bitmap logoSmall) {
            this.logoSmall = logoSmall;
            return this;
        }

        @NonNull
        public Builder setTextView(TextView textView) {
            this.textView = textView;
            return this;
        }

        @NonNull
        public Builder setTextViewShort(TextView textViewShort) {
            this.textViewShort = textViewShort;
            return this;
        }

        @NonNull
        public Builder setMarginPadding(float marginPadding) {
            this.marginPadding = marginPadding;
            return this;
        }

        @NonNull
        public AttributionMeasure build() {
            return new AttributionMeasure(this.snapshot, this.logo, this.logoSmall, this.textView, this.textViewShort, this.marginPadding);
        }
    }
}

