/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.location.Location;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.camera.CameraUpdate;
import org.maphero.android.camera.CameraUpdateFactory;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.location.AnimatorListenerHolder;
import org.maphero.android.location.LocationComponentOptions;
import org.maphero.android.location.MapHeroAnimator;
import org.maphero.android.location.OnCameraMoveInvalidateListener;
import org.maphero.android.location.OnCameraTrackingChangedListener;
import org.maphero.android.location.OnLocationCameraTransitionListener;
import org.maphero.android.location.Utils;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.Transform;
import org.maplibre.android.gestures.AndroidGesturesManager;
import org.maplibre.android.gestures.MoveGestureDetector;
import org.maplibre.android.gestures.RotateGestureDetector;

final class LocationCameraController {
    private int cameraMode;
    private final MapHeroMap mapHeroMap;
    private final Transform transform;
    private final OnCameraTrackingChangedListener internalCameraTrackingChangedListener;
    private LocationComponentOptions options;
    private final MoveGestureDetector moveGestureDetector;
    private final OnCameraMoveInvalidateListener onCameraMoveInvalidateListener;
    private final AndroidGesturesManager initialGesturesManager;
    private final AndroidGesturesManager internalGesturesManager;
    private boolean isTransitioning;
    private LatLng lastLocation;
    private boolean isEnabled;
    private final MapHeroAnimator.AnimationsValueChangeListener<LatLng> latLngValueListener = new MapHeroAnimator.AnimationsValueChangeListener<LatLng>(){

        @Override
        public void onNewAnimationValue(LatLng value) {
            LocationCameraController.this.setLatLng(value);
        }
    };
    private final MapHeroAnimator.AnimationsValueChangeListener<Float> gpsBearingValueListener = new MapHeroAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            boolean trackingNorth;
            boolean bl = trackingNorth = LocationCameraController.this.cameraMode == 36 && LocationCameraController.this.mapHeroMap.getCameraPosition().bearing == 0.0;
            if (!trackingNorth) {
                LocationCameraController.this.setBearing(value.floatValue());
            }
        }
    };
    private final MapHeroAnimator.AnimationsValueChangeListener<Float> compassBearingValueListener = new MapHeroAnimator.AnimationsValueChangeListener<Float>(){

        @Override
        public void onNewAnimationValue(Float value) {
            if (LocationCameraController.this.cameraMode == 32 || LocationCameraController.this.cameraMode == 16) {
                LocationCameraController.this.setBearing(value.floatValue());
            }
        }
    };
    private final MapHeroAnimator.AnimationsValueChangeListener<Float> zoomValueListener = value -> this.setZoom(value.floatValue());
    private final MapHeroAnimator.AnimationsValueChangeListener<double[]> paddingValueListener = value -> this.setPadding((double[])value);
    private final MapHeroAnimator.AnimationsValueChangeListener<Float> tiltValueListener = value -> this.setTilt(value.floatValue());
    private MapHeroMap.OnCameraMoveListener onCameraMoveListener = new MapHeroMap.OnCameraMoveListener(){

        @Override
        public void onCameraMove() {
            if (LocationCameraController.this.isLocationTracking() && LocationCameraController.this.lastLocation != null && LocationCameraController.this.options.trackingGesturesManagement()) {
                PointF focalPoint = LocationCameraController.this.mapHeroMap.getProjection().toScreenLocation(LocationCameraController.this.lastLocation);
                LocationCameraController.this.mapHeroMap.getUiSettings().setFocalPoint(focalPoint);
            }
        }
    };
    @NonNull
    @VisibleForTesting
    MapHeroMap.OnMoveListener onMoveListener = new MapHeroMap.OnMoveListener(){
        private boolean interrupt;

        @Override
        public void onMoveBegin(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && LocationCameraController.this.isLocationTracking()) {
                if (detector.getPointersCount() > 1) {
                    this.applyMultiFingerThresholdArea(detector);
                    this.applyMultiFingerMoveThreshold(detector);
                } else {
                    this.applySingleFingerMoveThreshold(detector);
                }
            } else {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        private void applyMultiFingerThresholdArea(@NonNull MoveGestureDetector detector) {
            RectF currentRect = detector.getMoveThresholdRect();
            if (currentRect != null && !currentRect.equals((Object)LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea())) {
                detector.setMoveThresholdRect(LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea());
                this.interrupt = true;
            } else if (currentRect == null && LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea() != null) {
                detector.setMoveThresholdRect(LocationCameraController.this.options.trackingMultiFingerProtectedMoveArea());
                this.interrupt = true;
            }
        }

        private void applyMultiFingerMoveThreshold(@NonNull MoveGestureDetector detector) {
            if (detector.getMoveThreshold() != LocationCameraController.this.options.trackingMultiFingerMoveThreshold()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingMultiFingerMoveThreshold());
                this.interrupt = true;
            }
        }

        private void applySingleFingerMoveThreshold(@NonNull MoveGestureDetector detector) {
            if (detector.getMoveThreshold() != LocationCameraController.this.options.trackingInitialMoveThreshold()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
                this.interrupt = true;
            }
        }

        @Override
        public void onMove(@NonNull MoveGestureDetector detector) {
            if (this.interrupt) {
                detector.interrupt();
                return;
            }
            if (LocationCameraController.this.isLocationTracking() || LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
                detector.interrupt();
            }
        }

        @Override
        public void onMoveEnd(@NonNull MoveGestureDetector detector) {
            if (LocationCameraController.this.options.trackingGesturesManagement() && !this.interrupt && LocationCameraController.this.isLocationTracking()) {
                detector.setMoveThreshold(LocationCameraController.this.options.trackingInitialMoveThreshold());
                detector.setMoveThresholdRect(null);
            }
            this.interrupt = false;
        }
    };
    @NonNull
    private MapHeroMap.OnRotateListener onRotateListener = new MapHeroMap.OnRotateListener(){

        @Override
        public void onRotateBegin(@NonNull RotateGestureDetector detector) {
            if (LocationCameraController.this.isBearingTracking()) {
                LocationCameraController.this.setCameraMode(8);
            }
        }

        @Override
        public void onRotate(@NonNull RotateGestureDetector detector) {
        }

        @Override
        public void onRotateEnd(@NonNull RotateGestureDetector detector) {
        }
    };
    @NonNull
    private MapHeroMap.OnFlingListener onFlingListener = new MapHeroMap.OnFlingListener(){

        @Override
        public void onFling() {
            LocationCameraController.this.setCameraMode(8);
        }
    };

    LocationCameraController(Context context, MapHeroMap mapHeroMap, Transform transform, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, @NonNull LocationComponentOptions options, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener) {
        this.mapHeroMap = mapHeroMap;
        this.transform = transform;
        this.initialGesturesManager = mapHeroMap.getGesturesManager();
        this.internalGesturesManager = new LocationGesturesManager(context);
        this.moveGestureDetector = this.internalGesturesManager.getMoveGestureDetector();
        mapHeroMap.addOnRotateListener(this.onRotateListener);
        mapHeroMap.addOnFlingListener(this.onFlingListener);
        mapHeroMap.addOnMoveListener(this.onMoveListener);
        mapHeroMap.addOnCameraMoveListener(this.onCameraMoveListener);
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.initializeOptions(options);
    }

    LocationCameraController(MapHeroMap mapHeroMap, Transform transform, MoveGestureDetector moveGestureDetector, OnCameraTrackingChangedListener internalCameraTrackingChangedListener, OnCameraMoveInvalidateListener onCameraMoveInvalidateListener, AndroidGesturesManager initialGesturesManager, AndroidGesturesManager internalGesturesManager) {
        this.mapHeroMap = mapHeroMap;
        mapHeroMap.addOnCameraMoveListener(this.onCameraMoveListener);
        this.transform = transform;
        this.moveGestureDetector = moveGestureDetector;
        this.internalCameraTrackingChangedListener = internalCameraTrackingChangedListener;
        this.onCameraMoveInvalidateListener = onCameraMoveInvalidateListener;
        this.internalGesturesManager = internalGesturesManager;
        this.initialGesturesManager = initialGesturesManager;
    }

    void initializeOptions(LocationComponentOptions options) {
        this.options = options;
        if (options.trackingGesturesManagement()) {
            if (this.mapHeroMap.getGesturesManager() != this.internalGesturesManager) {
                this.mapHeroMap.setGesturesManager(this.internalGesturesManager, true, true);
            }
            this.adjustGesturesThresholds();
        } else if (this.mapHeroMap.getGesturesManager() != this.initialGesturesManager) {
            this.mapHeroMap.setGesturesManager(this.initialGesturesManager, true, true);
        }
    }

    void setCameraMode(int cameraMode) {
        this.setCameraMode(cameraMode, null, 750L, null, null, null, null);
    }

    void setCameraMode(int cameraMode, @Nullable Location lastLocation, long transitionDuration, @Nullable Double zoom, @Nullable Double bearing, @Nullable Double tilt, @Nullable OnLocationCameraTransitionListener internalTransitionListener) {
        if (this.cameraMode == cameraMode) {
            if (internalTransitionListener != null) {
                internalTransitionListener.onLocationCameraTransitionFinished(cameraMode);
            }
            return;
        }
        boolean wasTracking = this.isLocationTracking();
        this.cameraMode = cameraMode;
        if (cameraMode != 8) {
            this.mapHeroMap.cancelTransitions();
        }
        this.adjustGesturesThresholds();
        this.notifyCameraTrackingChangeListener(wasTracking);
        this.transitionToCurrentLocation(wasTracking, lastLocation, transitionDuration, zoom, bearing, tilt, internalTransitionListener);
    }

    private void transitionToCurrentLocation(boolean wasTracking, Location lastLocation, long transitionDuration, Double zoom, Double bearing, Double tilt, final OnLocationCameraTransitionListener internalTransitionListener) {
        if (!wasTracking && this.isLocationTracking() && lastLocation != null && this.isEnabled) {
            this.isTransitioning = true;
            LatLng target = new LatLng(lastLocation);
            CameraPosition.Builder builder = new CameraPosition.Builder().target(target);
            if (zoom != null) {
                builder.zoom(zoom);
            }
            if (tilt != null) {
                builder.tilt(tilt);
            }
            if (bearing != null) {
                builder.bearing(bearing);
            } else if (this.isLocationBearingTracking()) {
                builder.bearing(this.cameraMode == 36 ? 0.0 : (double)lastLocation.getBearing());
            }
            CameraUpdate update = CameraUpdateFactory.newCameraPosition(builder.build());
            MapHeroMap.CancelableCallback callback = new MapHeroMap.CancelableCallback(){

                @Override
                public void onCancel() {
                    LocationCameraController.this.isTransitioning = false;
                    if (internalTransitionListener != null) {
                        internalTransitionListener.onLocationCameraTransitionCanceled(LocationCameraController.this.cameraMode);
                    }
                }

                @Override
                public void onFinish() {
                    LocationCameraController.this.isTransitioning = false;
                    if (internalTransitionListener != null) {
                        internalTransitionListener.onLocationCameraTransitionFinished(LocationCameraController.this.cameraMode);
                    }
                }
            };
            CameraPosition currentPosition = this.mapHeroMap.getCameraPosition();
            if (Utils.immediateAnimation(this.mapHeroMap.getProjection(), currentPosition.target, target)) {
                this.transform.moveCamera(this.mapHeroMap, update, callback);
            } else {
                this.transform.animateCamera(this.mapHeroMap, update, (int)transitionDuration, callback);
            }
        } else if (internalTransitionListener != null) {
            internalTransitionListener.onLocationCameraTransitionFinished(this.cameraMode);
        }
    }

    int getCameraMode() {
        return this.cameraMode;
    }

    private void setBearing(float bearing) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapHeroMap, CameraUpdateFactory.bearingTo(bearing), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setLatLng(@NonNull LatLng latLng) {
        if (this.isTransitioning) {
            return;
        }
        this.lastLocation = latLng;
        this.transform.moveCamera(this.mapHeroMap, CameraUpdateFactory.newLatLng(latLng), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setZoom(float zoom) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapHeroMap, CameraUpdateFactory.zoomTo(zoom), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setPadding(double[] padding) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapHeroMap, CameraUpdateFactory.paddingTo(padding), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    private void setTilt(float tilt) {
        if (this.isTransitioning) {
            return;
        }
        this.transform.moveCamera(this.mapHeroMap, CameraUpdateFactory.tiltTo(tilt), null);
        this.onCameraMoveInvalidateListener.onInvalidateCameraMove();
    }

    Set<AnimatorListenerHolder> getAnimationListeners() {
        HashSet<AnimatorListenerHolder> holders = new HashSet<AnimatorListenerHolder>();
        if (this.isLocationTracking()) {
            holders.add(new AnimatorListenerHolder(1, this.latLngValueListener));
        }
        if (this.isLocationBearingTracking()) {
            holders.add(new AnimatorListenerHolder(4, this.gpsBearingValueListener));
        }
        if (this.isConsumingCompass()) {
            holders.add(new AnimatorListenerHolder(5, this.compassBearingValueListener));
        }
        holders.add(new AnimatorListenerHolder(7, this.zoomValueListener));
        holders.add(new AnimatorListenerHolder(8, this.tiltValueListener));
        holders.add(new AnimatorListenerHolder(10, this.paddingValueListener));
        return holders;
    }

    boolean isTransitioning() {
        return this.isTransitioning;
    }

    private void adjustGesturesThresholds() {
        if (this.options.trackingGesturesManagement()) {
            if (this.isLocationTracking()) {
                this.moveGestureDetector.setMoveThreshold(this.options.trackingInitialMoveThreshold());
            } else {
                this.moveGestureDetector.setMoveThreshold(0.0f);
                this.moveGestureDetector.setMoveThresholdRect(null);
            }
        }
    }

    boolean isConsumingCompass() {
        return this.cameraMode == 32 || this.cameraMode == 16;
    }

    void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    private boolean isLocationTracking() {
        return this.cameraMode == 24 || this.cameraMode == 32 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isBearingTracking() {
        return this.cameraMode == 16 || this.cameraMode == 32 || this.cameraMode == 22 || this.cameraMode == 34 || this.cameraMode == 36;
    }

    private boolean isLocationBearingTracking() {
        return this.cameraMode == 34 || this.cameraMode == 36 || this.cameraMode == 22;
    }

    private void notifyCameraTrackingChangeListener(boolean wasTracking) {
        this.internalCameraTrackingChangedListener.onCameraTrackingChanged(this.cameraMode);
        if (wasTracking && !this.isLocationTracking()) {
            this.mapHeroMap.getUiSettings().setFocalPoint(null);
            this.internalCameraTrackingChangedListener.onCameraTrackingDismissed();
        }
    }

    private class LocationGesturesManager
    extends AndroidGesturesManager {
        LocationGesturesManager(Context context) {
            super(context);
        }

        public boolean onTouchEvent(@Nullable MotionEvent motionEvent) {
            int action;
            if (motionEvent != null && (action = motionEvent.getActionMasked()) == 1) {
                LocationCameraController.this.adjustGesturesThresholds();
            }
            return super.onTouchEvent(motionEvent);
        }
    }
}

