/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.SensorManager;
import android.location.Location;
import android.os.Looper;
import android.os.SystemClock;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.maphero.android.R;
import org.maphero.android.camera.CameraPosition;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.location.AnimatorListenerHolder;
import org.maphero.android.location.CompassEngine;
import org.maphero.android.location.CompassListener;
import org.maphero.android.location.LayerBitmapProvider;
import org.maphero.android.location.LayerFeatureProvider;
import org.maphero.android.location.LayerSourceProvider;
import org.maphero.android.location.LocationAnimatorCoordinator;
import org.maphero.android.location.LocationCameraController;
import org.maphero.android.location.LocationComponentActivationOptions;
import org.maphero.android.location.LocationComponentCompassEngine;
import org.maphero.android.location.LocationComponentNotInitializedException;
import org.maphero.android.location.LocationComponentOptions;
import org.maphero.android.location.LocationLayerController;
import org.maphero.android.location.MapHeroAnimatorProvider;
import org.maphero.android.location.MapHeroAnimatorSetProvider;
import org.maphero.android.location.OnCameraMoveInvalidateListener;
import org.maphero.android.location.OnCameraTrackingChangedListener;
import org.maphero.android.location.OnLocationCameraTransitionListener;
import org.maphero.android.location.OnLocationClickListener;
import org.maphero.android.location.OnLocationLongClickListener;
import org.maphero.android.location.OnLocationStaleListener;
import org.maphero.android.location.OnRenderModeChangedListener;
import org.maphero.android.location.StaleStateManager;
import org.maphero.android.location.Utils;
import org.maphero.android.location.engine.LocationEngine;
import org.maphero.android.location.engine.LocationEngineCallback;
import org.maphero.android.location.engine.LocationEngineDefault;
import org.maphero.android.location.engine.LocationEngineRequest;
import org.maphero.android.location.engine.LocationEngineResult;
import org.maphero.android.log.Logger;
import org.maphero.android.maps.MapHeroMap;
import org.maphero.android.maps.Style;
import org.maphero.android.maps.Transform;

public final class LocationComponent {
    private static final String TAG = "Mbgl-LocationComponent";
    @NonNull
    private final MapHeroMap mapHeroMap;
    @NonNull
    private final Transform transform;
    private Style style;
    private LocationComponentOptions options;
    @Nullable
    private LocationEngine locationEngine;
    @NonNull
    private LocationEngineRequest locationEngineRequest = new LocationEngineRequest.Builder(1000L).setFastestInterval(1000L).setPriority(0).build();
    private LocationEngineCallback<LocationEngineResult> currentLocationEngineListener = new CurrentLocationEngineCallback(this);
    private LocationEngineCallback<LocationEngineResult> lastLocationEngineListener = new LastLocationEngineCallback(this);
    @Nullable
    private CompassEngine compassEngine;
    private LocationLayerController locationLayerController;
    private LocationCameraController locationCameraController;
    private LocationAnimatorCoordinator locationAnimatorCoordinator;
    @Nullable
    private Location lastLocation;
    private CameraPosition lastCameraPosition;
    private boolean isComponentInitialized;
    private boolean useSpecializedLocationLayer;
    private boolean isEnabled;
    private boolean isComponentStarted;
    private boolean isLayerReady;
    private boolean isListeningToCompass;
    private StaleStateManager staleStateManager;
    private final CopyOnWriteArrayList<OnLocationStaleListener> onLocationStaleListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationClickListener> onLocationClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnLocationLongClickListener> onLocationLongClickListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnCameraTrackingChangedListener> onCameraTrackingChangedListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<OnRenderModeChangedListener> onRenderModeChangedListeners = new CopyOnWriteArrayList();
    private long fastestInterval;
    private long lastUpdateTime;
    @NonNull
    private MapHeroMap.OnCameraMoveListener onCameraMoveListener = new MapHeroMap.OnCameraMoveListener(){

        @Override
        public void onCameraMove() {
            LocationComponent.this.updateLayerOffsets(false);
        }
    };
    @NonNull
    private MapHeroMap.OnCameraIdleListener onCameraIdleListener = new MapHeroMap.OnCameraIdleListener(){

        @Override
        public void onCameraIdle() {
            LocationComponent.this.updateLayerOffsets(false);
        }
    };
    @NonNull
    private MapHeroMap.OnMapClickListener onMapClickListener = new MapHeroMap.OnMapClickListener(){

        @Override
        public boolean onMapClick(@NonNull LatLng point) {
            if (!LocationComponent.this.onLocationClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick(point)) {
                for (OnLocationClickListener listener : LocationComponent.this.onLocationClickListeners) {
                    listener.onLocationComponentClick();
                }
                return true;
            }
            return false;
        }
    };
    @NonNull
    private MapHeroMap.OnMapLongClickListener onMapLongClickListener = new MapHeroMap.OnMapLongClickListener(){

        @Override
        public boolean onMapLongClick(@NonNull LatLng point) {
            if (!LocationComponent.this.onLocationLongClickListeners.isEmpty() && LocationComponent.this.locationLayerController.onMapClick(point)) {
                for (OnLocationLongClickListener listener : LocationComponent.this.onLocationLongClickListeners) {
                    listener.onLocationComponentLongClick();
                }
                return true;
            }
            return false;
        }
    };
    @NonNull
    private OnLocationStaleListener onLocationStaleListener = new OnLocationStaleListener(){

        @Override
        public void onStaleStateChange(boolean isStale) {
            LocationComponent.this.locationLayerController.setLocationsStale(isStale);
            for (OnLocationStaleListener listener : LocationComponent.this.onLocationStaleListeners) {
                listener.onStaleStateChange(isStale);
            }
        }
    };
    @NonNull
    private OnCameraMoveInvalidateListener onCameraMoveInvalidateListener = new OnCameraMoveInvalidateListener(){

        @Override
        public void onInvalidateCameraMove() {
            LocationComponent.this.onCameraMoveListener.onCameraMove();
        }
    };
    @NonNull
    private CompassListener compassListener = new CompassListener(){

        @Override
        public void onCompassChanged(float userHeading) {
            LocationComponent.this.updateCompassHeading(userHeading);
        }

        @Override
        public void onCompassAccuracyChange(int compassStatus) {
        }
    };
    @NonNull
    @VisibleForTesting
    OnCameraTrackingChangedListener cameraTrackingChangedListener = new OnCameraTrackingChangedListener(){

        @Override
        public void onCameraTrackingDismissed() {
            for (OnCameraTrackingChangedListener listener : LocationComponent.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingDismissed();
            }
        }

        @Override
        public void onCameraTrackingChanged(int currentMode) {
            LocationComponent.this.locationAnimatorCoordinator.cancelZoomAnimation();
            LocationComponent.this.locationAnimatorCoordinator.cancelTiltAnimation();
            LocationComponent.this.updateAnimatorListenerHolders();
            for (OnCameraTrackingChangedListener listener : LocationComponent.this.onCameraTrackingChangedListeners) {
                listener.onCameraTrackingChanged(currentMode);
            }
        }
    };
    @NonNull
    @VisibleForTesting
    OnRenderModeChangedListener renderModeChangedListener = new OnRenderModeChangedListener(){

        @Override
        public void onRenderModeChanged(int currentMode) {
            LocationComponent.this.updateAnimatorListenerHolders();
            for (OnRenderModeChangedListener listener : LocationComponent.this.onRenderModeChangedListeners) {
                listener.onRenderModeChanged(currentMode);
            }
        }
    };
    @NonNull
    private final MapHeroMap.OnDeveloperAnimationListener developerAnimationListener = new MapHeroMap.OnDeveloperAnimationListener(){

        @Override
        public void onDeveloperAnimationStarted() {
            if (LocationComponent.this.isComponentInitialized && LocationComponent.this.isEnabled) {
                LocationComponent.this.setCameraMode(8);
            }
        }
    };

    public LocationComponent(@NonNull MapHeroMap mapHeroMap, @NonNull Transform transform, @NonNull List<MapHeroMap.OnDeveloperAnimationListener> developerAnimationListeners) {
        this.mapHeroMap = mapHeroMap;
        this.transform = transform;
        developerAnimationListeners.add(this.developerAnimationListener);
    }

    LocationComponent() {
        this.mapHeroMap = null;
        this.transform = null;
    }

    @VisibleForTesting
    LocationComponent(@NonNull MapHeroMap mapHeroMap, @NonNull Transform transform, @NonNull List<MapHeroMap.OnDeveloperAnimationListener> developerAnimationListeners, @NonNull LocationEngineCallback<LocationEngineResult> currentListener, @NonNull LocationEngineCallback<LocationEngineResult> lastListener, @NonNull LocationLayerController locationLayerController, @NonNull LocationCameraController locationCameraController, @NonNull LocationAnimatorCoordinator locationAnimatorCoordinator, @NonNull StaleStateManager staleStateManager, @NonNull CompassEngine compassEngine, boolean useSpecializedLocationLayer) {
        this.mapHeroMap = mapHeroMap;
        this.transform = transform;
        developerAnimationListeners.add(this.developerAnimationListener);
        this.currentLocationEngineListener = currentListener;
        this.lastLocationEngineListener = lastListener;
        this.locationLayerController = locationLayerController;
        this.locationCameraController = locationCameraController;
        this.locationAnimatorCoordinator = locationAnimatorCoordinator;
        this.staleStateManager = staleStateManager;
        this.compassEngine = compassEngine;
        this.useSpecializedLocationLayer = useSpecializedLocationLayer;
        this.isComponentInitialized = true;
    }

    public void activateLocationComponent(@NonNull LocationComponentActivationOptions activationOptions) {
        LocationEngine locationEngine;
        LocationComponentOptions options = activationOptions.locationComponentOptions();
        if (options == null) {
            int styleRes = activationOptions.styleRes();
            if (styleRes == 0) {
                styleRes = R.style.maphero_LocationComponent;
            }
            options = LocationComponentOptions.createFromAttributes(activationOptions.context(), styleRes);
        }
        this.initialize(activationOptions.context(), activationOptions.style(), activationOptions.useSpecializedLocationLayer(), options);
        this.applyStyle(options);
        LocationEngineRequest locationEngineRequest = activationOptions.locationEngineRequest();
        if (locationEngineRequest != null) {
            this.setLocationEngineRequest(locationEngineRequest);
        }
        if ((locationEngine = activationOptions.locationEngine()) != null) {
            this.setLocationEngine(locationEngine);
        } else if (activationOptions.useDefaultLocationEngine()) {
            this.setLocationEngine(LocationEngineDefault.INSTANCE.getDefaultLocationEngine(activationOptions.context()));
        } else {
            this.setLocationEngine(null);
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"})
    public void setLocationComponentEnabled(boolean isEnabled) {
        this.checkActivationState();
        if (isEnabled) {
            this.enableLocationComponent();
        } else {
            this.disableLocationComponent();
        }
        this.locationCameraController.setEnabled(isEnabled);
    }

    public boolean isLocationComponentEnabled() {
        this.checkActivationState();
        return this.isEnabled;
    }

    public void setCameraMode(int cameraMode) {
        this.setCameraMode(cameraMode, null);
    }

    public void setCameraMode(int cameraMode, @Nullable OnLocationCameraTransitionListener transitionListener) {
        this.setCameraMode(cameraMode, 750L, null, null, null, transitionListener);
    }

    public void setCameraMode(int cameraMode, long transitionDuration, @Nullable Double zoom, @Nullable Double bearing, @Nullable Double tilt, @Nullable OnLocationCameraTransitionListener transitionListener) {
        this.checkActivationState();
        this.locationCameraController.setCameraMode(cameraMode, this.lastLocation, transitionDuration, zoom, bearing, tilt, new CameraTransitionListener(transitionListener));
        this.updateCompassListenerState(true);
    }

    public int getCameraMode() {
        this.checkActivationState();
        return this.locationCameraController.getCameraMode();
    }

    public void setRenderMode(int renderMode) {
        this.checkActivationState();
        if (this.lastLocation != null && renderMode == 8) {
            this.locationAnimatorCoordinator.cancelAndRemoveGpsBearingAnimation();
            this.locationLayerController.setGpsBearing(this.lastLocation.getBearing());
        }
        this.locationLayerController.setRenderMode(renderMode);
        this.updateLayerOffsets(true);
        this.updateCompassListenerState(true);
    }

    public int getRenderMode() {
        this.checkActivationState();
        return this.locationLayerController.getRenderMode();
    }

    public LocationComponentOptions getLocationComponentOptions() {
        this.checkActivationState();
        return this.options;
    }

    public void applyStyle(@NonNull Context context, @StyleRes int styleRes) {
        this.checkActivationState();
        this.applyStyle(LocationComponentOptions.createFromAttributes(context, styleRes));
    }

    public void applyStyle(@NonNull LocationComponentOptions options) {
        this.checkActivationState();
        this.options = options;
        if (this.mapHeroMap.getStyle() != null) {
            this.locationLayerController.applyStyle(options);
            this.locationCameraController.initializeOptions(options);
            this.staleStateManager.setEnabled(options.enableStaleState());
            this.staleStateManager.setDelayTime(options.staleStateTimeout());
            this.locationAnimatorCoordinator.setTrackingAnimationDurationMultiplier(options.trackingAnimationDurationMultiplier());
            this.locationAnimatorCoordinator.setCompassAnimationEnabled(options.compassAnimationEnabled());
            this.locationAnimatorCoordinator.setAccuracyAnimationEnabled(options.accuracyAnimationEnabled());
            if (options.pulseEnabled().booleanValue()) {
                this.startPulsingLocationCircle();
            } else {
                this.stopPulsingLocationCircle();
            }
            this.updateMapWithOptions(options);
        }
    }

    private void startPulsingLocationCircle() {
        if (this.isEnabled && this.isLayerReady) {
            this.locationAnimatorCoordinator.startLocationComponentCirclePulsing(this.options);
            this.locationLayerController.adjustPulsingCircleLayerVisibility(true);
        }
    }

    public void zoomWhileTracking(double zoomLevel, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(callback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(callback, String.format("%s%s", "LocationComponent#zoomWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(callback, "LocationComponent#zoomWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewZoomLevel(zoomLevel, this.mapHeroMap.getCameraPosition(), animationDuration, callback);
    }

    public void zoomWhileTracking(double zoomLevel, long animationDuration) {
        this.checkActivationState();
        this.zoomWhileTracking(zoomLevel, animationDuration, null);
    }

    public void zoomWhileTracking(double zoomLevel) {
        this.checkActivationState();
        this.zoomWhileTracking(zoomLevel, 750L, null);
    }

    public void cancelZoomWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelZoomAnimation();
    }

    public void paddingWhileTracking(double[] padding) {
        this.paddingWhileTracking(padding, 750L, null);
    }

    public void paddingWhileTracking(double[] padding, long animationDuration) {
        this.paddingWhileTracking(padding, animationDuration, null);
    }

    public void paddingWhileTracking(double[] padding, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(callback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(callback, String.format("%s%s", "LocationComponent#paddingWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(callback, "LocationComponent#paddingWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewPadding(padding, this.mapHeroMap.getCameraPosition(), animationDuration, callback);
    }

    public void cancelPaddingWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelPaddingAnimation();
    }

    public void tiltWhileTracking(double tilt, long animationDuration, @Nullable MapHeroMap.CancelableCallback callback) {
        this.checkActivationState();
        if (!this.isLayerReady) {
            this.notifyUnsuccessfulCameraOperation(callback, null);
            return;
        }
        if (this.getCameraMode() == 8) {
            this.notifyUnsuccessfulCameraOperation(callback, String.format("%s%s", "LocationComponent#tiltWhileTracking method can only be used", " when a camera mode other than CameraMode#NONE is engaged."));
            return;
        }
        if (this.locationCameraController.isTransitioning()) {
            this.notifyUnsuccessfulCameraOperation(callback, "LocationComponent#tiltWhileTracking method call is ignored because the camera mode is transitioning");
            return;
        }
        this.locationAnimatorCoordinator.feedNewTilt(tilt, this.mapHeroMap.getCameraPosition(), animationDuration, callback);
    }

    public void tiltWhileTracking(double tilt, long animationDuration) {
        this.checkActivationState();
        this.tiltWhileTracking(tilt, animationDuration, null);
    }

    public void tiltWhileTracking(double tilt) {
        this.checkActivationState();
        this.tiltWhileTracking(tilt, 1250L, null);
    }

    public void cancelTiltWhileTrackingAnimation() {
        this.checkActivationState();
        this.locationAnimatorCoordinator.cancelTiltAnimation();
    }

    public void forceLocationUpdate(@Nullable Location location) {
        this.checkActivationState();
        this.updateLocation(location, false);
    }

    public void forceLocationUpdate(@Nullable List<Location> locations, boolean lookAheadUpdate) {
        this.checkActivationState();
        if (locations != null && locations.size() >= 1) {
            this.updateLocation(locations.get(locations.size() - 1), locations.subList(0, locations.size() - 1), false, lookAheadUpdate);
        } else {
            this.updateLocation(null, false);
        }
    }

    public void setMaxAnimationFps(int maxAnimationFps) {
        this.checkActivationState();
        this.locationAnimatorCoordinator.setMaxAnimationFps(maxAnimationFps);
    }

    @SuppressLint(value={"MissingPermission"})
    public void setLocationEngine(@Nullable LocationEngine locationEngine) {
        this.checkActivationState();
        if (this.locationEngine != null) {
            this.locationEngine.removeLocationUpdates(this.currentLocationEngineListener);
            this.locationEngine = null;
        }
        if (locationEngine != null) {
            this.fastestInterval = this.locationEngineRequest.getFastestInterval();
            this.locationEngine = locationEngine;
            if (this.isLayerReady && this.isEnabled) {
                this.setLastLocation();
                locationEngine.requestLocationUpdates(this.locationEngineRequest, this.currentLocationEngineListener, Looper.getMainLooper());
            }
        } else {
            this.fastestInterval = 0L;
        }
    }

    public void setLocationEngineRequest(@NonNull LocationEngineRequest locationEngineRequest) {
        this.checkActivationState();
        this.locationEngineRequest = locationEngineRequest;
        this.setLocationEngine(this.locationEngine);
    }

    @NonNull
    public LocationEngineRequest getLocationEngineRequest() {
        this.checkActivationState();
        return this.locationEngineRequest;
    }

    @Nullable
    public LocationEngine getLocationEngine() {
        this.checkActivationState();
        return this.locationEngine;
    }

    public void setCompassEngine(@Nullable CompassEngine compassEngine) {
        this.checkActivationState();
        if (this.compassEngine != null) {
            this.updateCompassListenerState(false);
        }
        this.compassEngine = compassEngine;
        this.updateCompassListenerState(true);
    }

    @Nullable
    public CompassEngine getCompassEngine() {
        this.checkActivationState();
        return this.compassEngine;
    }

    @Nullable
    public Location getLastKnownLocation() {
        this.checkActivationState();
        return this.lastLocation;
    }

    public void addOnLocationClickListener(@NonNull OnLocationClickListener listener) {
        this.onLocationClickListeners.add(listener);
    }

    public void removeOnLocationClickListener(@NonNull OnLocationClickListener listener) {
        this.onLocationClickListeners.remove(listener);
    }

    public void addOnLocationLongClickListener(@NonNull OnLocationLongClickListener listener) {
        this.onLocationLongClickListeners.add(listener);
    }

    public void removeOnLocationLongClickListener(@NonNull OnLocationLongClickListener listener) {
        this.onLocationLongClickListeners.remove(listener);
    }

    public void addOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.add(listener);
    }

    public void removeOnCameraTrackingChangedListener(@NonNull OnCameraTrackingChangedListener listener) {
        this.onCameraTrackingChangedListeners.remove(listener);
    }

    public void addOnRenderModeChangedListener(@NonNull OnRenderModeChangedListener listener) {
        this.onRenderModeChangedListeners.add(listener);
    }

    public void removeRenderModeChangedListener(@NonNull OnRenderModeChangedListener listener) {
        this.onRenderModeChangedListeners.remove(listener);
    }

    public void addOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.add(listener);
    }

    public void removeOnLocationStaleListener(@NonNull OnLocationStaleListener listener) {
        this.onLocationStaleListeners.remove(listener);
    }

    public void onStart() {
        this.isComponentStarted = true;
        this.onLocationLayerStart();
    }

    public void onStop() {
        this.onLocationLayerStop();
        this.isComponentStarted = false;
    }

    public void onDestroy() {
    }

    public void onStartLoadingMap() {
        this.onLocationLayerStop();
    }

    public void onFinishLoadingStyle() {
        if (this.isComponentInitialized) {
            this.style = this.mapHeroMap.getStyle();
            this.locationLayerController.initializeComponents(this.style, this.options);
            this.locationCameraController.initializeOptions(this.options);
            this.onLocationLayerStart();
        }
    }

    private void stopPulsingLocationCircle() {
        this.locationAnimatorCoordinator.stopPulsingCircleAnimation();
        this.locationLayerController.adjustPulsingCircleLayerVisibility(false);
    }

    @SuppressLint(value={"MissingPermission"})
    private void onLocationLayerStart() {
        if (!this.isComponentInitialized || !this.isComponentStarted || this.mapHeroMap.getStyle() == null) {
            return;
        }
        if (!this.isLayerReady) {
            this.isLayerReady = true;
            this.mapHeroMap.addOnCameraMoveListener(this.onCameraMoveListener);
            this.mapHeroMap.addOnCameraIdleListener(this.onCameraIdleListener);
            if (this.options.enableStaleState()) {
                this.staleStateManager.onStart();
            }
        }
        if (this.isEnabled) {
            if (this.locationEngine != null) {
                try {
                    this.locationEngine.requestLocationUpdates(this.locationEngineRequest, this.currentLocationEngineListener, Looper.getMainLooper());
                }
                catch (SecurityException se) {
                    Logger.e(TAG, "Unable to request location updates", se);
                }
            }
            this.setCameraMode(this.locationCameraController.getCameraMode());
            if (this.options.pulseEnabled().booleanValue()) {
                this.startPulsingLocationCircle();
            } else {
                this.stopPulsingLocationCircle();
            }
            this.setLastLocation();
            this.updateCompassListenerState(true);
            this.setLastCompassHeading();
        }
    }

    private void onLocationLayerStop() {
        if (!(this.isComponentInitialized && this.isLayerReady && this.isComponentStarted)) {
            return;
        }
        this.isLayerReady = false;
        this.staleStateManager.onStop();
        if (this.compassEngine != null) {
            this.updateCompassListenerState(false);
        }
        this.stopPulsingLocationCircle();
        this.locationAnimatorCoordinator.cancelAllAnimations();
        if (this.locationEngine != null) {
            this.locationEngine.removeLocationUpdates(this.currentLocationEngineListener);
        }
        this.mapHeroMap.removeOnCameraMoveListener(this.onCameraMoveListener);
        this.mapHeroMap.removeOnCameraIdleListener(this.onCameraIdleListener);
    }

    private void initialize(@NonNull Context context, @NonNull Style style2, boolean useSpecializedLocationLayer, @NonNull LocationComponentOptions options) {
        if (this.isComponentInitialized) {
            return;
        }
        this.isComponentInitialized = true;
        if (!style2.isFullyLoaded()) {
            throw new IllegalStateException("Style is invalid, provide the most recently loaded one.");
        }
        this.style = style2;
        this.options = options;
        this.useSpecializedLocationLayer = useSpecializedLocationLayer;
        this.mapHeroMap.addOnMapClickListener(this.onMapClickListener);
        this.mapHeroMap.addOnMapLongClickListener(this.onMapLongClickListener);
        LayerSourceProvider sourceProvider = new LayerSourceProvider();
        LayerFeatureProvider featureProvider = new LayerFeatureProvider();
        LayerBitmapProvider bitmapProvider = new LayerBitmapProvider(context);
        this.locationLayerController = new LocationLayerController(this.mapHeroMap, style2, sourceProvider, featureProvider, bitmapProvider, options, this.renderModeChangedListener, useSpecializedLocationLayer);
        this.locationCameraController = new LocationCameraController(context, this.mapHeroMap, this.transform, this.cameraTrackingChangedListener, options, this.onCameraMoveInvalidateListener);
        this.locationAnimatorCoordinator = new LocationAnimatorCoordinator(this.mapHeroMap.getProjection(), MapHeroAnimatorSetProvider.getInstance(), MapHeroAnimatorProvider.getInstance());
        this.locationAnimatorCoordinator.setTrackingAnimationDurationMultiplier(options.trackingAnimationDurationMultiplier());
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        if (windowManager != null && sensorManager != null) {
            this.compassEngine = new LocationComponentCompassEngine(windowManager, sensorManager);
        }
        this.staleStateManager = new StaleStateManager(this.onLocationStaleListener, options);
        this.updateMapWithOptions(options);
        this.setRenderMode(18);
        this.setCameraMode(8);
        this.onLocationLayerStart();
    }

    private void updateCompassListenerState(boolean canListen) {
        if (this.compassEngine != null) {
            if (!canListen) {
                this.removeCompassListener(this.compassEngine);
                return;
            }
            if (!(this.isComponentInitialized && this.isComponentStarted && this.isEnabled && this.isLayerReady)) {
                return;
            }
            if (this.locationCameraController.isConsumingCompass() || this.locationLayerController.isConsumingCompass()) {
                if (!this.isListeningToCompass) {
                    this.isListeningToCompass = true;
                    this.compassEngine.addCompassListener(this.compassListener);
                }
            } else {
                this.removeCompassListener(this.compassEngine);
            }
        }
    }

    private void removeCompassListener(@NonNull CompassEngine engine) {
        if (this.isListeningToCompass) {
            this.isListeningToCompass = false;
            engine.removeCompassListener(this.compassListener);
        }
    }

    private void enableLocationComponent() {
        this.isEnabled = true;
        this.onLocationLayerStart();
    }

    private void disableLocationComponent() {
        this.isEnabled = false;
        this.locationLayerController.hide();
        this.onLocationLayerStop();
    }

    private void updateMapWithOptions(@NonNull LocationComponentOptions options) {
        int[] padding = options.padding();
        if (padding != null) {
            this.mapHeroMap.setPadding(padding[0], padding[1], padding[2], padding[3]);
        }
    }

    private void updateLocation(@Nullable Location location, boolean fromLastLocation) {
        this.updateLocation(location, null, fromLastLocation, false);
    }

    private void updateLocation(@Nullable Location location, @Nullable List<Location> intermediatePoints, boolean fromLastLocation, boolean lookAheadUpdate) {
        boolean isGpsNorth;
        if (location == null) {
            return;
        }
        if (!this.isLayerReady) {
            this.lastLocation = location;
            return;
        }
        long currentTime = SystemClock.elapsedRealtime();
        if (currentTime - this.lastUpdateTime < this.fastestInterval) {
            return;
        }
        this.lastUpdateTime = currentTime;
        this.showLocationLayerIfHidden();
        if (!fromLastLocation) {
            this.staleStateManager.updateLatestLocationTime();
        }
        CameraPosition currentCameraPosition = this.mapHeroMap.getCameraPosition();
        boolean bl = isGpsNorth = this.getCameraMode() == 36;
        if (intermediatePoints != null) {
            this.locationAnimatorCoordinator.feedNewLocation(this.getTargetLocationWithIntermediates(location, intermediatePoints), currentCameraPosition, isGpsNorth, lookAheadUpdate);
        } else {
            this.locationAnimatorCoordinator.feedNewLocation(location, currentCameraPosition, isGpsNorth);
        }
        this.updateAccuracyRadius(location, false);
        this.lastLocation = location;
    }

    private Location[] getTargetLocationWithIntermediates(Location location, List<Location> intermediatePoints) {
        Location[] locations = new Location[intermediatePoints.size() + 1];
        locations[locations.length - 1] = location;
        for (int i = 0; i < intermediatePoints.size(); ++i) {
            locations[i] = intermediatePoints.get(i);
        }
        return locations;
    }

    private void showLocationLayerIfHidden() {
        boolean isLocationLayerHidden = this.locationLayerController.isHidden();
        if (this.isEnabled && this.isComponentStarted && isLocationLayerHidden) {
            this.locationLayerController.show();
            if (this.options.pulseEnabled().booleanValue()) {
                this.locationLayerController.adjustPulsingCircleLayerVisibility(true);
            }
        }
    }

    private void updateCompassHeading(float heading) {
        this.locationAnimatorCoordinator.feedNewCompassBearing(heading, this.mapHeroMap.getCameraPosition());
    }

    @SuppressLint(value={"MissingPermission"})
    private void setLastLocation() {
        if (this.locationEngine != null) {
            this.locationEngine.getLastLocation(this.lastLocationEngineListener);
        } else {
            this.updateLocation(this.getLastKnownLocation(), true);
        }
    }

    private void setLastCompassHeading() {
        this.updateCompassHeading(this.compassEngine != null ? this.compassEngine.getLastHeading() : 0.0f);
    }

    @SuppressLint(value={"MissingPermission"})
    private void updateLayerOffsets(boolean forceUpdate) {
        if (this.useSpecializedLocationLayer) {
            return;
        }
        CameraPosition position = this.mapHeroMap.getCameraPosition();
        if (this.lastCameraPosition == null || forceUpdate) {
            this.lastCameraPosition = position;
            this.locationLayerController.cameraBearingUpdated(position.bearing);
            this.locationLayerController.cameraTiltUpdated(position.tilt);
            this.updateAccuracyRadius(this.getLastKnownLocation(), true);
            return;
        }
        if (position.bearing != this.lastCameraPosition.bearing) {
            this.locationLayerController.cameraBearingUpdated(position.bearing);
        }
        if (position.tilt != this.lastCameraPosition.tilt) {
            this.locationLayerController.cameraTiltUpdated(position.tilt);
        }
        if (position.zoom != this.lastCameraPosition.zoom) {
            this.updateAccuracyRadius(this.getLastKnownLocation(), true);
        }
        this.lastCameraPosition = position;
    }

    private void updateAccuracyRadius(Location location, boolean noAnimation) {
        float radius = location == null ? 0.0f : (this.useSpecializedLocationLayer ? location.getAccuracy() : Utils.calculateZoomLevelRadius(this.mapHeroMap, location));
        this.locationAnimatorCoordinator.feedNewAccuracyRadius(radius, noAnimation);
    }

    private void updateAnimatorListenerHolders() {
        HashSet<AnimatorListenerHolder> animationsValueChangeListeners = new HashSet<AnimatorListenerHolder>();
        animationsValueChangeListeners.addAll(this.locationLayerController.getAnimationListeners());
        animationsValueChangeListeners.addAll(this.locationCameraController.getAnimationListeners());
        this.locationAnimatorCoordinator.updateAnimatorListenerHolders(animationsValueChangeListeners);
        this.locationAnimatorCoordinator.resetAllCameraAnimations(this.mapHeroMap.getCameraPosition(), this.locationCameraController.getCameraMode() == 36);
        this.locationAnimatorCoordinator.resetAllLayerAnimations();
    }

    private void checkActivationState() {
        if (!this.isComponentInitialized) {
            throw new LocationComponentNotInitializedException();
        }
    }

    private void notifyUnsuccessfulCameraOperation(@Nullable MapHeroMap.CancelableCallback callback, @Nullable String msg) {
        if (msg != null) {
            Logger.e(TAG, msg);
        }
        if (callback != null) {
            callback.onCancel();
        }
    }

    public boolean isLocationComponentActivated() {
        return this.isComponentInitialized;
    }

    @VisibleForTesting
    static final class CurrentLocationEngineCallback
    implements LocationEngineCallback<LocationEngineResult> {
        private final WeakReference<LocationComponent> componentWeakReference;

        CurrentLocationEngineCallback(LocationComponent component) {
            this.componentWeakReference = new WeakReference<LocationComponent>(component);
        }

        @Override
        public void onSuccess(LocationEngineResult result) {
            LocationComponent component = (LocationComponent)this.componentWeakReference.get();
            if (component != null) {
                component.updateLocation(result.getLastLocation(), false);
            }
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            Logger.e(LocationComponent.TAG, "Failed to obtain location update", exception);
        }
    }

    @VisibleForTesting
    static final class LastLocationEngineCallback
    implements LocationEngineCallback<LocationEngineResult> {
        private final WeakReference<LocationComponent> componentWeakReference;

        LastLocationEngineCallback(LocationComponent component) {
            this.componentWeakReference = new WeakReference<LocationComponent>(component);
        }

        @Override
        public void onSuccess(LocationEngineResult result) {
            LocationComponent component = (LocationComponent)this.componentWeakReference.get();
            if (component != null) {
                component.updateLocation(result.getLastLocation(), true);
            }
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            Logger.e(LocationComponent.TAG, "Failed to obtain last location update", exception);
        }
    }

    private class CameraTransitionListener
    implements OnLocationCameraTransitionListener {
        private final OnLocationCameraTransitionListener externalListener;

        private CameraTransitionListener(OnLocationCameraTransitionListener externalListener) {
            this.externalListener = externalListener;
        }

        @Override
        public void onLocationCameraTransitionFinished(int cameraMode) {
            if (this.externalListener != null) {
                this.externalListener.onLocationCameraTransitionFinished(cameraMode);
            }
            this.reset(cameraMode);
        }

        @Override
        public void onLocationCameraTransitionCanceled(int cameraMode) {
            if (this.externalListener != null) {
                this.externalListener.onLocationCameraTransitionCanceled(cameraMode);
            }
            this.reset(cameraMode);
        }

        private void reset(int cameraMode) {
            LocationComponent.this.locationAnimatorCoordinator.resetAllCameraAnimations(LocationComponent.this.mapHeroMap.getCameraPosition(), cameraMode == 36);
        }
    }
}

