/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import android.animation.TimeInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.Nullable;
import org.maphero.android.geometry.LatLng;
import org.maphero.android.location.MapHeroAnimator;
import org.maphero.android.location.MapHeroCameraAnimatorAdapter;
import org.maphero.android.location.MapHeroFloatAnimator;
import org.maphero.android.location.MapHeroLatLngAnimator;
import org.maphero.android.location.MapHeroPaddingAnimator;
import org.maphero.android.location.PulsingLocationCircleAnimator;
import org.maphero.android.maps.MapHeroMap;

final class MapHeroAnimatorProvider {
    private static MapHeroAnimatorProvider INSTANCE;

    private MapHeroAnimatorProvider() {
    }

    public static MapHeroAnimatorProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapHeroAnimatorProvider();
        }
        return INSTANCE;
    }

    MapHeroLatLngAnimator latLngAnimator(LatLng[] values, MapHeroAnimator.AnimationsValueChangeListener updateListener, int maxAnimationFps) {
        return new MapHeroLatLngAnimator(values, updateListener, maxAnimationFps);
    }

    MapHeroFloatAnimator floatAnimator(Float[] values, MapHeroAnimator.AnimationsValueChangeListener updateListener, int maxAnimationFps) {
        return new MapHeroFloatAnimator(values, updateListener, maxAnimationFps);
    }

    MapHeroCameraAnimatorAdapter cameraAnimator(Float[] values, MapHeroAnimator.AnimationsValueChangeListener updateListener, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        return new MapHeroCameraAnimatorAdapter(values, updateListener, cancelableCallback);
    }

    MapHeroPaddingAnimator paddingAnimator(double[][] values, MapHeroAnimator.AnimationsValueChangeListener<double[]> updateListener, @Nullable MapHeroMap.CancelableCallback cancelableCallback) {
        return new MapHeroPaddingAnimator(values, updateListener, cancelableCallback);
    }

    PulsingLocationCircleAnimator pulsingCircleAnimator(MapHeroAnimator.AnimationsValueChangeListener updateListener, int maxAnimationFps, float pulseSingleDuration, float pulseMaxRadius, Interpolator pulseInterpolator) {
        PulsingLocationCircleAnimator pulsingLocationCircleAnimator = new PulsingLocationCircleAnimator(updateListener, maxAnimationFps, pulseMaxRadius);
        pulsingLocationCircleAnimator.setDuration((long)pulseSingleDuration);
        pulsingLocationCircleAnimator.setRepeatMode(1);
        pulsingLocationCircleAnimator.setRepeatCount(-1);
        pulsingLocationCircleAnimator.setInterpolator((TimeInterpolator)pulseInterpolator);
        return pulsingLocationCircleAnimator;
    }
}

