/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location;

import android.os.Handler;
import android.os.Message;
import androidx.annotation.NonNull;
import java.lang.ref.WeakReference;
import org.maphero.android.location.LocationComponentOptions;
import org.maphero.android.location.OnLocationStaleListener;

class StaleStateManager {
    private boolean isEnabled;
    private final OnLocationStaleListener innerOnLocationStaleListeners;
    @NonNull
    private final StaleMessageHandler handler;
    private boolean isStale = true;
    private long delayTime;
    private final int staleStateMessage = 1;

    StaleStateManager(OnLocationStaleListener innerListener, LocationComponentOptions options) {
        this.innerOnLocationStaleListeners = innerListener;
        this.handler = new StaleMessageHandler(this);
        this.isEnabled = options.enableStaleState();
        this.delayTime = options.staleStateTimeout();
    }

    void setEnabled(boolean enabled) {
        if (enabled) {
            this.setState(this.isStale);
        } else if (this.isEnabled) {
            this.onStop();
            this.innerOnLocationStaleListeners.onStaleStateChange(false);
        }
        this.isEnabled = enabled;
    }

    boolean isStale() {
        return this.isStale;
    }

    void updateLatestLocationTime() {
        this.setState(false);
        this.postTheCallback();
    }

    void setDelayTime(long delayTime) {
        this.delayTime = delayTime;
        if (this.handler.hasMessages(1)) {
            this.postTheCallback();
        }
    }

    void onStart() {
        if (!this.isStale) {
            this.postTheCallback();
        }
    }

    void onStop() {
        this.handler.removeCallbacksAndMessages(null);
    }

    private void postTheCallback() {
        this.handler.removeCallbacksAndMessages(null);
        this.handler.sendEmptyMessageDelayed(1, this.delayTime);
    }

    private void setState(boolean stale) {
        if (stale != this.isStale) {
            this.isStale = stale;
            if (this.isEnabled) {
                this.innerOnLocationStaleListeners.onStaleStateChange(stale);
            }
        }
    }

    private static class StaleMessageHandler
    extends Handler {
        private final WeakReference<StaleStateManager> managerWeakReference;

        private StaleMessageHandler(StaleStateManager staleStateManager) {
            this.managerWeakReference = new WeakReference<StaleStateManager>(staleStateManager);
        }

        public void handleMessage(Message msg) {
            StaleStateManager manager = (StaleStateManager)this.managerWeakReference.get();
            if (manager != null) {
                manager.setState(true);
            }
        }
    }
}

