/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.engine;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import org.maphero.android.location.engine.LocationEngineCallback;
import org.maphero.android.location.engine.LocationEngineImpl;
import org.maphero.android.location.engine.LocationEngineRequest;
import org.maphero.android.location.engine.LocationEngineResult;

public class AndroidLocationEngineImpl
implements LocationEngineImpl<LocationListener> {
    private static final String TAG = "AndroidLocationEngine";
    final LocationManager locationManager;
    String currentProvider = "passive";

    public AndroidLocationEngineImpl(@NonNull Context context) {
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    @Override
    @NonNull
    public LocationListener createListener(LocationEngineCallback<LocationEngineResult> callback) {
        return new AndroidLocationEngineCallbackTransport(callback);
    }

    @Override
    public void getLastLocation(@NonNull LocationEngineCallback<LocationEngineResult> callback) throws SecurityException {
        Location lastLocation = this.getLastLocationFor(this.currentProvider);
        if (lastLocation != null) {
            callback.onSuccess(LocationEngineResult.create(lastLocation));
            return;
        }
        for (String provider : this.locationManager.getAllProviders()) {
            lastLocation = this.getLastLocationFor(provider);
            if (lastLocation == null) continue;
            callback.onSuccess(LocationEngineResult.create(lastLocation));
            return;
        }
        callback.onFailure(new Exception("Last location unavailable"));
    }

    @SuppressLint(value={"MissingPermission"})
    Location getLastLocationFor(String provider) throws SecurityException {
        Location location = null;
        try {
            location = this.locationManager.getLastKnownLocation(provider);
        }
        catch (IllegalArgumentException iae) {
            Log.e((String)TAG, (String)iae.toString());
        }
        return location;
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull LocationListener listener, @Nullable Looper looper) throws SecurityException {
        this.currentProvider = this.getBestProvider(request.getPriority());
        this.locationManager.requestLocationUpdates(this.currentProvider, request.getInterval(), request.getDisplacement(), listener, looper);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void requestLocationUpdates(@NonNull LocationEngineRequest request, @NonNull PendingIntent pendingIntent) throws SecurityException {
        this.currentProvider = this.getBestProvider(request.getPriority());
        this.locationManager.requestLocationUpdates(this.currentProvider, request.getInterval(), request.getDisplacement(), pendingIntent);
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public void removeLocationUpdates(@NonNull LocationListener listener) {
        if (listener != null) {
            this.locationManager.removeUpdates(listener);
        }
    }

    @Override
    public void removeLocationUpdates(PendingIntent pendingIntent) {
        if (pendingIntent != null) {
            this.locationManager.removeUpdates(pendingIntent);
        }
    }

    private String getBestProvider(int priority) {
        String provider = null;
        if (priority != 3) {
            provider = this.locationManager.getBestProvider(AndroidLocationEngineImpl.getCriteria(priority), true);
        }
        return provider != null ? provider : "passive";
    }

    @VisibleForTesting
    static Criteria getCriteria(int priority) {
        Criteria criteria = new Criteria();
        criteria.setAccuracy(AndroidLocationEngineImpl.priorityToAccuracy(priority));
        criteria.setCostAllowed(true);
        criteria.setPowerRequirement(AndroidLocationEngineImpl.priorityToPowerRequirement(priority));
        return criteria;
    }

    private static int priorityToAccuracy(int priority) {
        switch (priority) {
            case 0: 
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    private static int priorityToPowerRequirement(int priority) {
        switch (priority) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    @VisibleForTesting
    static final class AndroidLocationEngineCallbackTransport
    implements LocationListener {
        private final LocationEngineCallback<LocationEngineResult> callback;

        AndroidLocationEngineCallbackTransport(LocationEngineCallback<LocationEngineResult> callback) {
            this.callback = callback;
        }

        public void onLocationChanged(Location location) {
            this.callback.onSuccess(LocationEngineResult.create(location));
        }

        public void onStatusChanged(String s, int i, Bundle bundle) {
        }

        public void onProviderEnabled(String s) {
        }

        public void onProviderDisabled(String s) {
            this.callback.onFailure(new Exception("Current provider disabled"));
        }
    }
}

