/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.engine;

import android.content.Intent;
import android.location.Location;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LocationEngineResult {
    private final List<Location> locations;

    private LocationEngineResult(List<Location> locations) {
        this.locations = Collections.unmodifiableList(locations);
    }

    @NonNull
    public static LocationEngineResult create(@Nullable Location location) {
        ArrayList<Location> locations = new ArrayList<Location>();
        if (location != null) {
            locations.add(location);
        }
        return new LocationEngineResult(locations);
    }

    @NonNull
    public static LocationEngineResult create(@Nullable List<Location> locations) {
        if (locations != null) {
            ArrayList<Location> locationsList = new ArrayList<Location>(locations);
            locationsList.removeAll(Collections.singleton(null));
            return new LocationEngineResult(locationsList);
        }
        return new LocationEngineResult(Collections.emptyList());
    }

    @Nullable
    public Location getLastLocation() {
        return this.locations.isEmpty() ? null : this.locations.get(0);
    }

    public List<Location> getLocations() {
        return Collections.unmodifiableList(this.locations);
    }

    @Nullable
    public static LocationEngineResult extractResult(Intent intent) {
        return LocationEngineResult.extractAndroidResult(intent);
    }

    private static LocationEngineResult extractAndroidResult(Intent intent) {
        return !LocationEngineResult.hasResult(intent) ? null : LocationEngineResult.create((Location)intent.getExtras().getParcelable("location"));
    }

    private static boolean hasResult(Intent intent) {
        return intent != null && intent.hasExtra("location");
    }
}

