/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.location.permissions;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.maphero.android.location.permissions.PermissionsListener;

public class PermissionsManager {
    private static final String LOG_TAG = "PermissionsManager";
    private static final String COARSE_LOCATION_PERMISSION = "android.permission.ACCESS_COARSE_LOCATION";
    private static final String FINE_LOCATION_PERMISSION = "android.permission.ACCESS_FINE_LOCATION";
    private static final String BACKGROUND_LOCATION_PERMISSION = "android.permission.ACCESS_BACKGROUND_LOCATION";
    private final int REQUEST_PERMISSIONS_CODE = 0;
    private PermissionsListener listener;

    public PermissionsManager(PermissionsListener listener) {
        this.listener = listener;
    }

    public PermissionsListener getListener() {
        return this.listener;
    }

    public void setListener(PermissionsListener listener) {
        this.listener = listener;
    }

    private static boolean isPermissionGranted(Context context, String permission2) {
        return ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
    }

    private static boolean isCoarseLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, COARSE_LOCATION_PERMISSION);
    }

    private static boolean isFineLocationPermissionGranted(Context context) {
        return PermissionsManager.isPermissionGranted(context, FINE_LOCATION_PERMISSION);
    }

    public static boolean isBackgroundLocationPermissionGranted(Context context) {
        if (Build.VERSION.SDK_INT >= 29) {
            return PermissionsManager.isPermissionGranted(context, BACKGROUND_LOCATION_PERMISSION);
        }
        return PermissionsManager.areLocationPermissionsGranted(context);
    }

    public static boolean areLocationPermissionsGranted(Context context) {
        return PermissionsManager.isCoarseLocationPermissionGranted(context) || PermissionsManager.isFineLocationPermissionGranted(context);
    }

    public static boolean areRuntimePermissionsRequired() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public void requestLocationPermissions(Activity activity) {
        try {
            PackageInfo packageInfo = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 4096);
            String[] requestedPermissions = packageInfo.requestedPermissions;
            if (requestedPermissions != null) {
                List<String> permissionList = Arrays.asList(requestedPermissions);
                boolean fineLocPermission = permissionList.contains(FINE_LOCATION_PERMISSION);
                boolean coarseLocPermission = permissionList.contains(COARSE_LOCATION_PERMISSION);
                boolean backgroundLocPermission = permissionList.contains(BACKGROUND_LOCATION_PERMISSION);
                if (fineLocPermission) {
                    this.requestLocationPermissions(activity, true, backgroundLocPermission);
                } else if (coarseLocPermission) {
                    this.requestLocationPermissions(activity, false, backgroundLocPermission);
                } else {
                    Log.w((String)LOG_TAG, (String)"Location permissions are missing");
                }
            }
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)exception.getMessage());
        }
    }

    private void requestLocationPermissions(Activity activity, boolean requestFineLocation, boolean requestBackgroundLocation) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestFineLocation) {
            permissions.add(FINE_LOCATION_PERMISSION);
        } else {
            permissions.add(COARSE_LOCATION_PERMISSION);
        }
        if (Build.VERSION.SDK_INT >= 29 && requestBackgroundLocation) {
            permissions.add(BACKGROUND_LOCATION_PERMISSION);
        }
        this.requestPermissions(activity, permissions.toArray(new String[permissions.size()]));
    }

    private void requestPermissions(Activity activity, String[] permissions) {
        ArrayList<String> permissionsToExplain = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) continue;
            permissionsToExplain.add(permission2);
        }
        if (this.listener != null && permissionsToExplain.size() > 0) {
            this.listener.onExplanationNeeded(permissionsToExplain);
        }
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)0);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 0: {
                if (this.listener == null) break;
                boolean granted = grantResults.length > 0 && grantResults[0] == 0;
                this.listener.onPermissionResult(granted);
                break;
            }
        }
    }
}

