/*
 * Decompiled with CFR 0.152.
 */
package org.maphero.android.maps;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.maphero.android.annotations.InfoWindow;
import org.maphero.android.annotations.Marker;
import org.maphero.android.maps.MapHeroMap;

class InfoWindowManager {
    private final List<InfoWindow> infoWindows = new ArrayList<InfoWindow>();
    @Nullable
    private MapHeroMap.InfoWindowAdapter infoWindowAdapter;
    private boolean allowConcurrentMultipleInfoWindows;
    @Nullable
    private MapHeroMap.OnInfoWindowClickListener onInfoWindowClickListener;
    @Nullable
    private MapHeroMap.OnInfoWindowLongClickListener onInfoWindowLongClickListener;
    @Nullable
    private MapHeroMap.OnInfoWindowCloseListener onInfoWindowCloseListener;

    InfoWindowManager() {
    }

    void update() {
        if (!this.infoWindows.isEmpty()) {
            for (InfoWindow infoWindow : this.infoWindows) {
                infoWindow.update();
            }
        }
    }

    void setInfoWindowAdapter(@Nullable MapHeroMap.InfoWindowAdapter infoWindowAdapter) {
        this.infoWindowAdapter = infoWindowAdapter;
    }

    @Nullable
    MapHeroMap.InfoWindowAdapter getInfoWindowAdapter() {
        return this.infoWindowAdapter;
    }

    void setAllowConcurrentMultipleOpenInfoWindows(boolean allow) {
        this.allowConcurrentMultipleInfoWindows = allow;
    }

    boolean isAllowConcurrentMultipleOpenInfoWindows() {
        return this.allowConcurrentMultipleInfoWindows;
    }

    boolean isInfoWindowValidForMarker(@Nullable Marker marker) {
        return marker != null && (!TextUtils.isEmpty((CharSequence)marker.getTitle()) || !TextUtils.isEmpty((CharSequence)marker.getSnippet()));
    }

    void setOnInfoWindowClickListener(@Nullable MapHeroMap.OnInfoWindowClickListener listener) {
        this.onInfoWindowClickListener = listener;
    }

    @Nullable
    MapHeroMap.OnInfoWindowClickListener getOnInfoWindowClickListener() {
        return this.onInfoWindowClickListener;
    }

    void setOnInfoWindowLongClickListener(@Nullable MapHeroMap.OnInfoWindowLongClickListener listener) {
        this.onInfoWindowLongClickListener = listener;
    }

    @Nullable
    MapHeroMap.OnInfoWindowLongClickListener getOnInfoWindowLongClickListener() {
        return this.onInfoWindowLongClickListener;
    }

    void setOnInfoWindowCloseListener(@Nullable MapHeroMap.OnInfoWindowCloseListener listener) {
        this.onInfoWindowCloseListener = listener;
    }

    @Nullable
    MapHeroMap.OnInfoWindowCloseListener getOnInfoWindowCloseListener() {
        return this.onInfoWindowCloseListener;
    }

    public void add(InfoWindow infoWindow) {
        this.infoWindows.add(infoWindow);
    }
}

